/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import org.apache.sis.gui.Widget;

abstract class TabularWidget
extends Widget {
    private static final int CHECKBOX_WIDTH = 40;

    TabularWidget() {
    }

    static <S> TableView<S> newTable() {
        TableView table = new TableView();
        table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        table.setEditable(true);
        return table;
    }

    static <S> TableColumn<S, Boolean> newBooleanColumn(String header, Callback<TableColumn.CellDataFeatures<S, Boolean>, ObservableValue<Boolean>> factory) {
        TableColumn c = new TableColumn(header);
        c.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)c));
        c.setCellValueFactory(factory);
        c.setSortable(false);
        c.setResizable(false);
        c.setMinWidth(40.0);
        c.setMaxWidth(40.0);
        return c;
    }

    static <S> TableColumn<S, String> newStringColumn(String header, Callback<TableColumn.CellDataFeatures<S, String>, ObservableValue<String>> factory) {
        TableColumn c = new TableColumn(header);
        c.setCellFactory(TextFieldTableCell.forTableColumn());
        c.setCellValueFactory(factory);
        return c;
    }
}

