/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui.control;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.util.CharSequences;

final class FormatApplicator<T>
extends StringConverter<T>
implements EventHandler<ActionEvent>,
ChangeListener<Boolean> {
    private final Class<T> valueType;
    final Format format;
    InvalidationListener listener;

    public FormatApplicator(Class<T> valueType, Format format) {
        this.valueType = valueType;
        this.format = format;
    }

    public static FormatApplicator<Number> createNumberFormat() {
        FormatApplicator<Number> f = new FormatApplicator<Number>(Number.class, NumberFormat.getInstance());
        if (f.format instanceof DecimalFormat) {
            ((DecimalFormat)f.format).setParseBigDecimal(true);
        }
        return f;
    }

    public final void setListenersOn(TextField editor) {
        editor.focusedProperty().addListener((ChangeListener)this);
        editor.setOnAction((EventHandler)this);
    }

    private static boolean isNil(Object item) {
        return item == null || item instanceof Double && ((Double)item).isNaN();
    }

    public final String toString(T item) {
        return FormatApplicator.isNil(item) ? null : this.format.format(item);
    }

    public final void format(TextField editor, T item) {
        editor.setText(this.toString(item));
        FormatApplicator.setErrorFlag(editor, false);
    }

    public final T fromString(String text) {
        if (text == null || (text = text.trim()).isEmpty()) {
            return null;
        }
        try {
            return this.valueType.cast(this.format.parseObject(text));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final T parse(TextField editor) {
        int end;
        int start;
        String text = editor.getText();
        if (text != null && (start = CharSequences.skipLeadingWhitespaces(text, 0, end = CharSequences.skipTrailingWhitespaces(text, 0, text.length()))) < end) {
            ParsePosition pos = new ParsePosition(start);
            T value = this.valueType.cast(this.format.parseObject(text, pos));
            int stop = pos.getIndex();
            if (stop >= end && !FormatApplicator.isNil(value)) {
                FormatApplicator.setErrorFlag(editor, false);
                return value;
            }
            editor.positionCaret(value != null ? stop : pos.getErrorIndex());
        }
        if (text != null && !text.isEmpty()) {
            FormatApplicator.setErrorFlag(editor, true);
        }
        return null;
    }

    private void parseAndStore(TextField editor) {
        T newValue = this.parse(editor);
        editor.setUserData(newValue);
        if (this.listener != null) {
            this.listener.invalidated((Observable)editor.getProperties());
        }
    }

    public void handle(ActionEvent event) {
        this.parseAndStore((TextField)event.getSource());
    }

    public void changed(ObservableValue<? extends Boolean> property, Boolean oldValue, Boolean newValue) {
        TextField editor = (TextField)((ReadOnlyProperty)property).getBean();
        if (newValue.booleanValue()) {
            FormatApplicator.setErrorFlag(editor, false);
        } else {
            this.parseAndStore(editor);
        }
    }

    private static void setErrorFlag(TextField editor, boolean flag) {
        editor.pseudoClassStateChanged(Styles.ERROR, flag);
    }
}

