/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.util.Locale;
import org.apache.sis.internal.gui.PropertyValueFormats;
import org.apache.sis.internal.util.PropertyFormat;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;

public class PropertyValueFormatter
extends PropertyFormat {
    final PropertyValueFormats formats;

    public PropertyValueFormatter(Appendable buffer, Locale locale) {
        super(buffer);
        this.setLineSeparator(" \u00b6 ");
        this.formats = new PropertyValueFormats(locale);
    }

    @Override
    public final Locale getLocale() {
        return this.formats.getLocale();
    }

    @Override
    protected String toString(Object value) {
        String text = this.formats.formatValue(value, false);
        if (text != null) {
            return text;
        }
        return Classes.getShortClassName(value) + "(\u2026)";
    }

    @Override
    protected String freeText(String text) {
        return CharSequences.shortSentence(super.freeText(text), 100).toString();
    }
}

