/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.gui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Node;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.storage.io.ChannelFactory;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.internal.storage.io.InternalOptionKey;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.util.InternationalString;

public final class DataStoreOpener
extends Task<DataStore> {
    private static final Cache<Object, DataStore> CACHE = new Cache();
    private static volatile UnaryOperator<ChannelFactory> factoryWrapper;
    private final Object source;
    private final Object key;

    public DataStoreOpener(Object source) {
        this.source = source;
        try {
            if (source instanceof StorageConnector) {
                source = ((StorageConnector)source).getStorage();
            }
            if (source instanceof AutoCloseable) {
                source = null;
            } else {
                if (source instanceof File) {
                    source = ((File)source).getAbsoluteFile();
                    source = ((File)source).toPath();
                } else if (source instanceof URL) {
                    source = ((URL)source).toURI();
                }
                if (source instanceof URI) {
                    source = Paths.get((URI)source);
                }
                if (source instanceof Path) {
                    source = ((Path)source).toRealPath(new LinkOption[0]);
                }
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException exception) {
        }
        catch (RuntimeException | DataStoreException e) {
            source = null;
        }
        this.key = source;
    }

    public DataStore fromCache() {
        return this.key != null ? CACHE.peek(this.key) : null;
    }

    protected DataStore call() throws Exception {
        return this.key != null ? CACHE.getOrCreate(this.key, this::load) : this.load();
    }

    private DataStore load() throws DataStoreException {
        Object input = this.source;
        UnaryOperator<ChannelFactory> wrapper = factoryWrapper;
        if (wrapper != null) {
            StorageConnector connector = input instanceof StorageConnector ? (StorageConnector)input : new StorageConnector(input);
            connector.setOption((OptionKey)InternalOptionKey.CHANNEL_FACTORY_WRAPPER, wrapper);
            input = connector;
        }
        return DataStores.open((Object)input);
    }

    final String getFileName() {
        if (this.source instanceof StorageConnector) {
            return ((StorageConnector)this.source).getStorageName();
        }
        String name = IOUtilities.filename((Object)this.source);
        if (name == null) {
            name = Vocabulary.format((short)207);
        }
        return name;
    }

    public static void setFactoryWrapper(UnaryOperator<ChannelFactory> wrapper) {
        factoryWrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findLabel(Resource resource, Locale locale, boolean qualified) throws DataStoreException {
        block13: {
            if (resource != null) {
                Long logID = LogHandler.loadingStart(resource);
                try {
                    String t;
                    String name;
                    if (resource instanceof DataStore && (name = Strings.trimOrNull(((DataStore)resource).getDisplayName())) != null) {
                        String string = name;
                        return string;
                    }
                    name = resource.getIdentifier().orElse(null);
                    Collection identifications = null;
                    Metadata metadata = resource.getMetadata();
                    if (metadata != null && (identifications = metadata.getIdentificationInfo()) != null) {
                        for (Object identification : identifications) {
                            String t2;
                            Citation citation = identification.getCitation();
                            if (citation == null || (t2 = DataStoreOpener.string(citation.getTitle(), locale)) == null || name != null && t2.equals(name.tip().toString())) continue;
                            String string = t2;
                            return string;
                        }
                    }
                    if (name != null && (t = DataStoreOpener.string((name = qualified ? name.toFullyQualifiedName() : name.tip()).toInternationalString(), locale)) != null) {
                        Object identification;
                        identification = t;
                        return identification;
                    }
                    if (identifications == null) break block13;
                    for (Object identification : identifications) {
                        String t3 = Citations.getIdentifier((Citation)identification.getCitation());
                        if (t3 == null) continue;
                        String string = t3;
                        return string;
                    }
                }
                finally {
                    LogHandler.loadingStop(logID);
                }
            }
        }
        return Vocabulary.getResources(locale).getString((short)208);
    }

    private static String string(InternationalString i18n, Locale locale) {
        return i18n != null ? Strings.trimOrNull(i18n.toString(locale)) : null;
    }

    public static boolean removeAndClose(DataStore toClose, Node owner) {
        boolean removed = false;
        for (Map.Entry<Object, DataStore> entries : CACHE.entrySet()) {
            if (entries.getValue() != toClose) continue;
            removed |= CACHE.remove(entries.getKey(), toClose);
        }
        BackgroundThreads.execute(() -> {
            try {
                toClose.close();
            }
            catch (Throwable e) {
                Platform.runLater(() -> ExceptionReporter.canNotCloseFile(owner, toClose.getDisplayName(), e));
            }
        });
        return removed;
    }

    static void closeAll() throws Exception {
        Closer closer = new Closer();
        do {
            ((Stream)Stream.of(CACHE.keySet().toArray()).parallel()).forEach(closer);
        } while (!CACHE.isEmpty());
        closer.rethrow();
    }

    private static final class Closer
    implements Consumer<Object> {
        private Exception error;

        private Closer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Object source) {
            DataStore toClose = CACHE.remove(source);
            if (source != null) {
                try {
                    toClose.close();
                }
                catch (Exception e) {
                    Closer closer = this;
                    synchronized (closer) {
                        if (this.error == null) {
                            this.error = e;
                        } else {
                            this.error.addSuppressed(e);
                        }
                    }
                }
            }
        }

        synchronized void rethrow() throws Exception {
            if (this.error != null) {
                throw this.error;
            }
        }
    }
}

