/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TableView;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.gui.referencing.Code;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.CharSequences;

final class CodeFilter
implements Predicate<Code> {
    private final AuthorityCodes allCodes;
    private final String[] tokens;

    private CodeFilter(AuthorityCodes allCodes, String[] tokens) {
        this.allCodes = allCodes;
        this.tokens = tokens;
    }

    static void apply(TableView<Code> table, String keywords) {
        String[] tokens;
        FilteredList filtered;
        AuthorityCodes allCodes;
        ObservableList items = table.getItems();
        if (items instanceof AuthorityCodes) {
            allCodes = (AuthorityCodes)items;
            filtered = null;
        } else {
            filtered = (FilteredList)items;
            allCodes = (AuthorityCodes)filtered.getSource();
        }
        keywords = Strings.trimOrNull(keywords);
        if (keywords != null && (tokens = (String[])CharSequences.split(keywords = keywords.toLowerCase(allCodes.locale), ' ')).length != 0) {
            CodeFilter p = new CodeFilter(allCodes, tokens);
            if (filtered == null) {
                filtered = new FilteredList((ObservableList)allCodes, (Predicate)p);
                table.setItems((ObservableList)filtered);
            } else {
                filtered.setPredicate((Predicate)p);
            }
            return;
        }
        table.setItems((ObservableList)allCodes);
    }

    @Override
    public boolean test(Code code) {
        String id = code.code.toLowerCase(this.allCodes.locale);
        String name = this.allCodes.getName(code).getValue();
        name = name != null ? name.toLowerCase(this.allCodes.locale) : "";
        for (String token : this.tokens) {
            if (name.contains(token) || id.equals(token)) continue;
            return false;
        }
        return true;
    }
}

