/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.map;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.Separator;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextAlignment;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.gui.Widget;
import org.apache.sis.gui.map.MapCanvas;
import org.apache.sis.gui.map.OperationFinder;
import org.apache.sis.gui.map.ValuesUnderCursor;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public class StatusBar
extends Widget
implements EventHandler<MouseEvent> {
    private static final int BIDIMENSIONAL = 2;
    private static final Insets PADDING = new Insets(5.0, 20.0, 6.0, 9.0);
    private static final int VALUES_PADDING = 9;
    private final HBox view;
    private final Label message;
    private double lastX;
    private double lastY;
    private MapCanvas canvas;
    private final RecentReferenceSystems systemChooser;
    private final ObjectProperty<ReferenceSystem> selectedSystem;
    private CoordinateReferenceSystem objectiveCRS;
    private MathTransform objectiveToPositionCRS;
    public final ObjectProperty<MathTransform> localToObjectiveCRS;
    public final ReadOnlyObjectProperty<ReferenceSystem> positionReferenceSystem = new PositionSystem();
    private MathTransform localToPositionCRS;
    private Predicate<MapCanvas> fullOperationSearchRequired;
    private int xDimension;
    private int yDimension;
    private double[] sourceCoordinates;
    private GeneralDirectPosition targetCoordinates;
    private double[] precisions;
    private double[] inflatePrecisions;
    private Unit<?> precisionUnit;
    private int compatiblePrecisionCount;
    public final ObjectProperty<Quantity<Length>> lowestAccuracy;
    private final CoordinateFormat format;
    private ReferencingByIdentifiers.Coder formatAsIdentifiers;
    protected final Label position;
    private int maximalPositionLength;
    private String outsideText;
    private Label sampleValues;
    public final ObjectProperty<ValuesUnderCursor> sampleValuesProvider;
    private boolean isSampleValuesVisible;
    private Task<?> worker;

    public StatusBar(RecentReferenceSystems systemChooser) {
        this.localToObjectiveCRS = new LocalToObjective();
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.targetCoordinates = new GeneralDirectPosition(2);
        this.sourceCoordinates = this.targetCoordinates.coordinates;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.yDimension = 1;
        this.format = new CoordinateFormat();
        this.lowestAccuracy = new SimpleObjectProperty((Object)this, "lowestAccuracy");
        this.message = new Label();
        this.message.setVisible(false);
        this.message.setMaxWidth(Double.POSITIVE_INFINITY);
        HBox.setHgrow((Node)this.message, (Priority)Priority.ALWAYS);
        this.position = new Label();
        this.position.setAlignment(Pos.CENTER_RIGHT);
        this.position.setTextAlignment(TextAlignment.RIGHT);
        this.view = new HBox(6.0, new Node[]{this.message, this.position});
        this.view.setPadding(PADDING);
        this.view.setAlignment(Pos.CENTER_RIGHT);
        ContextMenu menu = new ContextMenu();
        this.view.setOnMousePressed(event -> {
            if (event.isSecondaryButtonDown() && !menu.getItems().isEmpty()) {
                menu.show((Node)((HBox)event.getSource()), event.getScreenX(), event.getScreenY());
                event.consume();
            } else {
                menu.hide();
            }
        });
        this.systemChooser = systemChooser;
        if (systemChooser == null) {
            this.selectedSystem = null;
        } else {
            Menu choices = systemChooser.createMenuItems(false, (ChangeListener<ReferenceSystem>)((ChangeListener)(property, oldValue, newValue) -> {
                if (newValue instanceof CoordinateReferenceSystem) {
                    this.setPositionCRS((CoordinateReferenceSystem)newValue);
                } else if (newValue instanceof ReferencingByIdentifiers) {
                    this.setPositionRID((ReferencingByIdentifiers)newValue);
                } else {
                    this.setPositionCRS(null);
                }
            }));
            this.selectedSystem = RecentReferenceSystems.getSelectedProperty(choices);
            menu.getItems().add((Object)choices);
            systemChooser.getItems().addListener(change -> {
                if (this.formatAsIdentifiers == null) {
                    while (change.next()) {
                        if (!change.wasAdded() && !change.wasReplaced()) continue;
                        this.setReplaceablePositionCRS(this.getPositionCRS());
                        break;
                    }
                }
            });
        }
        ObservableList items = menu.getItems();
        this.sampleValuesProvider = new SimpleObjectProperty((Object)this, "valueProvider");
        this.sampleValuesProvider.addListener((p, o, n) -> {
            ValuesUnderCursor.update(this, o, n);
            if (o != null) {
                items.remove((Object)o.valueChoices);
            }
            if (n != null) {
                items.add(1, (Object)n.valueChoices);
            }
            this.setSampleValuesVisible(n != null);
        });
    }

    @Deprecated
    public StatusBar(RecentReferenceSystems systemChooser, MapCanvas ... toTrack) {
        this(systemChooser);
        for (MapCanvas canvas : toTrack) {
            this.track(canvas);
        }
    }

    public void track(final MapCanvas canvas) {
        ArgumentChecks.ensureNonNull("canvas", canvas);
        if (this.canvas != null) {
            throw new IllegalArgumentException(Errors.format((short)35, "canvas", 1, 2));
        }
        this.canvas = canvas;
        this.sampleValuesProvider.set((Object)ValuesUnderCursor.create(canvas));
        canvas.errorProperty().addListener((p, o, n) -> this.setRenderingError((Throwable)n));
        canvas.renderingProperty().addListener((p, o, n) -> {
            if (!n.booleanValue()) {
                this.applyCanvasGeometry();
            }
        });
        this.applyCanvasGeometry();
        if (canvas.getObjectiveCRS() != null) {
            this.registerMouseListeners();
        } else {
            canvas.addPropertyChangeListener("objectiveCRS", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    canvas.removePropertyChangeListener("objectiveCRS", this);
                    StatusBar.this.registerMouseListeners();
                }
            });
        }
    }

    private void registerMouseListeners() {
        Pane floatingPane = this.canvas.floatingPane;
        floatingPane.addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)this);
        floatingPane.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)this);
        floatingPane.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)this);
    }

    @Override
    public final Region getView() {
        return this.view;
    }

    private void applyCanvasGeometry() {
        try {
            this.apply(this.canvas.getGridGeometry());
        }
        catch (RenderException e) {
            this.setRenderingError(e);
        }
    }

    public void applyCanvasGeometry(GridGeometry geometry) {
        this.position.setText(null);
        this.xDimension = 0;
        this.yDimension = 1;
        this.apply(geometry);
    }

    public void applyCanvasGeometry(GridGeometry geometry, GridExtent sliceExtent, int xdim, int ydim) {
        this.position.setText(null);
        if (geometry != null) {
            int dimension = geometry.getDimension();
            ArgumentChecks.ensureBetween("xdim", 0, dimension - 1, xdim);
            ArgumentChecks.ensureBetween("ydim", xdim + 1, dimension - 1, ydim);
            this.xDimension = xdim;
            this.yDimension = ydim;
            if (sliceExtent != null) {
                long[] offset = new long[dimension];
                for (int i : this.getXYDimensions()) {
                    offset[i] = Math.negateExact(sliceExtent.getLow(i));
                }
                sliceExtent = sliceExtent.translate(offset);
                geometry = geometry.shiftGrid(offset);
                try {
                    geometry = geometry.relocate(sliceExtent);
                }
                catch (TransformException e) {
                    this.setErrorMessage(null, e);
                }
            }
        }
        this.apply(geometry);
    }

    private void apply(GridGeometry geometry) {
        boolean sameCRS;
        MathTransform localToCRS = null;
        CoordinateReferenceSystem crs = null;
        double[] pointOfInterest = ArraysExt.EMPTY_DOUBLE;
        double[] inflate = null;
        double resolution = 1.0;
        Unit unit = Units.PIXEL;
        if (geometry != null) {
            int i;
            if (geometry.isDefined(1)) {
                crs = geometry.getCoordinateReferenceSystem();
            }
            if (geometry.isDefined(8)) {
                localToCRS = geometry.getGridToCRS(PixelInCell.CELL_CENTER);
            }
            if (geometry.isDefined(16)) {
                double[] resolutions = geometry.getResolution(true);
                if (crs != null && resolutions.length != 0) {
                    CoordinateSystem cs = crs.getCoordinateSystem();
                    unit = cs.getAxis(0).getUnit();
                    for (i = 0; i < resolutions.length; ++i) {
                        double r;
                        if (!unit.equals((Object)cs.getAxis(i).getUnit()) || !((r = resolutions[i]) < resolution)) continue;
                        resolution = r;
                    }
                }
            }
            if (geometry.isDefined(4)) {
                GridExtent extent = geometry.getExtent();
                int n = extent.getDimension();
                inflate = new double[n];
                for (i = 0; i < n; ++i) {
                    inflate[i] = 0.5 / (double)extent.getSize(i) + 1.0;
                }
                pointOfInterest = extent.getPointOfInterest(PixelInCell.CELL_CENTER);
            }
        }
        boolean clear = this.fullOperationSearchRequired != null && this.fullOperationSearchRequired.test(this.canvas);
        boolean bl = sameCRS = !clear && Utilities.equalsIgnoreMetadata(this.objectiveCRS, crs);
        if (localToCRS == null) {
            localToCRS = MathTransforms.identity((int)2);
        }
        if (sameCRS && this.objectiveToPositionCRS != null) {
            localToCRS = MathTransforms.concatenate((MathTransform)localToCRS, (MathTransform)this.objectiveToPositionCRS);
        }
        int srcDim = Math.max(localToCRS.getSourceDimensions(), 2);
        int tgtDim = localToCRS.getTargetDimensions();
        ((LocalToObjective)this.localToObjectiveCRS).setNoCheck(localToCRS);
        this.sourceCoordinates = Arrays.copyOf(pointOfInterest, srcDim);
        this.targetCoordinates = new GeneralDirectPosition(tgtDim);
        this.objectiveCRS = crs;
        this.localToPositionCRS = localToCRS;
        this.inflatePrecisions = inflate;
        this.precisions = null;
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        if (sameCRS) {
            crs = this.getPositionCRS();
            this.targetCoordinates.setCoordinateReferenceSystem(crs);
        } else {
            this.objectiveToPositionCRS = null;
            this.setFormatCRS(crs, null);
            crs = OperationFinder.toGeospatial(crs, this.canvas);
            crs = this.setReplaceablePositionCRS(crs);
        }
        this.format.setGroundPrecision(Quantities.create(resolution, unit));
        if (!sameCRS && this.selectedSystem != null) {
            this.selectedSystem.set((Object)crs);
        }
    }

    private CoordinateReferenceSystem setReplaceablePositionCRS(CoordinateReferenceSystem crs) {
        if (crs != null && this.systemChooser != null) {
            ComparisonMode mode = (ComparisonMode)((Object)this.systemChooser.duplicationCriterion.get());
            for (ReferenceSystem system : this.systemChooser.getItems()) {
                if (!Utilities.deepEquals(crs, system, mode)) continue;
                crs = (CoordinateReferenceSystem)system;
                break;
            }
        }
        if (crs != this.getPositionCRS()) {
            this.setPositionCRS(crs);
        }
        return crs;
    }

    private void setPositionCRS(final CoordinateReferenceSystem crs) {
        this.cancelWorker();
        if (crs != null && this.objectiveCRS != null && this.objectiveCRS != crs) {
            this.position.setTextFill((Paint)Styles.OUTDATED_TEXT);
            Envelope aoi = this.systemChooser != null ? (Envelope)this.systemChooser.areaOfInterest.get() : null;
            this.worker = new OperationFinder(this.canvas, aoi, this.objectiveCRS, crs){
                private Quantity<Length> accuracy;

                @Override
                protected MathTransform call() throws Exception {
                    MathTransform value = super.call();
                    double a = CRS.getLinearAccuracy((CoordinateOperation)this.getOperation());
                    if (a > 0.0) {
                        this.accuracy = GUIUtilities.shorter(null, a);
                    }
                    return value;
                }

                protected void succeeded() {
                    StatusBar.this.terminated(this);
                    StatusBar.this.setPositionCRS(this, this.accuracy);
                }

                protected void failed() {
                    StatusBar.this.terminated(this);
                    StatusBar.this.setReferenceSystemError((ReferenceSystem)crs, this.getException());
                }

                @Override
                protected Class<?> getCallerClass() {
                    return StatusBar.class;
                }

                @Override
                protected String getCallerMethod() {
                    return "setPositionCRS";
                }
            };
            BackgroundThreads.execute((Runnable)((Object)this.worker));
        } else {
            if (this.objectiveCRS == null) {
                this.objectiveCRS = crs;
            }
            this.position.setMinWidth(0.0);
            this.maximalPositionLength = 0;
            this.resetPositionCRS(Styles.NORMAL_TEXT);
        }
    }

    private void setPositionCRS(OperationFinder finder, Quantity<Length> accuracy) {
        this.worker = null;
        this.setErrorMessage(null, null);
        this.fullOperationSearchRequired = finder.fullOperationSearchRequired();
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.objectiveToPositionCRS = (MathTransform)finder.getValue();
        if (this.objectiveToPositionCRS != null) {
            this.localToPositionCRS = MathTransforms.concatenate((MathTransform)this.localToPositionCRS, (MathTransform)this.objectiveToPositionCRS);
        }
        this.setFormatCRS(finder.getTargetCRS(), accuracy);
        this.rewritePosition(null);
    }

    private void rewritePosition(DirectPosition current) {
        this.position.setTextFill((Paint)Styles.NORMAL_TEXT);
        this.position.setMinWidth(0.0);
        this.maximalPositionLength = 0;
        if (this.isPositionVisible()) {
            double x = this.lastX;
            double y = this.lastY;
            this.lastY = Double.NaN;
            this.lastX = Double.NaN;
            if (!(Double.isNaN(x) || Double.isNaN(y) || current != null && current.getOrdinate(0) == x && current.getOrdinate(1) == y)) {
                this.setLocalCoordinates(x, y);
            }
        }
    }

    private void terminated(Task<?> caller) {
        if (caller == this.worker) {
            this.worker = null;
        }
    }

    private void cancelWorker() {
        if (this.worker != null) {
            this.worker.cancel();
            this.worker = null;
        }
    }

    private void setFormatCRS(CoordinateReferenceSystem crs, Quantity<Length> accuracy) {
        GeneralDirectPosition target;
        int dimension = this.localToPositionCRS.getTargetDimensions();
        if (dimension != (target = this.targetCoordinates).getDimension()) {
            target = new GeneralDirectPosition(dimension);
            this.precisions = null;
        }
        target.setCoordinateReferenceSystem(crs);
        this.format.setDefaultCRS(crs);
        this.targetCoordinates = target;
        this.formatAsIdentifiers = null;
        this.format.setGroundAccuracy(Quantities.max(accuracy, (Quantity)this.lowestAccuracy.get()));
        this.setTooltip((ReferenceSystem)crs);
        this.compatiblePrecisionCount = 0;
        this.precisionUnit = null;
        String text = null;
        if (crs != null) {
            StringBuilder b = new StringBuilder().append('(');
            CoordinateSystem cs = crs.getCoordinateSystem();
            dimension = cs != null ? cs.getDimension() : 0;
            for (int i = 0; i < dimension; ++i) {
                CoordinateSystemAxis axis;
                if (i != 0) {
                    b.append(", ");
                }
                if ((axis = cs.getAxis(i)) != null) {
                    String abbr;
                    if (i == this.compatiblePrecisionCount) {
                        Unit unit = axis.getUnit();
                        if (i == 0 || Objects.equals(this.precisionUnit, unit)) {
                            this.compatiblePrecisionCount = i + 1;
                            this.precisionUnit = unit;
                        }
                    }
                    if ((abbr = Strings.trimOrNull(axis.getAbbreviation())) != null) {
                        b.append(abbr);
                        continue;
                    }
                }
                b.append('?');
            }
            b.append(')');
            this.format.getGroundAccuracyText().ifPresent(b::append);
            text = b.toString();
        }
        if (this.position.getText() == this.outsideText) {
            this.position.setText(text);
        }
        this.outsideText = text;
        ((PositionSystem)this.positionReferenceSystem).fireValueChangedEvent();
    }

    private CoordinateReferenceSystem getPositionCRS() {
        return this.format.getDefaultCRS();
    }

    private void resetPositionCRS(Color textFill) {
        this.objectiveToPositionCRS = null;
        this.localToPositionCRS = (MathTransform)this.localToObjectiveCRS.get();
        this.setFormatCRS(this.objectiveCRS, null);
        this.position.setTextFill((Paint)textFill);
    }

    private void setPositionRID(final ReferencingByIdentifiers system) {
        MathTransform toObjective;
        DirectPosition poi;
        this.resetPositionCRS(Styles.OUTDATED_TEXT);
        final CoordinateReferenceSystem crs = this.objectiveCRS;
        final Quantity accuracy = (Quantity)this.lowestAccuracy.get();
        if (Double.isFinite(this.lastX) && Double.isFinite(this.lastY)) {
            poi = new DirectPosition2D(this.lastX, this.lastY);
            toObjective = this.localToPositionCRS;
        } else {
            poi = this.canvas != null ? this.canvas.getPointOfInterest(true) : null;
            toObjective = null;
        }
        this.cancelWorker();
        this.worker = new Task<String>(){
            private ReferencingByIdentifiers.Coder coder;

            protected String call() {
                this.coder = system.createCoder();
                try {
                    DirectPosition p = poi;
                    if (p != null && toObjective != null) {
                        p = toObjective.transform(p, (DirectPosition)new GeneralDirectPosition(crs));
                    }
                    if (accuracy != null) {
                        this.coder.setPrecision(accuracy, p);
                    }
                    if (p != null) {
                        return this.coder.encode(p);
                    }
                }
                catch (IncommensurableException | TransformException e) {
                    StatusBar.recoverableException("setPositionRID", (Exception)e);
                }
                return null;
            }

            protected void failed() {
                StatusBar.this.terminated(this);
                StatusBar.this.setReferenceSystemError((ReferenceSystem)system, this.getException());
            }

            protected void succeeded() {
                StatusBar.this.terminated(this);
                StatusBar.this.setPositionRID(this.coder, (String)this.getValue(), toObjective != null ? poi : null);
            }
        };
        BackgroundThreads.execute((Runnable)this.worker);
    }

    private void setPositionRID(ReferencingByIdentifiers.Coder coder, String identifier, DirectPosition current) {
        this.formatAsIdentifiers = coder;
        this.fullOperationSearchRequired = null;
        this.outsideText = null;
        this.setErrorMessage(null, null);
        this.setTooltip((ReferenceSystem)coder.getReferenceSystem());
        this.position.setText(identifier);
        ((PositionSystem)this.positionReferenceSystem).fireValueChangedEvent();
        this.rewritePosition(current);
    }

    public final int[] getXYDimensions() {
        return new int[]{this.xDimension, this.yDimension};
    }

    @Deprecated
    public Quantity<Length> getLowestAccuracy() {
        return (Quantity)this.lowestAccuracy.get();
    }

    @Deprecated
    public void setLowestAccuracy(Quantity<Length> accuracy) {
        this.lowestAccuracy.set(accuracy);
    }

    public Optional<Point2D> getLocalCoordinates() {
        if (this.isPositionVisible() && !Double.isNaN(this.lastX) && !Double.isNaN(this.lastY)) {
            return Optional.of(new Point2D(this.lastX, this.lastY));
        }
        return Optional.empty();
    }

    public void setLocalCoordinates(double x, double y) {
        if (x != this.lastX || y != this.lastY) {
            if (this.isSampleValuesVisible) {
                ((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluateLater((DirectPosition)this.targetCoordinates);
            }
            this.lastX = x;
            this.lastY = y;
            String text = this.formatLocalCoordinates(this.lastX, this.lastY);
            this.position.setText(text);
            if (text.length() > this.maximalPositionLength) {
                this.maximalPositionLength = text.length();
                this.position.setMinWidth(Math.min(this.view.getWidth() / 2.0, Math.ceil(this.position.prefWidth(this.position.getHeight()))));
            }
        }
    }

    private String formatLocalCoordinates(double x, double y) {
        Matrix derivative;
        this.sourceCoordinates[this.xDimension] = x;
        this.sourceCoordinates[this.yDimension] = y;
        try {
            derivative = MathTransforms.derivativeAndTransform((MathTransform)this.localToPositionCRS, (double[])this.sourceCoordinates, (int)0, (double[])this.targetCoordinates.coordinates, (int)0);
        }
        catch (TransformException ignore) {
            try {
                this.localToPositionCRS.transform(this.sourceCoordinates, 0, this.targetCoordinates.coordinates, 0, 1);
            }
            catch (TransformException e) {
                return this.cause(e);
            }
            derivative = null;
        }
        if (derivative == null) {
            this.precisions = null;
        } else {
            if (this.precisions == null) {
                this.precisions = new double[this.targetCoordinates.getDimension()];
            }
            int j = derivative.getNumRow();
            while (--j >= 0) {
                double p = 0.0;
                int i = derivative.getNumCol();
                while (--i >= 0) {
                    double e = Math.abs(derivative.getElement(j, i));
                    if (this.inflatePrecisions != null) {
                        e *= this.inflatePrecisions[i];
                    }
                    if (!(e > p)) continue;
                    p = e;
                }
                this.precisions[j] = p;
            }
        }
        this.targetCoordinates.normalize();
        try {
            if (this.formatAsIdentifiers != null) {
                double precision = 0.0;
                int i = this.compatiblePrecisionCount;
                while (--i >= 0) {
                    double p = this.precisions[i];
                    if (!(p > precision)) continue;
                    precision = p;
                }
                return this.formatAsIdentifiers.encode((DirectPosition)this.targetCoordinates, precision > 0.0 ? (Quantity)Quantities.create(precision, this.precisionUnit) : null);
            }
            this.format.setPrecisions(this.precisions);
            return this.format.format((DirectPosition)this.targetCoordinates);
        }
        catch (Exception e) {
            return this.cause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String formatTabSeparatedCoordinates(double x, double y) throws TransformException {
        String separator = this.format.getSeparator();
        try {
            this.format.setSeparator("\t");
            String string = this.formatLocalCoordinates(x, y);
            return string;
        }
        finally {
            this.format.setSeparator(separator);
        }
    }

    public void handle(MouseEvent event) {
        if (event != null) {
            EventType type = event.getEventType();
            if (type == MouseEvent.MOUSE_MOVED || type == MouseEvent.MOUSE_ENTERED) {
                this.setLocalCoordinates(event.getX(), event.getY());
                return;
            }
            if (type != MouseEvent.MOUSE_EXITED) {
                return;
            }
        }
        this.lastY = Double.NaN;
        this.lastX = Double.NaN;
        this.position.setText(this.outsideText);
        if (this.isSampleValuesVisible) {
            ((ValuesUnderCursor)this.sampleValuesProvider.get()).evaluateLater(null);
        }
    }

    final void setSampleValues(String text) {
        this.sampleValues.setText(text);
    }

    private boolean isPositionVisible() {
        if (this.position.isVisible()) {
            String text = this.position.getText();
            return text != null && text != this.outsideText;
        }
        return false;
    }

    private void setSampleValuesVisible(boolean visible) {
        ObservableList c = this.view.getChildren();
        Label view = this.sampleValues;
        if (visible) {
            if (view == null) {
                view = new Label();
                view.setAlignment(Pos.CENTER_RIGHT);
                view.setTextAlignment(TextAlignment.RIGHT);
                view.setMinWidth(Double.NEGATIVE_INFINITY);
                view.setMaxWidth(Double.NEGATIVE_INFINITY);
                this.sampleValues = view;
            }
            if (c.lastIndexOf((Object)view) < 0) {
                Separator separator = new Separator(Orientation.VERTICAL);
                c.addAll((Object[])new Node[]{separator, view});
            }
        } else if (view != null) {
            view.setText(null);
            int i = c.lastIndexOf((Object)view);
            if (i >= 0) {
                c.remove(i);
                if (--i >= 0) {
                    Node last = (Node)c.remove(i);
                    assert (last instanceof Separator) : last;
                }
            }
        }
        this.isSampleValuesVisible = visible;
    }

    final boolean computeSizeOfSampleValues(String prototype, Iterable<String> others) {
        this.setSampleValuesVisible(prototype != null && !prototype.isEmpty());
        if (this.isSampleValuesVisible) {
            Label view = this.sampleValues;
            view.setText(prototype);
            view.setPrefWidth(-1.0);
            double width = view.prefWidth(view.getHeight());
            double max = Math.max(width * 1.25, 200.0);
            for (String other : others) {
                view.setText(other);
                double cw = view.prefWidth(view.getHeight());
                if (!(cw > width) || !((width = cw) > max)) continue;
                width = max;
                break;
            }
            view.setText(null);
            if (!(width > 0.0)) {
                return false;
            }
            view.setPrefWidth(width + 9.0);
        }
        return true;
    }

    private void setTooltip(ReferenceSystem crs) {
        String text = IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)this.getLocale());
        Tooltip tp = null;
        if (text != null) {
            tp = this.position.getTooltip();
            if (tp == null) {
                tp = new Tooltip(text);
            } else {
                tp.setText(text);
            }
        }
        this.position.setTooltip(tp);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message.getText());
    }

    @Deprecated
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.message.getText());
    }

    public void setInfoMessage(String text) {
        this.message.setVisible((text = Strings.trimOrNull(text)) != null);
        this.message.setGraphic(null);
        this.message.setText(text);
        this.message.setTextFill((Paint)Styles.LOADING_TEXT);
    }

    public void setErrorMessage(String text, Throwable details) {
        text = Strings.trimOrNull(text);
        Button more = null;
        if (details != null) {
            String alert = text != null ? text : this.cause(details);
            more = new Button("\u2139\ufe0f");
            more.setOnAction(e -> ExceptionReporter.show((Node)this.getView(), Resources.forLocale(this.getLocale()).getString((short)17), alert, details));
        }
        this.message.setVisible(text != null);
        this.message.setGraphic((Node)more);
        this.message.setText(text);
        this.message.setTextFill((Paint)Styles.ERROR_TEXT);
    }

    private void setReferenceSystemError(ReferenceSystem system, Throwable exception) {
        Locale locale = this.getLocale();
        this.setErrorMessage(Resources.forLocale(locale).getString((short)9, IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)locale)), exception);
        if (this.selectedSystem != null) {
            this.selectedSystem.set((Object)((ReferenceSystem)this.positionReferenceSystem.get()));
        }
        this.resetPositionCRS(Styles.ERROR_TEXT);
    }

    private void setRenderingError(Throwable details) {
        String text = null;
        if (details != null) {
            text = Resources.forLocale(this.getLocale()).getString((short)8);
        }
        this.setErrorMessage(text, details);
    }

    final String cause(Throwable e) {
        String text;
        if (e instanceof Exception) {
            e = Exceptions.unwrap((Exception)e);
        }
        if ((text = Exceptions.getLocalizedMessage(e, this.getLocale())) == null) {
            text = Classes.getShortClassName(e);
        }
        return text;
    }

    private static void recoverableException(String caller, Exception e) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.gui"), StatusBar.class, caller, e);
    }

    private final class PositionSystem
    extends ReadOnlyObjectPropertyBase<ReferenceSystem> {
        private PositionSystem() {
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "positionReferenceSystem";
        }

        public ReferenceSystem get() {
            ReferencingByIdentifiers.Coder f = StatusBar.this.formatAsIdentifiers;
            return f != null ? f.getReferenceSystem() : StatusBar.this.getPositionCRS();
        }

        protected void fireValueChangedEvent() {
            super.fireValueChangedEvent();
        }
    }

    private final class LocalToObjective
    extends ObjectPropertyBase<MathTransform> {
        LocalToObjective() {
            super((Object)MathTransforms.identity((int)2));
        }

        public Object getBean() {
            return StatusBar.this;
        }

        public String getName() {
            return "localToObjectiveCRS";
        }

        final void setNoCheck(MathTransform newValue) {
            super.set((Object)newValue);
        }

        public void set(MathTransform newValue) {
            ArgumentChecks.ensureNonNull("newValue", newValue);
            MathTransform oldValue = (MathTransform)this.get();
            ArgumentChecks.ensureDimensionsMatch("newValue", oldValue.getSourceDimensions(), oldValue.getTargetDimensions(), newValue);
            MathTransform tr = StatusBar.this.objectiveToPositionCRS;
            if (tr != null) {
                newValue = MathTransforms.concatenate((MathTransform)newValue, (MathTransform)tr);
            }
            StatusBar.this.localToPositionCRS = newValue;
            super.set((Object)newValue);
        }
    }
}

