/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.control.TreeItem;
import org.apache.sis.gui.dataset.ResourceCell;
import org.apache.sis.gui.dataset.TreeViewType;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.DataStoreOpener;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.storage.folder.UnstructuredAggregate;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.MergeStrategy;

final class ResourceItem
extends TreeItem<Resource> {
    Path path;
    String label;
    boolean isLoading;
    Throwable error;
    private final boolean isLeaf;
    private boolean isChildrenKnown;
    private EnumMap<TreeViewType, ResourceItem> views;

    ResourceItem() {
        this.isLeaf = true;
        this.isLoading = true;
    }

    private ResourceItem(Throwable exception) {
        this.isLeaf = true;
        this.error = exception;
    }

    ResourceItem(Resource resource) {
        super((Object)resource);
        this.isLoading = true;
        this.isLeaf = !(resource instanceof Aggregate);
        LogHandler.installListener(resource);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public ObservableList<TreeItem<Resource>> getChildren() {
        ObservableList children = super.getChildren();
        if (!this.isChildrenKnown) {
            this.isChildrenKnown = true;
            Resource resource = (Resource)this.getValue();
            if (resource instanceof Aggregate) {
                BackgroundThreads.execute((Runnable)((Object)new GetChildren((Aggregate)resource)));
                children.add((Object)new ResourceItem());
            }
        }
        return children;
    }

    final Resource getSource() {
        return (Resource)(this.views != null ? this.views.get((Object)TreeViewType.SOURCE) : this).getValue();
    }

    final boolean contains(Resource resource) {
        if (this.getValue() == resource) {
            return true;
        }
        if (this.views != null) {
            for (ResourceItem view : this.views.values()) {
                if (view.getValue() != resource) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isView(TreeViewType type) {
        return this.views != null && this.views.get((Object)type) == this;
    }

    final boolean isViewSelectable(Resource resource, TreeViewType type) {
        if (this.views != null && this.views.containsKey((Object)type)) {
            return true;
        }
        if (this.getParent() != null) {
            switch (type) {
                case AGGREGATION: {
                    return resource instanceof UnstructuredAggregate;
                }
            }
        }
        return false;
    }

    private void selectView(ResourceItem view) {
        ObservableList siblings;
        TreeItem parent = this.getParent();
        if (parent != null) {
            siblings = parent.getChildren();
            int i = siblings.indexOf((Object)this);
            if (i >= 0) {
                siblings.set(i, view);
                return;
            }
        } else {
            siblings = super.getChildren();
        }
        siblings.add(view);
    }

    private void setNewView(ResourceCell cell, TreeViewType type, ResourceItem view) {
        view.views = this.views;
        this.views.put(type, view);
        if (cell == null || cell.isActiveView(type)) {
            this.selectView(view);
        }
    }

    final void setView(final ResourceCell cell, final TreeViewType type, final Locale locale) {
        ResourceItem existing;
        if (this.views == null) {
            this.views = new EnumMap(TreeViewType.class);
            this.views.put(TreeViewType.SOURCE, this);
        }
        if ((existing = this.views.get((Object)type)) != null) {
            this.selectView(existing);
            return;
        }
        final Resource resource = this.getSource();
        final ResourceItem loading = new ResourceItem();
        this.setNewView(null, type, loading);
        BackgroundThreads.execute((Runnable)new Task<ResourceItem>(){

            protected ResourceItem call() throws DataStoreException {
                Resource result = resource;
                switch (type) {
                    case AGGREGATION: {
                        if (!(resource instanceof UnstructuredAggregate)) break;
                        result = ((UnstructuredAggregate)resource).getStructuredView();
                        result = MergeStrategy.selectByTimeThenArea(null).apply(result);
                    }
                }
                LogHandler.redirect(result, resource);
                ResourceItem item = new ResourceItem(result);
                item.label = DataStoreOpener.findLabel(resource, locale, false);
                item.isLoading = false;
                return item;
            }

            protected void succeeded() {
                loading.setNewView(cell, type, (ResourceItem)((Object)this.getValue()));
            }

            protected void failed() {
                loading.setNewView(cell, type, new ResourceItem(this.getException()));
            }
        });
    }

    private final class GetChildren
    extends Task<List<TreeItem<Resource>>> {
        private final Aggregate resource;

        GetChildren(Aggregate resource) {
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<TreeItem<Resource>> call() throws DataStoreException {
            ArrayList<TreeItem<Resource>> items = new ArrayList<TreeItem<Resource>>();
            Long id = LogHandler.loadingStart((Resource)this.resource);
            try {
                for (Resource component : this.resource.components()) {
                    items.add(new ResourceItem(component));
                }
            }
            finally {
                LogHandler.loadingStop(id);
            }
            return items;
        }

        protected void succeeded() {
            ResourceItem.super.getChildren().setAll((Collection)this.getValue());
        }

        protected void failed() {
            ResourceItem.super.getChildren().setAll((Object[])new TreeItem[]{new ResourceItem(this.getException())});
        }
    }

    final class Completer
    implements Runnable {
        private final Resource resource;
        private String result;
        private Throwable failure;

        Completer(Resource resource) {
            this.resource = resource;
        }

        final void fetch(Locale locale) {
            try {
                this.result = DataStoreOpener.findLabel(this.resource, locale, false);
            }
            catch (Throwable e) {
                this.failure = e;
            }
            Platform.runLater((Runnable)this);
        }

        @Override
        public void run() {
            ResourceItem.this.isLoading = false;
            ResourceItem.this.label = this.result;
            ResourceItem.this.error = this.failure;
            GUIUtilities.forceCellUpdate(ResourceItem.this);
        }
    }
}

