/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;
import org.apache.sis.gui.Widget;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.ImmutableObjectProperty;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.PerformanceLevel;
import org.apache.sis.util.resources.Vocabulary;

public class LogViewer
extends Widget {
    private static final int SPACE = 6;
    private static final Insets FILTER_MARGIN = new Insets(0.0, 0.0, 0.0, 24.0);
    private static final Insets BUTTON_MARGIN = new Insets(6.0);
    private static final Map<Level, String> LEVEL_NAMES = new HashMap<Level, String>(12);
    private Level filteredLevel = Level.FINE;
    private String filteredLogger = "";
    private final TableView<LogRecord> table;
    private final VBox view;
    private static final Insets DETAILS_MARGIN = new Insets(6.0, 0.0, 0.0, 0.0);
    private final Label level;
    private final Label time;
    private final Label logger;
    private final Label classe;
    private final Label method;
    private final TextArea message;
    public final ObjectProperty<Resource> source = new SimpleObjectProperty((Object)this, "source");
    public final BooleanProperty systemLogs = new SimpleBooleanProperty((Object)this, "systemLogs");
    private final IsEmpty isEmpty = new IsEmpty(this);
    private LogHandler.Destination sourceOfLogs;
    private boolean isAdjusting;
    private final SimpleFormatter formatter = new SimpleFormatter();
    private final DateFormat shortDates;
    private final DateFormat longDates;
    private final ToggleButton messageButton;
    private final ToggleButton traceButton;
    private Predicate<LogRecord> filter;

    public LogViewer() {
        this(Vocabulary.getResources((Locale)null));
    }

    LogViewer(Vocabulary vocabulary) {
        this.shortDates = DateFormat.getDateTimeInstance(3, 3, vocabulary.getLocale());
        this.longDates = DateFormat.getDateTimeInstance(1, 1, vocabulary.getLocale());
        this.table = new TableView(FXCollections.emptyObservableList());
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.table.setTableMenuButtonVisible(true);
        this.table.getColumns().setAll((Object[])new TableColumn[]{this.column(vocabulary, (short)114), this.column(vocabulary, (short)243), this.column(vocabulary, (short)241), this.column(vocabulary, (short)240), this.column(vocabulary, (short)242), this.column(vocabulary, (short)239)});
        Font font = Font.font(null, (FontWeight)FontWeight.SEMI_BOLD, (double)-1.0);
        Label[] labelArray = new Label[5];
        this.level = new Label();
        labelArray[0] = LogViewer.label(font, vocabulary, (short)114, this.level);
        this.time = new Label();
        labelArray[1] = LogViewer.label(font, vocabulary, (short)243, this.time);
        this.logger = new Label();
        labelArray[2] = LogViewer.label(font, vocabulary, (short)241, this.logger);
        this.classe = new Label();
        labelArray[3] = LogViewer.label(font, vocabulary, (short)240, this.classe);
        this.method = new Label();
        labelArray[4] = LogViewer.label(font, vocabulary, (short)242, this.method);
        GridPane details = Styles.createControlGrid(0, labelArray);
        this.messageButton = new ToggleButton(vocabulary.getString((short)239));
        this.traceButton = new ToggleButton(vocabulary.getString((short)245));
        this.messageButton.setSelected(true);
        this.messageButton.setMaxWidth(Double.MAX_VALUE);
        this.traceButton.setMaxWidth(Double.MAX_VALUE);
        ToggleGroup buttonGroup = new ToggleGroup();
        buttonGroup.getToggles().setAll((Object[])new Toggle[]{this.messageButton, this.traceButton});
        VBox textSelector = new VBox(6.0, new Node[]{this.messageButton, this.traceButton});
        this.message = new TextArea();
        this.message.setEditable(false);
        this.message.setMinHeight(100.0);
        GridPane.setConstraints((Node)textSelector, (int)0, (int)5);
        GridPane.setConstraints((Node)this.message, (int)1, (int)5);
        GridPane.setMargin((Node)textSelector, (Insets)DETAILS_MARGIN);
        GridPane.setMargin((Node)this.message, (Insets)DETAILS_MARGIN);
        details.getChildren().addAll((Object[])new Node[]{textSelector, this.message});
        details.setVgap(0.0);
        Label levelLabel = new Label(vocabulary.getLabel((short)114));
        ChoiceBox levels = new ChoiceBox();
        levelLabel.setLabelFor((Node)levels);
        levels.getItems().setAll((Object[])new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, PerformanceLevel.SLOWNESS, Level.FINE, Level.FINER, Level.ALL});
        levels.setConverter((StringConverter)Converter.INSTANCE);
        levels.getSelectionModel().selectedItemProperty().addListener((p, o, n) -> this.setFilter((Level)n, this.filteredLogger));
        levels.getSelectionModel().select((Object)this.filteredLevel);
        Label loggerLabel = new Label(vocabulary.getLabel((short)241));
        Button loggers = new Button();
        loggerLabel.setPadding(FILTER_MARGIN);
        loggerLabel.setLabelFor((Node)loggers);
        loggers.setMinWidth(160.0);
        loggers.setAlignment(Pos.CENTER_LEFT);
        loggers.setOnAction(e -> loggers.setText(this.showLoggerTreeDialog()));
        HBox bar = new HBox(6.0, new Node[]{levelLabel, levels, loggerLabel, loggers});
        bar.setAlignment(Pos.CENTER_LEFT);
        bar.setPadding(BUTTON_MARGIN);
        VBox.setVgrow(this.table, (Priority)Priority.ALWAYS);
        this.view = new VBox(new Node[]{bar, this.table, new TitledPane(vocabulary.getString((short)62), (Node)details)});
        this.source.addListener((p, o, n) -> {
            if (!this.isAdjusting) {
                try {
                    this.isAdjusting = true;
                    this.systemLogs.set(false);
                    this.setItems(LogHandler.getRecords(n));
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        this.systemLogs.addListener((p, o, n) -> {
            if (!this.isAdjusting) {
                try {
                    this.isAdjusting = true;
                    this.source.set(null);
                    this.setItems(n != false ? LogHandler.getSystemRecords() : null);
                }
                finally {
                    this.isAdjusting = false;
                }
            }
        });
        ReadOnlyObjectProperty selected = this.table.getSelectionModel().selectedItemProperty();
        buttonGroup.selectedToggleProperty().addListener((p, o, n) -> this.setMessageOrTrace((LogRecord)selected.get()));
        selected.addListener((p, o, n) -> this.selected((LogRecord)n));
    }

    private TableColumn<LogRecord, String> column(Vocabulary vocabulary, short key) {
        TableColumn column = new TableColumn(vocabulary.getString(key));
        column.setCellValueFactory(cell -> this.toString((TableColumn.CellDataFeatures<LogRecord, String>)cell, key));
        column.setVisible(key == 239);
        return column;
    }

    private static Label label(Font font, Vocabulary vocabulary, short key, Label content) {
        Label label = new Label(vocabulary.getLabel(key));
        label.setLabelFor((Node)content);
        label.setFont(font);
        return label;
    }

    private void setItems(LogHandler.Destination target) {
        this.sourceOfLogs = target;
        if (target == null) {
            this.table.setItems(FXCollections.emptyObservableList());
        } else {
            ObservableList<LogRecord> records = target.records;
            this.table.setItems((ObservableList)new FilteredList(records, this.filter));
            boolean e = records.isEmpty();
            this.isEmpty.set(e);
            if (e) {
                records.addListener((ListChangeListener)this.isEmpty);
            }
        }
    }

    public final ReadOnlyBooleanProperty isEmptyProperty() {
        return this.isEmpty.getReadOnlyProperty();
    }

    private static String toString(Level level) {
        if (level == null) {
            return null;
        }
        return LEVEL_NAMES.computeIfAbsent(level, v -> {
            int key;
            if (Level.INFO.equals(v)) {
                key = 247;
            } else if (Level.CONFIG.equals(v)) {
                key = 246;
            } else {
                return CharSequences.upperCaseToSentence(v.getLocalizedName()).toString();
            }
            return Vocabulary.format((short)key);
        });
    }

    private ObservableValue<String> toString(TableColumn.CellDataFeatures<LogRecord, String> cell, short type) {
        LogRecord log;
        if (cell != null && (log = (LogRecord)cell.getValue()) != null) {
            String text;
            switch (type) {
                case 114: {
                    text = log.getLevel().getLocalizedName();
                    break;
                }
                case 243: {
                    text = this.shortDates.format(new Date(log.getMillis()));
                    break;
                }
                case 241: {
                    text = log.getLoggerName();
                    break;
                }
                case 240: {
                    text = log.getSourceClassName();
                    if (text == null) break;
                    text = text.substring(text.lastIndexOf(46) + 1);
                    break;
                }
                case 242: {
                    text = log.getSourceMethodName();
                    break;
                }
                case 239: {
                    text = this.formatter.formatMessage(log);
                    break;
                }
                default: {
                    throw new AssertionError(type);
                }
            }
            if (text != null) {
                return new ImmutableObjectProperty<String>(text);
            }
        }
        return null;
    }

    private void selected(LogRecord log) {
        String level = null;
        String time = null;
        String logger = null;
        String classe = null;
        String method = null;
        if (log != null) {
            level = LogViewer.toString(log.getLevel());
            time = this.longDates.format(new Date(log.getMillis()));
            logger = log.getLoggerName();
            classe = log.getSourceClassName();
            method = log.getSourceMethodName();
            boolean td = log.getThrown() == null;
            this.traceButton.setDisable(td);
            if (td) {
                this.messageButton.setSelected(true);
            }
        }
        this.level.setText(level);
        this.time.setText(time);
        this.logger.setText(logger);
        this.classe.setText(classe);
        this.method.setText(method);
        this.setMessageOrTrace(log);
    }

    private void setMessageOrTrace(LogRecord log) {
        String text = null;
        if (log != null) {
            if (this.messageButton.isSelected()) {
                this.message.setWrapText(true);
                text = this.formatter.formatMessage(log);
            } else if (this.traceButton.isSelected()) {
                this.message.setWrapText(false);
                Throwable exception = log.getThrown();
                if (exception != null) {
                    text = ExceptionReporter.getStackTrace(exception);
                }
            }
        }
        this.message.setText(text);
    }

    private void setFilter(Level level, String logger) {
        this.filteredLevel = level;
        this.filteredLogger = logger;
        this.filter = Level.ALL.equals(level) && logger.isEmpty() ? null : log -> {
            if (log != null && log.getLevel().intValue() >= level.intValue()) {
                String name = log.getLoggerName();
                return name == null || name.startsWith(logger);
            }
            return false;
        };
        ObservableList items = this.table.getItems();
        if (items instanceof FilteredList) {
            ((FilteredList)items).setPredicate(this.filter);
        }
    }

    private String showLoggerTreeDialog() {
        TreeView loggers = new TreeView(this.sourceOfLogs.loggerNames());
        Dialog dialog = new Dialog();
        dialog.initOwner(this.view.getScene().getWindow());
        dialog.setTitle(Resources.forLocale(this.getLocale()).getString((short)69));
        dialog.setResultConverter(button -> {
            if (!ButtonType.OK.equals(button)) {
                return null;
            }
            ArrayList<String> path = new ArrayList<String>();
            TreeItem root = loggers.getRoot();
            for (TreeItem item = (TreeItem)loggers.getSelectionModel().getSelectedItem(); item != null && item != root; item = item.getParent()) {
                path.add((String)item.getValue());
            }
            StringJoiner joiner = new StringJoiner(".");
            int i = path.size();
            while (--i >= 0) {
                joiner.add((CharSequence)path.get(i));
            }
            return joiner.toString();
        });
        dialog.setResizable(true);
        DialogPane pane = dialog.getDialogPane();
        pane.setContent((Node)loggers);
        pane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.showAndWait().ifPresent(name -> this.setFilter(this.filteredLevel, (String)name));
        return this.filteredLogger.substring(this.filteredLogger.lastIndexOf(46) + 1);
    }

    @Override
    public Region getView() {
        return this.view;
    }

    private static final class IsEmpty
    extends ReadOnlyBooleanWrapper
    implements ListChangeListener<LogRecord> {
        IsEmpty(LogViewer owner) {
            super((Object)owner, "isEmpty", true);
        }

        public void onChanged(ListChangeListener.Change<? extends LogRecord> change) {
            ObservableList list = change.getList();
            if (!list.isEmpty()) {
                list.removeListener((ListChangeListener)this);
            }
            this.set(false);
        }
    }

    private static final class Converter
    extends StringConverter<Level> {
        static final Converter INSTANCE = new Converter();

        private Converter() {
        }

        public String toString(Level level) {
            return LogViewer.toString(level);
        }

        public Level fromString(String text) {
            for (Map.Entry<Level, String> entry : LEVEL_NAMES.entrySet()) {
                if (!entry.getValue().equals(text)) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

