/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.dataset;

import java.util.Spliterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.concurrent.Task;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.gui.dataset.FeatureList;
import org.apache.sis.gui.dataset.FeatureTable;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.util.collection.BackingStoreException;

final class FeatureLoader
extends Task<Boolean>
implements Consumer<AbstractFeature> {
    private static final int PAGE_SIZE = 100;
    private final FeatureTable table;
    private final FeatureSet initializer;
    private Stream<AbstractFeature> toClose;
    private Spliterator<AbstractFeature> iterator;
    private AbstractFeature[] loaded;
    private int count;

    FeatureLoader(FeatureTable table, FeatureSet features) {
        this.table = table;
        this.initializer = features;
    }

    private FeatureLoader(FeatureLoader previous) {
        this.table = previous.table;
        this.toClose = previous.toClose;
        this.iterator = previous.iterator;
        this.initializer = null;
    }

    @Override
    public void accept(AbstractFeature feature) {
        this.loaded[this.count++] = feature;
    }

    protected Boolean call() throws DataStoreException {
        boolean isTypeKnown;
        if (this.initializer != null) {
            isTypeKnown = this.setType(this.initializer.getType());
            this.toClose = this.initializer.features(false);
            this.iterator = this.toClose.spliterator();
        } else {
            isTypeKnown = true;
        }
        long remaining = this.iterator.estimateSize();
        int stopAt = remaining > 100L ? 100 : 1 + (int)remaining;
        this.loaded = new AbstractFeature[stopAt];
        try {
            while (this.iterator.tryAdvance(this)) {
                if (this.count >= stopAt) {
                    this.setMissingType(isTypeKnown);
                    return Boolean.TRUE;
                }
                if (!this.isCancelled()) continue;
                this.close();
                return Boolean.FALSE;
            }
        }
        catch (BackingStoreException e) {
            try {
                this.close();
            }
            catch (DataStoreException s) {
                e.addSuppressed(s);
            }
            throw e.unwrapOrRethrow(DataStoreException.class);
        }
        this.close();
        this.setMissingType(isTypeKnown);
        return Boolean.FALSE;
    }

    private void close() throws DataStoreException {
        this.iterator = null;
        Stream<AbstractFeature> c = this.toClose;
        if (c != null) {
            try {
                this.toClose = null;
                c.close();
            }
            catch (BackingStoreException e) {
                throw e.unwrapOrRethrow(DataStoreException.class);
            }
        }
    }

    final void waitAndClose() {
        Throwable error = null;
        try {
            this.get();
        }
        catch (InterruptedException | CancellationException e) {
            FeatureTable.recoverableException("interrupt", e);
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        try {
            this.close();
        }
        catch (DataStoreException e) {
            if (error != null) {
                error.addSuppressed(e);
            }
            error = e;
        }
        if (error != null) {
            FeatureTable.unexpectedException("interrupt", error);
        }
    }

    protected void succeeded() {
        FeatureList addTo = this.table.getFeatureList();
        if (addTo.isCurrentLoader(this)) {
            boolean hasMore = (Boolean)this.getValue();
            if (this.initializer != null) {
                int characteristics;
                long remainingCount;
                if (hasMore) {
                    remainingCount = this.iterator.estimateSize();
                    characteristics = this.iterator.characteristics();
                } else {
                    remainingCount = 0L;
                    characteristics = 64;
                }
                addTo.setFeatures(remainingCount, characteristics, this.loaded, this.count, hasMore);
            } else {
                addTo.addFeatures(this.loaded, this.count, hasMore);
            }
            addTo.setNextPage(hasMore ? new FeatureLoader(this) : null);
        } else {
            try {
                this.close();
            }
            catch (DataStoreException e) {
                FeatureTable.unexpectedException("setFeatures", e);
            }
        }
    }

    protected void cancelled() {
        this.stop("cancelled");
    }

    protected void failed() {
        this.stop("failed");
    }

    private void stop(String caller) {
        FeatureList addTo = this.table.getFeatureList();
        boolean isCurrentLoader = addTo.isCurrentLoader(this);
        if (isCurrentLoader) {
            addTo.setNextPage(null);
        }
        Throwable exception = this.getException();
        try {
            this.close();
        }
        catch (DataStoreException e) {
            if (exception == null) {
                exception = e;
            }
            exception.addSuppressed(e);
        }
        if (exception != null) {
            if (isCurrentLoader) {
                this.table.setException(exception);
            } else {
                FeatureTable.unexpectedException(caller, exception);
            }
        }
    }

    private boolean setType(DefaultFeatureType type) {
        if (type != null) {
            Platform.runLater(() -> this.table.setFeatureType(type));
            return true;
        }
        return false;
    }

    private void setMissingType(boolean isTypeKnown) throws DataStoreException {
        if (!isTypeKnown) {
            for (int i = 0; i < this.count; ++i) {
                AbstractFeature f = this.loaded[i];
                if (f == null || !this.setType(f.getType())) continue;
                return;
            }
            throw new DataStoreException(Resources.forLocale(this.table.textLocale).getString((short)27));
        }
    }
}

