/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.VirtualContainerBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import org.apache.sis.gui.coverage.GridCell;
import org.apache.sis.gui.coverage.GridError;
import org.apache.sis.gui.coverage.GridRow;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.internal.gui.MouseDrags;
import org.apache.sis.internal.gui.Styles;

final class GridViewSkin
extends VirtualContainerBase<GridView, GridRow>
implements EventHandler<MouseEvent> {
    private final HBox headerRow = new HBox();
    private final Rectangle topBackground;
    private final Rectangle leftBackground;
    int firstVisibleColumn;
    double leftPosition;
    double rightPosition;
    double headerWidth;
    double cellWidth;
    double cellInnerWidth;
    private boolean layoutAll;
    private boolean hasErrors;
    private final Rectangle selection;
    private final Rectangle selectedRow;
    private final Rectangle selectedColumn;
    private boolean isDragging;
    private double xPanPrevious;
    private double yPanPrevious;

    GridViewSkin(GridView view) {
        super((Control)view);
        VirtualFlow flow = this.getVirtualFlow();
        flow.setCellFactory(GridRow::new);
        flow.setFocusTraversable(true);
        flow.setFixedCellSize(GridView.getSizeValue(view.cellHeight));
        view.cellHeight.addListener((p, o, n) -> this.cellHeightChanged((Number)n));
        view.cellWidth.addListener((p, o, n) -> this.cellWidthChanged((Number)n, true));
        view.headerWidth.addListener((p, o, n) -> this.cellWidthChanged((Number)n, false));
        this.topBackground = new Rectangle();
        this.leftBackground = new Rectangle();
        this.leftBackground.fillProperty().bind(view.headerBackground);
        this.topBackground.fillProperty().bind(view.headerBackground);
        this.selection = new Rectangle();
        this.selectedRow = new Rectangle();
        this.selectedColumn = new Rectangle();
        this.selection.setFill((Paint)Styles.SELECTION_BACKGROUND);
        this.selectedRow.setFill((Paint)Color.SILVER);
        this.selectedColumn.setFill((Paint)Color.SILVER);
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        this.selection.setManaged(false);
        this.selectedRow.setManaged(false);
        this.selectedColumn.setManaged(false);
        flow.setOnMouseExited(e -> this.hideSelection());
        this.getChildren().addAll((Object[])new Node[]{this.topBackground, this.leftBackground, this.selectedColumn, this.selectedRow, this.headerRow, this.selection, flow});
        view.addEventHandler(KeyEvent.KEY_PRESSED, this::onKeyTyped);
        MouseDrags.setHandlers((Region)view, (EventHandler<? super MouseEvent>)((EventHandler)this::onDrag));
    }

    public final void handle(MouseEvent event) {
        boolean visible;
        double x = event.getX() - (this.leftPosition + this.headerWidth);
        boolean bl = visible = x >= 0.0;
        if (visible) {
            double column = Math.floor(x / this.cellWidth);
            boolean bl2 = visible = column >= 0.0;
            if (visible) {
                GridRow row = (GridRow)((Object)event.getSource());
                double y = row.getLayoutY();
                boolean bl3 = visible = y < ((Flow)this.getVirtualFlow()).getVisibleHeight();
                if (visible) {
                    x = column * this.cellWidth + this.leftBackground.getWidth() + row.getLayoutX();
                    this.selection.setX(x);
                    this.selection.setY(y += this.topBackground.getHeight());
                    this.selectedRow.setY(y);
                    this.selectedColumn.setX(x);
                    ((GridView)this.getSkinnable()).formatCoordinates(this.firstVisibleColumn + (int)column, row.getIndex());
                }
            }
        }
        this.selection.setVisible(visible);
        this.selectedRow.setVisible(visible);
        this.selectedColumn.setVisible(visible);
        if (!visible) {
            ((GridView)this.getSkinnable()).hideCoordinates();
        }
    }

    private void onDrag(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            double x = event.getX() - this.leftBackground.getWidth();
            double y = event.getY() - this.topBackground.getHeight();
            Flow flow = (Flow)this.getVirtualFlow();
            if (x >= 0.0 && y >= 0.0 && y < flow.getVisibleHeight()) {
                GridView view = (GridView)this.getSkinnable();
                EventType type = event.getEventType();
                if (type == MouseEvent.MOUSE_PRESSED) {
                    view.setCursor(Cursor.CLOSED_HAND);
                    view.requestFocus();
                    this.xPanPrevious = x;
                    this.yPanPrevious = y;
                    this.isDragging = true;
                    this.hideSelection();
                } else if (this.isDragging) {
                    if (type == MouseEvent.MOUSE_RELEASED) {
                        view.setCursor(Cursor.DEFAULT);
                        this.isDragging = false;
                    }
                    this.xPanPrevious -= flow.scrollHorizontal(this.xPanPrevious - x);
                    this.yPanPrevious -= flow.scrollPixels(this.yPanPrevious - y);
                }
                event.consume();
            }
        }
    }

    private void onKeyTyped(KeyEvent event) {
        double tx = 0.0;
        double ty = 0.0;
        switch (event.getCode()) {
            case RIGHT: 
            case KP_RIGHT: {
                tx = 1.0;
                break;
            }
            case LEFT: 
            case KP_LEFT: {
                tx = -1.0;
                break;
            }
            case DOWN: 
            case KP_DOWN: {
                ty = 1.0;
                break;
            }
            case UP: 
            case KP_UP: {
                ty = -1.0;
                break;
            }
            default: {
                return;
            }
        }
        if (event.isShiftDown()) {
            tx *= 10.0;
            ty *= 10.0;
        }
        Flow flow = (Flow)this.getVirtualFlow();
        flow.scrollPixels(flow.getFixedCellSize() * ty);
        flow.scrollHorizontal(this.cellWidth * tx);
        this.hideSelection();
        event.consume();
    }

    private void hideSelection() {
        this.selection.setVisible(false);
        this.selectedRow.setVisible(false);
        this.selectedColumn.setVisible(false);
        ((GridView)this.getSkinnable()).hideCoordinates();
    }

    private void cellHeightChanged(Number newValue) {
        Flow flow = (Flow)this.getVirtualFlow();
        double value = newValue.doubleValue();
        if (!(value >= 1.0)) {
            value = 1.0;
        }
        flow.setFixedCellSize(value);
        this.selection.setVisible(false);
        this.selection.setHeight(value);
        this.contentChanged(false);
    }

    private void cellWidthChanged(Number newValue, boolean cell) {
        GridView view = (GridView)this.getSkinnable();
        double width = view.getContentWidth();
        for (Node child : this.getChildren()) {
            if (!(child instanceof GridRow)) continue;
            ((GridRow)child).setPrefWidth(width);
        }
        if (cell) {
            this.selection.setVisible(false);
            this.selection.setWidth(newValue.doubleValue());
        }
        this.layoutAll = true;
        this.contentChanged(false);
    }

    final void errorOccurred(GridError error) {
        this.hasErrors = true;
        this.getChildren().add((Object)error);
    }

    final void removeError(GridError error) {
        ObservableList children = this.getChildren();
        children.remove((Object)error);
        this.hasErrors = children.get(children.size() - 1) instanceof GridError;
        this.contentChanged(false);
    }

    final void contentChanged(boolean all) {
        if (all) {
            this.updateItemCount();
            this.getChildren().removeIf(node -> node instanceof GridError);
            this.layoutAll = true;
            this.hasErrors = false;
        }
        ((Flow)this.getVirtualFlow()).changed(null, null, null);
    }

    protected VirtualFlow<GridRow> createVirtualFlow() {
        return new Flow((GridView)this.getSkinnable());
    }

    protected void updateItemCount() {
        this.getVirtualFlow().setCellCount(this.getItemCount());
    }

    public int getItemCount() {
        return ((GridView)this.getSkinnable()).getImageHeight();
    }

    protected void layoutChildren(double x, double y, double width, double height) {
        GridRow row;
        super.layoutChildren(x, y, width, height);
        GridView view = (GridView)this.getSkinnable();
        double cellSpacing = Math.min(view.cellSpacing.get(), this.cellWidth);
        if (!(cellSpacing >= 0.0)) {
            cellSpacing = 0.0;
        }
        Flow flow = (Flow)this.getVirtualFlow();
        double cellHeight = flow.getFixedCellSize();
        double headerHeight = cellHeight + 2.0 * cellSpacing;
        double dataY = y + headerHeight;
        double dataHeight = height - headerHeight;
        this.layoutAll |= flow.getWidth() != width || flow.getHeight() != dataHeight;
        flow.resizeRelocate(x, dataY, width, dataHeight);
        double oldPos = this.leftPosition;
        this.headerWidth = GridView.getSizeValue(view.headerWidth);
        this.cellWidth = GridView.getSizeValue(view.cellWidth);
        this.cellInnerWidth = this.cellWidth - cellSpacing;
        this.leftPosition = flow.getHorizontalPosition();
        this.rightPosition = this.leftPosition + width;
        this.firstVisibleColumn = (int)(this.leftPosition / this.cellWidth);
        this.topBackground.setX(x);
        this.topBackground.setY(y);
        this.topBackground.setWidth(width);
        this.topBackground.setHeight(headerHeight);
        this.leftBackground.setX(x);
        this.leftBackground.setY(dataY);
        this.leftBackground.setWidth(this.headerWidth);
        this.leftBackground.setHeight(flow.getVisibleHeight());
        this.selection.setWidth(this.cellWidth);
        this.selectedRow.setWidth(this.headerWidth);
        this.selectedColumn.setWidth(this.cellWidth);
        this.selection.setHeight(cellHeight);
        this.selectedRow.setHeight(cellHeight);
        this.selectedColumn.setHeight(headerHeight);
        this.selectedRow.setX(x);
        this.selectedColumn.setY(y);
        if (cellSpacing < this.headerWidth) {
            this.headerWidth -= cellSpacing;
            this.leftPosition += cellSpacing;
        }
        if (this.layoutAll || oldPos != this.leftPosition) {
            this.layoutInArea((Node)this.headerRow, x, y, width, headerHeight, Double.NEGATIVE_INFINITY, HPos.LEFT, VPos.TOP);
            ObservableList children = this.headerRow.getChildren();
            int count = children.size();
            int missing = (int)Math.ceil((width - this.headerWidth) / this.cellWidth) - count;
            if (missing != 0) {
                if (missing < 0) {
                    children.remove(missing + count, count);
                } else {
                    GridCell[] more = new GridCell[missing];
                    Font font = Font.font(null, (FontWeight)FontWeight.BOLD, (double)-1.0);
                    for (int i = 0; i < missing; ++i) {
                        Object cell = new GridCell();
                        cell.setFont(font);
                        more[i] = cell;
                    }
                    children.addAll((Object[])more);
                }
            }
            double pos = x + this.headerWidth;
            int column = this.firstVisibleColumn;
            for (Node cell : children) {
                ((GridCell)cell).setText(view.formatHeaderValue(column++, false));
                this.layoutInArea(cell, pos, y, this.cellWidth, headerHeight, Double.NEGATIVE_INFINITY, HPos.RIGHT, VPos.CENTER);
                pos += this.cellWidth;
            }
            boolean bl = this.layoutAll = count <= missing;
        }
        if (this.selection.isVisible() && (row = (GridRow)flow.getFirstVisibleCell()) != null) {
            double sy = this.selection.getY() - (row.getLayoutY() + headerHeight);
            int i = (int)Math.rint(sy / cellHeight) + row.getIndex();
            row = (GridRow)flow.getCell(i);
            sy = row.getLayoutY() + headerHeight;
            double offset = row.getLayoutX() + this.leftBackground.getWidth();
            double column = Math.rint((this.selection.getX() - offset) / this.cellWidth);
            double sx = column * this.cellWidth + offset;
            this.selection.setX(sx);
            this.selection.setY(sy);
            this.selectedRow.setY(sy);
            this.selectedColumn.setX(sx);
            ((GridView)this.getSkinnable()).formatCoordinates(this.firstVisibleColumn + (int)column, i);
        }
        if (this.hasErrors) {
            this.computeErrorBounds(flow);
        }
    }

    private void computeErrorBounds(Flow flow) {
        Node node;
        java.awt.Rectangle viewArea = new java.awt.Rectangle();
        GridRow first = (GridRow)flow.getFirstVisibleCell();
        int firstVisibleRow = 0;
        if (first != null) {
            viewArea.x = this.firstVisibleColumn;
            viewArea.y = firstVisibleRow = first.getIndex();
            viewArea.width = (int)((flow.getWidth() - this.leftBackground.getWidth()) / this.cellWidth);
            viewArea.height = (int)(flow.getVisibleHeight() / flow.getFixedCellSize());
        }
        ObservableList children = this.getChildren();
        int i = children.size();
        while (--i >= 0 && (node = (Node)children.get(i)) instanceof GridError) {
            GridError error = (GridError)node;
            boolean visible = false;
            java.awt.Rectangle area = error.getVisibleRegion(viewArea);
            if (!area.isEmpty()) {
                double cellHeight = flow.getFixedCellSize();
                double width = (double)area.width * this.cellWidth;
                double height = (double)area.height * cellHeight;
                this.layoutInArea((Node)error, this.cellWidth * (double)(area.x - this.firstVisibleColumn) + this.leftBackground.getWidth(), cellHeight * (double)(area.y - firstVisibleRow) + this.topBackground.getHeight(), width, height, Double.NEGATIVE_INFINITY, HPos.CENTER, VPos.CENTER);
                visible = error.getHeight() <= height && error.getWidth() <= width;
            }
            error.setVisible(visible);
        }
    }

    private static final class Flow
    extends VirtualFlow<GridRow>
    implements ChangeListener<Number> {
        Flow(GridView view) {
            this.setPannable(false);
            this.getHbar().valueProperty().addListener((ChangeListener)this);
            view.bandProperty.addListener((ChangeListener)this);
            view.cellSpacing.addListener((ChangeListener)this);
        }

        final double getHorizontalPosition() {
            return this.getHbar().getValue();
        }

        final double scrollHorizontal(double delta) {
            ScrollBar bar = this.getHbar();
            double previous = bar.getValue();
            double value = Math.max(bar.getMin(), Math.min(bar.getMax(), previous + delta));
            bar.setValue(value);
            return value - previous;
        }

        final double getVisibleHeight() {
            double height = this.getHeight();
            ScrollBar bar = this.getHbar();
            if (bar.isVisible()) {
                height -= bar.getHeight();
            }
            return height;
        }

        public void changed(ObservableValue<? extends Number> property, Number oldValue, Number newValue) {
            this.reconfigureCells();
        }
    }
}

