/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.text.NumberFormat;
import java.util.Optional;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.gui.coverage.CellFormat;
import org.apache.sis.gui.coverage.GridControls;
import org.apache.sis.gui.coverage.GridTile;
import org.apache.sis.gui.coverage.GridTileCache;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.gui.BackgroundThreads;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.LogHandler;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.ArgumentChecks;

@DefaultProperty(value="image")
public class GridView
extends Control {
    static final int MIN_CELL_SIZE = 1;
    static final String OUT_OF_BOUNDS = "";
    private ImageLoader loader;
    public final ObjectProperty<RenderedImage> imageProperty;
    private int width;
    private int height;
    private int minX;
    private int minY;
    private int numXTiles;
    private int tileWidth;
    private int tileHeight;
    private int tileGridXOffset;
    private int tileGridYOffset;
    private final GridTileCache tiles;
    private GridTile lastTile;
    public final IntegerProperty bandProperty;
    public final DoubleProperty headerWidth;
    public final DoubleProperty cellWidth;
    public final DoubleProperty cellHeight;
    public final DoubleProperty cellSpacing;
    public final ObjectProperty<Paint> headerBackground;
    private final NumberFormat headerFormat;
    final CellFormat cellFormat;
    private final GridControls controls;

    public GridView() {
        this(null);
    }

    GridView(GridControls controls) {
        this.controls = controls;
        this.bandProperty = new BandProperty();
        this.imageProperty = new SimpleObjectProperty((Object)this, "image");
        this.headerWidth = new SimpleDoubleProperty((Object)this, "headerWidth", 60.0);
        this.cellWidth = new SimpleDoubleProperty((Object)this, "cellWidth", 60.0);
        this.cellHeight = new SimpleDoubleProperty((Object)this, "cellHeight", 20.0);
        this.cellSpacing = new SimpleDoubleProperty((Object)this, "cellSpacing", 4.0);
        this.headerBackground = new SimpleObjectProperty((Object)this, "headerBackground", (Object)Color.GAINSBORO);
        this.headerFormat = NumberFormat.getIntegerInstance();
        this.cellFormat = new CellFormat(this);
        this.tiles = new GridTileCache();
        this.tileWidth = 1;
        this.tileHeight = 1;
        this.setMinSize(120.0, 40.0);
        this.imageProperty.addListener((p, o, n) -> this.onImageSpecified((RenderedImage)n));
    }

    public final RenderedImage getImage() {
        return (RenderedImage)this.imageProperty.get();
    }

    public final void setImage(RenderedImage image) {
        this.imageProperty.set((Object)image);
    }

    public void setImage(ImageRequest source) {
        if (source == null) {
            this.setImage((RenderedImage)null);
            if (this.controls != null) {
                this.controls.notifyDataChanged(null, null);
            }
        } else {
            this.cancelLoader();
            this.loader = new ImageLoader(source);
            BackgroundThreads.execute((Runnable)((Object)this.loader));
        }
    }

    private void setLoadedImage(GridCoverageResource resource, GridCoverage coverage, RenderedImage image) {
        this.loader = null;
        this.setImage(image);
        if (this.controls != null && !this.controls.isAdjustingSlice) {
            this.controls.notifyDataChanged(resource, coverage);
        }
    }

    public final int getBand() {
        return this.bandProperty.get();
    }

    public final void setBand(int index) {
        this.bandProperty.set(index);
    }

    private void cancelLoader() {
        ImageLoader previous = this.loader;
        if (previous != null) {
            this.loader = null;
            previous.cancel(false);
        }
    }

    private void onImageSpecified(RenderedImage image) {
        this.cancelLoader();
        this.tiles.clear();
        this.lastTile = null;
        this.width = 0;
        this.height = 0;
        if (image != null) {
            this.minX = image.getMinX();
            this.minY = image.getMinY();
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.numXTiles = image.getNumXTiles();
            this.tileWidth = Math.max(1, image.getTileWidth());
            this.tileHeight = Math.max(1, image.getTileHeight());
            this.tileGridXOffset = Math.subtractExact(image.getTileGridXOffset(), this.minX);
            this.tileGridYOffset = Math.subtractExact(image.getTileGridYOffset(), this.minY);
            this.cellFormat.dataTypeIsInteger = false;
            SampleModel sm = image.getSampleModel();
            if (sm != null) {
                int numBands = sm.getNumBands();
                if (this.getBand() >= numBands) {
                    ((BandProperty)this.bandProperty).setNoCheck(numBands - 1);
                }
                this.cellFormat.dataTypeIsInteger = ImageUtilities.isIntegerType((SampleModel)sm);
            }
            this.cellFormat.configure(image, this.getBand());
        }
        this.contentChanged(true);
    }

    final void contentChanged(boolean all) {
        Skin skin = this.getSkin();
        if (skin instanceof GridViewSkin) {
            ((GridViewSkin)skin).contentChanged(all);
        }
    }

    final double getContentWidth() {
        double w = GridView.getSizeValue(this.cellWidth);
        return (double)this.width * w + GridView.getSizeValue(this.headerWidth) + Math.max(w, 20.0);
    }

    static double getSizeValue(DoubleProperty property) {
        double value = property.get();
        return value >= 1.0 ? value : 1.0;
    }

    final int getImageHeight() {
        return this.height;
    }

    final Rectangle getTileBounds(int tileX, int tileY) {
        return new Rectangle(tileX * this.tileWidth + this.tileGridXOffset, tileY * this.tileHeight + this.tileGridYOffset, this.tileWidth, this.tileHeight);
    }

    final int toTileY(int row) {
        return Math.floorDiv(Math.subtractExact(row, this.tileGridYOffset), this.tileHeight);
    }

    final String getSampleValue(int tileY, int row, int column) {
        Raster tile;
        if (row < 0 || row >= this.height || column < 0 || column >= this.width) {
            return OUT_OF_BOUNDS;
        }
        int tileX = Math.floorDiv(Math.subtractExact(column, this.tileGridXOffset), this.tileWidth);
        GridTile cache = this.lastTile;
        if (cache == null || cache.tileX != tileX || cache.tileY != tileY) {
            GridTile key = new GridTile(tileX, tileY, this.numXTiles);
            cache = this.tiles.putIfAbsent(key, key);
            if (cache == null) {
                cache = key;
            }
            this.lastTile = cache;
        }
        if ((tile = cache.tile()) == null) {
            cache.load(this);
            return null;
        }
        return this.cellFormat.format(tile, Math.addExact(column, this.minX), Math.addExact(row, this.minY), this.getBand());
    }

    final String formatHeaderValue(int index, boolean vertical) {
        if (index >= 0 && index < (vertical ? this.height : this.width)) {
            return this.cellFormat.format(this.headerFormat, (long)index + (long)(vertical ? this.minY : this.minX));
        }
        return OUT_OF_BOUNDS;
    }

    public final Optional<StringProperty> cellFormatPattern() {
        return this.cellFormat.hasPattern() ? Optional.of(this.cellFormat) : Optional.empty();
    }

    final void formatCoordinates(int x, int y) {
        if (this.controls != null) {
            this.controls.status.setLocalCoordinates(this.minX + x, this.minY + y);
        }
    }

    final void hideCoordinates() {
        if (this.controls != null) {
            this.controls.status.handle((MouseEvent)null);
        }
    }

    protected final Skin<GridView> createDefaultSkin() {
        return new GridViewSkin(this);
    }

    private final class BandProperty
    extends IntegerPropertyBase {
        private BandProperty() {
        }

        public Object getBean() {
            return GridView.this;
        }

        public String getName() {
            return "band";
        }

        public void set(int band) {
            SampleModel sm;
            RenderedImage image = GridView.this.getImage();
            if (image != null && (sm = image.getSampleModel()) != null) {
                ArgumentChecks.ensureBetween("band", 0, sm.getNumBands() - 1, band);
                GridView.this.cellFormat.configure(image, band);
            } else {
                ArgumentChecks.ensurePositive("band", band);
            }
            super.set(band);
            GridView.this.contentChanged(false);
        }

        final void setNoCheck(int bands) {
            super.set(Math.max(bands, 0));
        }
    }

    private final class ImageLoader
    extends Task<RenderedImage> {
        private final ImageRequest request;
        private GridCoverage coverage;

        ImageLoader(ImageRequest request) {
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RenderedImage call() throws Exception {
            Long id = LogHandler.loadingStart((Resource)this.request.resource);
            try {
                this.coverage = this.request.load().forConvertedValues(true);
                if (this.isCancelled()) {
                    RenderedImage renderedImage = null;
                    return renderedImage;
                }
                GridExtent slice = this.request.slice;
                GridControls c = GridView.this.controls;
                if (c != null) {
                    GridGeometry gg = this.coverage.getGridGeometry();
                    slice = BackgroundThreads.runAndWait(() -> {
                        GridExtent s = c.configureSliceSelector(gg);
                        int[] xydims = c.sliceSelector.getXYDimensions();
                        c.status.applyCanvasGeometry(gg, s, xydims[0], xydims[1]);
                        return s;
                    });
                }
                RenderedImage renderedImage = this.coverage.render(slice);
                return renderedImage;
            }
            finally {
                LogHandler.loadingStop(id);
            }
        }

        protected void succeeded() {
            GridView.this.setLoadedImage(this.request.resource, this.coverage, (RenderedImage)this.getValue());
        }

        protected void cancelled() {
            GridView.this.setLoadedImage(null, null, null);
        }

        protected void failed() {
            this.cancelled();
            ExceptionReporter.canNotReadFile((Node)GridView.this, (Resource)this.request.resource, this.getException());
        }
    }
}

