/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.awt.Rectangle;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.sis.gui.coverage.GridTile;
import org.apache.sis.gui.coverage.GridView;
import org.apache.sis.gui.coverage.GridViewSkin;
import org.apache.sis.internal.gui.ExceptionReporter;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.util.resources.Vocabulary;

final class GridError
extends VBox {
    private final GridTile tile;
    private final Throwable exception;
    private final String header;
    private final Label message;
    private final Rectangle region;

    GridError(GridView view, GridTile tile, Throwable exception) {
        super(9.0);
        this.tile = tile;
        this.exception = exception;
        this.region = view.getTileBounds(tile.tileX, tile.tileY);
        this.header = Resources.format((short)5, tile.tileX, tile.tileY);
        Button details = new Button(Vocabulary.format((short)62));
        Button retry = new Button(Vocabulary.format((short)175));
        TilePane buttons = new TilePane(12.0, 0.0, new Node[]{details, retry});
        buttons.setPrefRows(1);
        buttons.setPrefColumns(2);
        buttons.setAlignment(Pos.CENTER);
        details.setMaxWidth(100.0);
        retry.setMaxWidth(100.0);
        details.setFocusTraversable(false);
        retry.setFocusTraversable(false);
        String t = exception.getLocalizedMessage();
        this.message = new Label((String)(t == null ? this.header : this.header + System.lineSeparator() + t));
        this.message.setTextFill((Paint)Color.RED);
        this.message.setLabelFor((Node)buttons);
        this.getChildren().addAll((Object[])new Node[]{this.message, buttons});
        this.setAlignment(Pos.CENTER);
        this.setPadding(new Insets(12.0, 18.0, 24.0, 18.0));
        details.setOnAction(e -> this.showDetails());
        retry.setOnAction(e -> this.retry());
    }

    final Rectangle getVisibleRegion(Rectangle viewArea) {
        return viewArea.intersection(this.region);
    }

    private void showDetails() {
        ExceptionReporter.show((Node)this, Resources.format((short)16), this.header, this.exception);
    }

    private void retry() {
        GridView view = (GridView)this.getParent();
        ((GridViewSkin)view.getSkin()).removeError(this);
        this.tile.clear();
    }
}

