/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.coverage;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.gui.coverage.CoverageCanvas;
import org.apache.sis.gui.coverage.CoverageExplorer;
import org.apache.sis.gui.coverage.CoverageStyling;
import org.apache.sis.gui.coverage.ImageRequest;
import org.apache.sis.gui.coverage.InterpolationConverter;
import org.apache.sis.gui.coverage.IsolineRenderer;
import org.apache.sis.gui.coverage.PropertyPaneCreator;
import org.apache.sis.gui.coverage.Stretching;
import org.apache.sis.gui.coverage.ViewAndControls;
import org.apache.sis.gui.dataset.WindowHandler;
import org.apache.sis.gui.map.MapMenu;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.gui.GUIUtilities;
import org.apache.sis.internal.gui.Resources;
import org.apache.sis.internal.gui.Styles;
import org.apache.sis.internal.gui.control.SyncWindowList;
import org.apache.sis.internal.gui.control.ValueColorMapper;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.util.resources.Vocabulary;

final class CoverageControls
extends ViewAndControls {
    final CoverageCanvas view;
    private final TableView<Category> categoryTable;
    private final CoverageStyling styling;
    private final ChoiceBox<Stretching> stretching;
    private final ChoiceBox<Interpolation> interpolation;
    private final IsolineRenderer isolines;

    CoverageControls(CoverageExplorer owner, WindowHandler window) {
        super(owner);
        TitledPane deferred;
        Locale locale = owner.getLocale();
        Resources resources = Resources.forLocale(locale);
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        this.view = new CoverageCanvas(this, locale);
        this.view.setBackground(Color.BLACK);
        this.status.track(this.view);
        MapMenu menu = new MapMenu(this.view);
        menu.addReferenceSystems(owner.referenceSystems);
        menu.addCopyOptions(this.status);
        Label crsControl = new Label();
        crsControl.setPadding(CONTENT_MARGIN);
        crsControl.setTooltip(new Tooltip(resources.getString((short)49)));
        menu.selectedReferenceSystem().ifPresent(text -> crsControl.textProperty().bind((ObservableValue)text));
        this.interpolation = InterpolationConverter.button(this.view);
        this.stretching = Stretching.createButton((ChangeListener<Stretching>)((ChangeListener)(p, o, n) -> this.view.setStyling((Stretching)((Object)n))));
        GridPane valuesControl = Styles.createControlGrid(0, CoverageControls.label(vocabulary, (short)231, this.interpolation), CoverageControls.label(vocabulary, (short)229, this.stretching));
        this.styling = new CoverageStyling(this.view);
        this.categoryTable = this.styling.createCategoryTable(resources, vocabulary);
        VBox.setVgrow(this.categoryTable, (Priority)Priority.ALWAYS);
        VBox displayPane = new VBox(new Node[]{CoverageControls.labelOfGroup(vocabulary, (short)168, (Region)crsControl, true), crsControl, CoverageControls.labelOfGroup(vocabulary, (short)216, (Region)valuesControl, false), valuesControl, CoverageControls.labelOfGroup(vocabulary, (short)248, this.categoryTable, false), this.categoryTable});
        ValueColorMapper mapper = new ValueColorMapper(resources, vocabulary);
        this.isolines = new IsolineRenderer(this.view);
        this.isolines.setIsolineTables(Collections.singletonList(mapper.getSteps()));
        Region view = mapper.getView();
        VBox.setVgrow((Node)view, (Priority)Priority.ALWAYS);
        VBox isolinesPane = new VBox(new Node[]{view});
        SyncWindowList windows = new SyncWindowList(window, resources, vocabulary);
        this.controlPanes = new TitledPane[]{new TitledPane(vocabulary.getString((short)67), (Node)displayPane), new TitledPane(vocabulary.getString((short)252), (Node)isolinesPane), new TitledPane(resources.getString((short)21), (Node)windows.getView()), deferred = new TitledPane(vocabulary.getString((short)237), null)};
        this.view.resourceProperty.addListener((p, o, n) -> this.notifyDataChanged((GridCoverageResource)n, null));
        this.view.coverageProperty.addListener((p, o, n) -> this.notifyDataChanged(this.view.getResourceIfAdjusting(), (GridCoverage)n));
        deferred.expandedProperty().addListener((ChangeListener)new PropertyPaneCreator(this.view, deferred));
        this.setView(this.view.getView());
    }

    private void notifyDataChanged(GridCoverageResource resource, GridCoverage coverage) {
        if (this.isAdjustingSlice) {
            return;
        }
        ObservableList items = this.categoryTable.getItems();
        if (coverage == null) {
            items.clear();
        } else {
            boolean visibleBand = false;
            items.setAll((Collection)((SampleDimension)coverage.getSampleDimensions().get(0)).getCategories());
        }
        this.owner.notifyDataChanged(resource, coverage);
    }

    @Override
    final void load(ImageRequest request) {
        this.view.setImage(request);
    }

    final void copyStyling(CoverageControls c) {
        this.styling.copyStyling(c.styling);
        this.view.setCategoryColors(c.view.getCategoryColors() == null ? null : this.styling);
        GUIUtilities.copySelection(c.stretching, this.stretching);
        GUIUtilities.copySelection(c.interpolation, this.interpolation);
    }
}

