/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.portrayal.PlanarCanvas;
import org.apache.sis.portrayal.RenderException;
import org.apache.sis.portrayal.TransformChangeEvent;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class CanvasFollower
implements PropertyChangeListener,
Disposable {
    protected final PlanarCanvas source;
    protected final PlanarCanvas target;
    private boolean initialized;
    private boolean disabled;
    private boolean followRealWorld;
    private MathTransform2D displayTransform;
    private MathTransform objectiveTransform;
    private byte displayTransformStatus;
    private byte objectiveTransformStatus;
    private static final byte VALID = 0;
    private static final byte OUTDATED = 1;
    private static final byte UNKNOWN = 2;
    private static final byte ERROR = 3;
    private boolean changing;

    public CanvasFollower(PlanarCanvas planarCanvas, PlanarCanvas planarCanvas2) {
        ArgumentChecks.ensureNonNull("source", planarCanvas);
        ArgumentChecks.ensureNonNull("target", planarCanvas2);
        this.source = planarCanvas;
        this.target = planarCanvas2;
        this.followRealWorld = true;
        this.displayTransformStatus = 1;
        this.objectiveTransformStatus = 1;
    }

    public void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            this.source.addPropertyChangeListener("objectiveCRS", this);
            this.target.addPropertyChangeListener("objectiveCRS", this);
            this.source.addPropertyChangeListener("objectiveToDisplay", this);
            this.target.addPropertyChangeListener("objectiveToDisplay", this);
        }
    }

    public boolean isDisabled() {
        return this.disabled | !this.initialized;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
    }

    public boolean getFollowRealWorld() {
        return this.followRealWorld;
    }

    public void setFollowRealWorld(boolean bl) {
        if (bl != this.followRealWorld) {
            this.followRealWorld = bl;
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = 1;
        }
    }

    public DirectPosition getSourceObjectivePOI() {
        Point2D point2D = this.getSourceDisplayPOI().orElse(null);
        if (point2D != null) {
            try {
                DirectPosition2D directPosition2D = new DirectPosition2D(point2D);
                this.source.objectiveToDisplay.inverseTransform(directPosition2D, directPosition2D);
                return directPosition2D;
            }
            catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                CanvasFollower.canNotCompute("getSourceObjectivePOI", noninvertibleTransformException);
            }
        }
        return this.source.getPointOfInterest(true);
    }

    public Optional<Point2D> getSourceDisplayPOI() {
        return Optional.empty();
    }

    public Optional<MathTransform2D> getDisplayTransform() {
        if (this.displayTransformStatus != 0) {
            if (this.displayTransformStatus != 1) {
                return Optional.empty();
            }
            this.displayTransformStatus = (byte)3;
            if (this.objectiveTransformStatus == 0 || this.findObjectiveTransform("getDisplayTransform")) {
                try {
                    MathTransform mathTransform = this.objectiveTransform;
                    if (mathTransform == null || mathTransform instanceof AffineTransform) {
                        AffineTransform affineTransform = this.source.objectiveToDisplay.createInverse();
                        if (mathTransform != null) {
                            affineTransform.preConcatenate((AffineTransform)mathTransform);
                        }
                        affineTransform.preConcatenate(this.target.objectiveToDisplay);
                        this.displayTransform = new AffineTransform2D(affineTransform);
                    } else {
                        this.displayTransform = MathTransforms.bidimensional(MathTransforms.concatenate(this.source.getObjectiveToDisplay().inverse(), mathTransform, this.target.getObjectiveToDisplay()));
                    }
                    this.displayTransformStatus = 0;
                }
                catch (java.awt.geom.NoninvertibleTransformException | NoninvertibleTransformException throwable) {
                    CanvasFollower.canNotCompute("getDisplayTransform", (Exception)throwable);
                }
            }
        }
        return Optional.ofNullable(this.displayTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void propertyChange(PropertyChangeEvent var1_1) {
        block8: {
            if (this.changing || !(var1_1 instanceof TransformChangeEvent)) break block8;
            try {
                block9: {
                    var2_2 = (TransformChangeEvent)var1_1;
                    this.displayTransformStatus = 1;
                    this.changing = true;
                    if (!var2_2.isSameSource(this.source)) break block9;
                    this.transformedSource(var2_2);
                    if (this.disabled || !this.filter(var2_2)) ** GOTO lbl37
                    if (!this.followRealWorld || this.objectiveTransformStatus != 0 && !this.findObjectiveTransform("propertyChange") || (var3_3 = (AffineTransform)var2_2.getObjectiveChange2D().orElse(null)) == null) ** GOTO lbl22
                    try {
                        if (this.objectiveTransform != null) {
                            var4_4 = this.getSourceObjectivePOI();
                            var5_6 = AffineTransforms2D.castOrCopy(MathTransforms.linear(this.objectiveTransform, var4_4));
                            var6_7 = var5_6.createInverse();
                            var6_7.preConcatenate(var3_3);
                            var6_7.preConcatenate(var5_6);
                            var3_3 = var6_7;
                        }
                        this.transformObjectiveCoordinates(var2_2, var3_3);
                        return;
                    }
                    catch (java.awt.geom.NoninvertibleTransformException | NullArgumentException | TransformException var4_5) {
                        CanvasFollower.canNotCompute("propertyChange", (Exception)var4_5);
lbl22:
                        // 2 sources

                        var2_2.getDisplayChange2D().ifPresent((Consumer<AffineTransform>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$propertyChange$0(org.apache.sis.portrayal.TransformChangeEvent java.awt.geom.AffineTransform ), (Ljava/awt/geom/AffineTransform;)V)((CanvasFollower)this, (TransformChangeEvent)var2_2));
                    }
                }
                if (!var2_2.isSameSource(this.target)) ** GOTO lbl37
                this.transformedTarget(var2_2);
            }
            finally {
                this.changing = false;
            }
        }
        if ("objectiveCRS".equals(var1_1.getPropertyName())) {
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = 1;
        }
lbl37:
        // 7 sources

    }

    protected boolean filter(TransformChangeEvent transformChangeEvent) {
        return transformChangeEvent.getReason().isNavigation();
    }

    protected void transformObjectiveCoordinates(TransformChangeEvent transformChangeEvent, AffineTransform affineTransform) {
        this.target.transformObjectiveCoordinates(affineTransform);
    }

    protected void transformDisplayCoordinates(TransformChangeEvent transformChangeEvent, AffineTransform affineTransform) {
        this.target.transformDisplayCoordinates(affineTransform);
    }

    protected void transformedSource(TransformChangeEvent transformChangeEvent) {
    }

    protected void transformedTarget(TransformChangeEvent transformChangeEvent) {
    }

    private boolean findObjectiveTransform(String string) {
        if (this.objectiveTransformStatus == 1) {
            this.displayTransform = null;
            this.objectiveTransform = null;
            this.displayTransformStatus = 1;
            this.objectiveTransformStatus = (byte)3;
            CoordinateReferenceSystem coordinateReferenceSystem = this.source.getObjectiveCRS();
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.target.getObjectiveCRS();
            if (coordinateReferenceSystem != null && coordinateReferenceSystem2 != null) {
                try {
                    GeographicBoundingBox geographicBoundingBox;
                    try {
                        geographicBoundingBox = this.target.getGeographicArea().orElse(null);
                    }
                    catch (RenderException renderException) {
                        CanvasFollower.canNotCompute(string, renderException);
                        geographicBoundingBox = null;
                    }
                    this.objectiveTransform = CRS.findOperation(coordinateReferenceSystem, coordinateReferenceSystem2, geographicBoundingBox).getMathTransform();
                    if (this.objectiveTransform.isIdentity()) {
                        this.objectiveTransform = null;
                    }
                    this.objectiveTransformStatus = 0;
                    return true;
                }
                catch (FactoryException factoryException) {
                    CanvasFollower.canNotCompute(string, (Exception)((Object)factoryException));
                }
            } else {
                this.objectiveTransformStatus = (byte)2;
            }
        }
        return false;
    }

    private static void canNotCompute(String string, Exception exception) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.portrayal"), CanvasFollower.class, string, exception);
    }

    @Override
    public void dispose() {
        this.source.removePropertyChangeListener("objectiveToDisplay", this);
        this.target.removePropertyChangeListener("objectiveToDisplay", this);
        this.source.removePropertyChangeListener("objectiveCRS", this);
        this.target.removePropertyChangeListener("objectiveCRS", this);
        this.initialized = false;
    }

    private /* synthetic */ void lambda$propertyChange$0(TransformChangeEvent transformChangeEvent, AffineTransform affineTransform) {
        this.transformDisplayCoordinates(transformChangeEvent, affineTransform);
    }
}

