/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.portrayal;

import java.util.Optional;
import java.util.OptionalDouble;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.portrayal.Canvas;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

final class CanvasContext
extends CoordinateOperationContext {
    private static final double DISPLAY_RESOLUTION = 1.0;
    private CoordinateOperation objectiveToGeographic;
    private GeographicBoundingBox geographicArea;
    private double resolution;

    CanvasContext() {
    }

    final void setObjectiveToGeographic(CoordinateOperation coordinateOperation) {
        this.objectiveToGeographic = coordinateOperation;
        this.clear();
    }

    final void clear() {
        this.geographicArea = null;
        this.resolution = 0.0;
    }

    final void partialClear(boolean bl) {
        if (bl) {
            this.resolution = 0.0;
        } else {
            this.geographicArea = null;
        }
    }

    final Optional<GeographicBoundingBox> getGeographicArea(Canvas canvas) throws TransformException {
        if (this.geographicArea != null) {
            return Optional.of(this.geographicArea);
        }
        this.recompute(canvas);
        return Optional.ofNullable(this.geographicArea);
    }

    final OptionalDouble getSpatialResolution(Canvas canvas) throws TransformException {
        if (!(this.resolution > 0.0)) {
            this.recompute(canvas);
            if (!(this.resolution > 0.0)) {
                return OptionalDouble.empty();
            }
        }
        return OptionalDouble.of(this.resolution);
    }

    private void recompute(Canvas canvas) throws TransformException {
        DefaultGeographicBoundingBox defaultGeographicBoundingBox;
        Object object;
        if (this.objectiveToGeographic == null) {
            return;
        }
        LinearTransform linearTransform = canvas.getObjectiveToDisplay();
        MathTransform mathTransform = MathTransforms.concatenate(linearTransform.inverse(), this.objectiveToGeographic.getMathTransform());
        if (this.geographicArea == null && !canvas.displayBounds.isAllNaN()) {
            object = Envelopes.transform(mathTransform, (Envelope)canvas.displayBounds);
            ((GeneralEnvelope)object).setCoordinateReferenceSystem(this.objectiveToGeographic.getTargetCRS());
            defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
            defaultGeographicBoundingBox.setBounds((Envelope)object);
            defaultGeographicBoundingBox.transitionTo(ModifiableMetadata.State.FINAL);
            this.geographicArea = defaultGeographicBoundingBox;
        }
        if (!(this.resolution > 0.0) && (object = canvas.getObjectivePOI()) != null) {
            double d;
            linearTransform.transform((double[])object, 0, (double[])object, 0, 1);
            defaultGeographicBoundingBox = MathTransforms.derivativeAndTransform(mathTransform, (double[])object, 0, (double[])object, 0);
            double[] dArray = new double[defaultGeographicBoundingBox.getNumCol()];
            double[] dArray2 = new double[defaultGeographicBoundingBox.getNumRow()];
            int n = dArray2.length;
            while (--n >= 0) {
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = defaultGeographicBoundingBox.getElement(n, i);
                }
                d = MathFunctions.magnitude(dArray);
                switch (n) {
                    case 0: {
                        d *= Math.cos(dArray2[1]);
                    }
                    case 1: {
                        d = Math.toRadians(d);
                    }
                }
                dArray2[n] = d;
            }
            Ellipsoid ellipsoid = ((GeographicCRS)this.objectiveToGeographic.getTargetCRS()).getDatum().getEllipsoid();
            d = Formulas.radiusOfConformalSphere(ellipsoid, dArray2[1]);
            d = ellipsoid.getAxisUnit().getConverterTo(Units.METRE).convert(d);
            this.resolution = MathFunctions.magnitude(dArray2) * d;
        }
    }

    final void refresh(Canvas canvas) throws TransformException {
        this.recompute(canvas);
        this.setAreaOfInterest(this.geographicArea);
        this.setDesiredAccuracy(this.resolution * 1.0);
    }
}

