/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.CRSBuilder;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.GridCacheValue;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.referencing.operation.builder.LocalizationGridException;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.NullArgumentException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public abstract class Grid
extends NamedElement {
    public static final int MIN_DIMENSION = 2;
    static final int MIN_SPAN = 2;
    private Axis[] axes;
    private CoordinateReferenceSystem crs;
    private boolean isCRSDetermined;
    private GridGeometry geometry;
    private boolean isGeometryDetermined;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;

    protected Grid() {
    }

    protected abstract Grid forDimensions(Dimension[] var1);

    public abstract int getSourceDimensions();

    protected abstract List<Dimension> getDimensions();

    public final Axis[] getAxes(Decoder decoder) throws IOException, DataStoreException {
        if (this.axes == null) {
            int n;
            this.axes = this.createAxes(decoder);
            Axis[] axisArray = new Axis[this.axes.length];
            int n2 = 0;
            int n3 = axisArray.length;
            Object object = this.axes;
            int n4 = ((Axis[])object).length;
            for (n = 0; n < n4; ++n) {
                Axis axis;
                axisArray[(axis = object[n]).getNumDimensions() <= 1 ? n2++ : --n3] = axis;
            }
            n3 = axisArray.length;
            while (n2 < axisArray.length) {
                object = axisArray[n2];
                if (n2 < n3 && ((Axis)object).isWraparound()) {
                    System.arraycopy(axisArray, n2 + 1, axisArray, n2, --n3 - n2);
                    axisArray[n3] = object;
                    continue;
                }
                ((Axis)object).mainDimensionFirst(axisArray, n2);
                ++n2;
            }
            for (n2 = 0; n2 < this.axes.length; ++n2) {
                object = this.axes[n2];
                if (((Axis)object).getNumDimensions() != 0) continue;
                n4 = n2;
                for (n = 0; n < this.axes.length; ++n) {
                    if (((Axis)object).direction.compareTo((CodeList)this.axes[n].direction) <= 0) continue;
                    n4 = n + 1;
                }
                if (n4 == n2) continue;
                if (n4 > n2) {
                    --n4;
                }
                System.arraycopy(this.axes, n2 + 1, this.axes, n2, this.axes.length - (n2 + 1));
                System.arraycopy(this.axes, n4, this.axes, n4 + 1, this.axes.length - (n4 + 1));
                this.axes[n4] = object;
                break;
            }
        }
        return this.axes;
    }

    protected abstract Axis[] createAxes(Decoder var1) throws IOException, DataStoreException;

    protected abstract boolean containsAllNamedAxes(String[] var1);

    final CoordinateReferenceSystem getCoordinateReferenceSystem(Decoder decoder, List<Exception> list, List<GridCacheValue> list2, Matrix matrix) throws IOException, DataStoreException {
        boolean bl;
        boolean bl2 = bl = list2 == null || list2.isEmpty();
        if (bl & this.isCRSDetermined) {
            return this.crs;
        }
        try {
            if (bl) {
                this.isCRSDetermined = true;
            }
            CoordinateReferenceSystem coordinateReferenceSystem = CRSBuilder.assemble(decoder, this, list2, matrix);
            if (bl) {
                this.crs = coordinateReferenceSystem;
            }
            return coordinateReferenceSystem;
        }
        catch (NullArgumentException | FactoryException throwable) {
            if (Grid.isNewWarning((Exception)throwable, list)) {
                this.canNotCreate(decoder, "getCoordinateReferenceSystem", (short)11, (Exception)throwable);
            }
            return null;
        }
    }

    private static boolean isNewWarning(Exception exception, List<Exception> list) {
        if (list != null) {
            for (Exception exception2 : list) {
                if (!Exceptions.messageEquals(exception, exception2)) continue;
                return false;
            }
            list.add(exception);
        }
        return true;
    }

    private GridExtent getExtent(Axis[] axisArray) {
        List<Dimension> list = this.getDimensions();
        int n = list.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l = list.get(i).length();
            if (l <= 0L) {
                return null;
            }
            lArray[n - 1 - i] = l;
        }
        DimensionNameType[] dimensionNameTypeArray = new DimensionNameType[n];
        switch (n) {
            default: {
                dimensionNameTypeArray[1] = DimensionNameType.ROW;
            }
            case 1: {
                dimensionNameTypeArray[0] = DimensionNameType.COLUMN;
            }
            case 0: 
        }
        for (Axis axis : axisArray) {
            DimensionNameType dimensionNameType;
            if (axis.getNumDimensions() != 1) continue;
            if (AxisDirections.isVertical((AxisDirection)axis.direction)) {
                dimensionNameType = DimensionNameType.VERTICAL;
            } else {
                if (!AxisDirections.isTemporal((AxisDirection)axis.direction)) continue;
                dimensionNameType = DimensionNameType.TIME;
            }
            int n2 = axis.gridDimensionIndices[0];
            n2 = dimensionNameTypeArray.length - 1 - n2;
            if (n2 < 0) continue;
            dimensionNameTypeArray[n2] = dimensionNameType;
        }
        return new GridExtent(dimensionNameTypeArray, null, lArray, false);
    }

    /*
     * WARNING - void declaration
     */
    final GridGeometry getGridGeometry(Decoder decoder) throws IOException, DataStoreException {
        if (!this.isGeometryDetermined) {
            try {
                void var10_15;
                int n;
                int n2;
                int n32;
                Object[] objectArray;
                this.isGeometryDetermined = true;
                Axis[] axisArray = this.getAxes(decoder);
                int n5 = this.getSourceDimensions();
                int n6 = axisArray.length;
                int[] nArray = new int[axisArray.length];
                ArrayList<MathTransform> arrayList = new ArrayList<MathTransform>(axisArray.length);
                MatrixSIS matrixSIS = Matrices.createZero((int)(n6 + 1), (int)(n5 + 1));
                matrixSIS.setElement(n6--, n5--, 1.0);
                for (int i = 0; i < axisArray.length; ++i) {
                    if (axisArray[i].trySetTransform((Matrix)matrixSIS, n5, i, arrayList)) continue;
                    nArray[arrayList.size() - 1] = i;
                }
                int[] nArray2 = new int[arrayList.size()];
                Arrays.fill(nArray2, -1);
                block7: for (int i = 0; i < nArray2.length; ++i) {
                    int n4 = nArray[i];
                    Axis mathTransform = axisArray[n4];
                    objectArray = mathTransform.gridDimensionIndices;
                    n32 = objectArray.length;
                    block8: for (n2 = 0; n2 < n32; ++n2) {
                        int mathTransform2 = objectArray[n2];
                        mathTransform2 = n5 - mathTransform2;
                        n = matrixSIS.getNumRow();
                        while (--n >= 0) {
                            if (matrixSIS.getElement(n, mathTransform2) == 0.0) continue;
                            continue block8;
                        }
                        nArray2[i] = mathTransform2;
                        matrixSIS.setElement(n4, mathTransform2, 1.0);
                        continue block7;
                    }
                }
                ArrayList<GridCacheValue> arrayList2 = new ArrayList<GridCacheValue>();
                boolean object = false;
                while (var10_15 < arrayList.size()) {
                    if (arrayList.get((int)var10_15) == null) {
                        void var11_19 = var10_15;
                        block11: while (++var11_19 < arrayList.size()) {
                            GridCacheValue gridCacheValue;
                            if (arrayList.get((int)var11_19) != null) continue;
                            objectArray = new Axis[]{axisArray[nArray[var10_15]], axisArray[nArray[var11_19]]};
                            n32 = nArray2[var10_15];
                            n2 = nArray2[var11_19];
                            switch (n32 - n2) {
                                case -1: {
                                    break;
                                }
                                case 1: {
                                    ArraysExt.swap(objectArray, 0, 1);
                                    break;
                                }
                                default: {
                                    continue block11;
                                }
                            }
                            if ((gridCacheValue = objectArray[0].createLocalizationGrid((Axis)objectArray[1])) == null) continue;
                            arrayList.set((int)var10_15, gridCacheValue.gridToCRS);
                            arrayList.remove((int)var11_19);
                            n = arrayList.size() - var11_19;
                            System.arraycopy(nArray, (int)(var11_19 + true), nArray, (int)var11_19, n);
                            System.arraycopy(nArray2, (int)(var11_19 + true), nArray2, (int)var11_19, n);
                            if (n2 < n32) {
                                nArray2[var10_15] = n2;
                            }
                            if (gridCacheValue.linearizationTarget == null) break;
                            arrayList2.add(gridCacheValue);
                            break;
                        }
                    }
                    ++var10_15;
                }
                for (int n32 : nArray2) {
                    if (n32 >= 0) continue;
                    return null;
                }
                CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem(decoder, null, arrayList2, (Matrix)matrixSIS);
                MathTransform mathTransform = null;
                int n4 = arrayList.size();
                MathTransformFactory mathTransformFactory = decoder.getMathTransformFactory();
                arrayList.add(mathTransformFactory.createAffineTransform((Matrix)matrixSIS));
                for (n2 = 0; n2 <= n4; ++n2) {
                    MathTransform mathTransform2 = (MathTransform)arrayList.get(n2);
                    if (mathTransform2 == null) continue;
                    if (n2 < n4) {
                        n = nArray2[n2];
                        mathTransform2 = mathTransformFactory.createPassThroughTransform(n, mathTransform2, n5 + 1 - (n + mathTransform2.getSourceDimensions()));
                    }
                    mathTransform = mathTransform == null ? mathTransform2 : mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform2);
                }
                for (Axis axis : axisArray) {
                    if (!axis.isCellCorner()) continue;
                    this.anchor = PixelInCell.CELL_CORNER;
                    break;
                }
                this.geometry = new GridGeometry(this.getExtent(axisArray), this.anchor, mathTransform, coordinateReferenceSystem);
            }
            catch (IllegalGridGeometryException | TransformException | FactoryException throwable) {
                this.canNotCreate(decoder, "getGridGeometry", (short)12, (Exception)throwable);
            }
        }
        return this.geometry;
    }

    final PixelInCell getAnchor() {
        return this.anchor;
    }

    private void canNotCreate(Decoder decoder, String string, short s, Exception exception) {
        CharSequence charSequence = null;
        if (exception instanceof LocalizationGridException) {
            charSequence = ((LocalizationGridException)((Object)exception)).getPotentialCause();
        }
        if (charSequence == null) {
            charSequence = exception.getLocalizedMessage();
        }
        Grid.warning(decoder.listeners, Grid.class, string, exception, null, s, decoder.getFilename(), this.getName(), charSequence);
    }
}

