/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.SampleModelFactory;
import org.apache.sis.internal.geotiff.Compression;
import org.apache.sis.internal.geotiff.Predictor;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.metadata.iso.DefaultMetadata;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.geotiff.DataCube;
import org.apache.sis.storage.geotiff.GeoTiffStore;
import org.apache.sis.storage.geotiff.GridGeometryBuilder;
import org.apache.sis.storage.geotiff.ImageMetadataBuilder;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.Tags;
import org.apache.sis.storage.geotiff.Type;
import org.apache.sis.storage.geotiff.XMLMetadata;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;

final class ImageFileDirectory
extends DataCube {
    private static final byte TILE = 1;
    private static final byte STRIP = 2;
    private static final byte JPEG = 3;
    private static final byte SIGNED = 1;
    private static final byte UNSIGNED = 0;
    private static final byte FLOAT = 3;
    private final int index;
    private GenericName identifier;
    private ImageMetadataBuilder metadata;
    boolean hasDeferredEntries;
    private boolean isValidated;
    private int subfileType;
    private long imageWidth = -1L;
    private long imageHeight = -1L;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private Vector tileOffsets;
    private Vector tileByteCounts;
    private byte tileTagFamily;
    private boolean isPlanar;
    private byte sampleFormat;
    private boolean isBitOrderReversed;
    private short bitsPerSample;
    private short samplesPerPixel;
    private Vector extraSamples;
    private byte photometricInterpretation = (byte)-1;
    private Vector colorMap;
    private Vector minValues;
    private Vector maxValues;
    private boolean isMinSpecified;
    private boolean isMaxSpecified;
    private double noData = Double.NaN;
    private Compression compression;
    private Predictor predictor;
    private GridGeometryBuilder referencing;
    private GridGeometry gridGeometry;
    private List<SampleDimension> sampleDimensions;
    private SampleModel sampleModel;
    private ColorModel colorModel;

    private GridGeometryBuilder referencing() {
        if (this.referencing == null) {
            this.referencing = new GridGeometryBuilder();
        }
        return this.referencing;
    }

    ImageFileDirectory(Reader reader, int n) {
        super(reader);
        this.index = n;
        this.metadata = new ImageMetadataBuilder();
    }

    private ChannelDataInput input() {
        return this.reader.input;
    }

    private Charset encoding() {
        return this.reader.store.encoding;
    }

    final String getImageIndex() {
        return String.valueOf(this.index + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<GenericName> getIdentifier() {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.identifier == null) {
                if (this.isReducedResolution()) {
                    return Optional.empty();
                }
                LocalName localName = this.reader.nameFactory.createLocalName(this.reader.store.namespace(), (CharSequence)this.getImageIndex());
                localName = localName.toFullyQualifiedName();
                this.identifier = this.reader.store.customizer.customize(this.index, (GenericName)localName);
                if (this.identifier == null) {
                    this.identifier = localName;
                }
            }
            return Optional.of(this.identifier);
        }
    }

    final void setOverviewIdentifier(NameSpace nameSpace, int n) {
        this.identifier = this.reader.nameFactory.createLocalName(nameSpace, (CharSequence)("overview-" + n));
    }

    Object addEntry(short s, Type type, long l) throws Exception {
        block0 : switch (s) {
            case 284: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    case 1: {
                        this.isPlanar = false;
                        break block0;
                    }
                    case 2: {
                        this.isPlanar = true;
                        break block0;
                    }
                }
                return n;
            }
            case 256: {
                this.imageWidth = type.readUnsignedLong(this.input(), l);
                break;
            }
            case 257: {
                this.imageHeight = type.readUnsignedLong(this.input(), l);
                break;
            }
            case 322: {
                this.setTileTagFamily((byte)1);
                this.tileWidth = type.readInt(this.input(), l);
                break;
            }
            case 323: {
                this.setTileTagFamily((byte)1);
                this.tileHeight = type.readInt(this.input(), l);
                break;
            }
            case 278: {
                this.setTileTagFamily((byte)2);
                this.tileHeight = type.readInt(this.input(), l);
                break;
            }
            case 324: {
                this.setTileTagFamily((byte)1);
                this.tileOffsets = type.readVector(this.input(), l);
                break;
            }
            case 273: {
                this.setTileTagFamily((byte)2);
                this.tileOffsets = type.readVector(this.input(), l);
                break;
            }
            case 325: {
                this.setTileTagFamily((byte)1);
                this.tileByteCounts = type.readVector(this.input(), l);
                break;
            }
            case 279: {
                this.setTileTagFamily((byte)2);
                this.tileByteCounts = type.readVector(this.input(), l);
                break;
            }
            case 513: {
                this.setTileTagFamily((byte)3);
                this.tileOffsets = type.readVector(this.input(), l);
                break;
            }
            case 514: {
                this.setTileTagFamily((byte)3);
                this.tileByteCounts = type.readVector(this.input(), l);
                break;
            }
            case 259: {
                int n = type.readInt(this.input(), l);
                this.compression = Compression.valueOf(n);
                if (this.compression != Compression.UNKNOWN) break;
                return n;
            }
            case 317: {
                int n = type.readInt(this.input(), l);
                this.predictor = Predictor.valueOf(n);
                if (this.predictor != Predictor.UNKNOWN) break;
                return n;
            }
            case 266: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    case 1: {
                        this.isBitOrderReversed = false;
                        break block0;
                    }
                    case 2: {
                        this.isBitOrderReversed = true;
                        break block0;
                    }
                }
                return n;
            }
            case 339: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    default: {
                        return n;
                    }
                    case 1: {
                        this.sampleFormat = 0;
                        break block0;
                    }
                    case 2: {
                        this.sampleFormat = 1;
                        break block0;
                    }
                    case 3: {
                        this.sampleFormat = (byte)3;
                        break block0;
                    }
                    case 4: 
                }
                this.warning(Level.WARNING, (short)25, this.filename());
                break;
            }
            case 258: {
                Vector vector = type.readVector(this.input(), l);
                this.bitsPerSample = vector.shortValue(0);
                int n = vector.size();
                for (int i = 1; i < n; ++i) {
                    if (vector.shortValue(i) == this.bitsPerSample) continue;
                    throw new DataStoreContentException(this.reader.resources().getString((short)3, "BitsPerSample", this.filename(), vector));
                }
                break;
            }
            case 277: {
                this.samplesPerPixel = type.readShort(this.input(), l);
                break;
            }
            case 338: {
                this.extraSamples = type.readVector(this.input(), l);
                break;
            }
            case 262: {
                short s2 = type.readShort(this.input(), l);
                if (s2 < 0 || s2 > 127) {
                    return s2;
                }
                this.photometricInterpretation = (byte)s2;
                break;
            }
            case 320: {
                this.colorMap = type.readVector(this.input(), l);
                break;
            }
            case 280: 
            case 340: {
                this.minValues = ImageFileDirectory.extremum(this.minValues, type.readVector(this.input(), l), false);
                this.isMinSpecified = true;
                break;
            }
            case 281: 
            case 341: {
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, type.readVector(this.input(), l), true);
                this.isMaxSpecified = true;
                break;
            }
            case 254: {
                this.subfileType = type.readInt(this.input(), l);
                break;
            }
            case 255: {
                int n = type.readInt(this.input(), l);
                switch (n) {
                    default: {
                        return n;
                    }
                    case 1: {
                        this.subfileType &= 0xFFFFFFFE;
                        break block0;
                    }
                    case 2: {
                        this.subfileType |= 1;
                        break block0;
                    }
                    case 3: 
                }
                this.subfileType |= 2;
                break;
            }
            case -30801: {
                this.referencing().keyDirectory = type.readVector(this.input(), l);
                break;
            }
            case -30800: {
                this.referencing().numericParameters = type.readVector(this.input(), l);
                break;
            }
            case -30799: {
                this.referencing().setAsciiParameters(type.readString(this.input(), l, this.encoding()));
                break;
            }
            case 274: {
                break;
            }
            case -31272: {
                int n;
                Vector vector = type.readVector(this.input(), l);
                switch (vector.size()) {
                    case 6: 
                    case 9: {
                        n = 3;
                        break;
                    }
                    case 12: 
                    case 16: {
                        n = 4;
                        break;
                    }
                    default: {
                        return vector;
                    }
                }
                this.referencing().setGridToCRS(vector, n);
                break;
            }
            case -31986: {
                Vector vector = type.readVector(this.input(), l);
                int n = vector.size();
                if (n < 2 || n > 3) {
                    return vector;
                }
                this.referencing().setScaleFactors(vector);
                break;
            }
            case -31614: {
                this.referencing().modelTiePoints = type.readVector(this.input(), l);
                break;
            }
            case 269: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addSeries(string);
                }
                break;
            }
            case 285: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addPage(string);
                }
                break;
            }
            case 297: {
                Vector vector = type.readVector(this.input(), l);
                int n = 0;
                int n2 = 0;
                switch (vector.size()) {
                    default: {
                        n2 = vector.intValue(1);
                    }
                    case 1: {
                        n = vector.intValue(0);
                    }
                    case 0: 
                }
                this.metadata.addPage(n, n2);
                break;
            }
            case 270: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addTitle(Strings.singleLine((String)" ", (CharSequence)string));
                }
                break;
            }
            case 315: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addAuthor(string);
                }
                break;
            }
            case -32104: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.parseLegalNotice(string);
                }
                break;
            }
            case 306: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addCitationDate(this.reader.getDateFormat().parse(string), DateType.CREATION, MetadataBuilder.Scope.RESOURCE);
                }
                break;
            }
            case 316: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addHostComputer(string);
                }
                break;
            }
            case 305: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addSoftwareReference(string);
                }
                break;
            }
            case 271: {
                break;
            }
            case 272: {
                for (String string : type.readString(this.input(), l, this.encoding())) {
                    this.metadata.addInstrument(null, string);
                }
                break;
            }
            case 282: 
            case 283: {
                this.metadata.setResolution(type.readDouble(this.input(), l));
                break;
            }
            case 296: {
                return this.metadata.setResolutionUnit(type.readInt(this.input(), l));
            }
            case 263: {
                return this.metadata.setThreshholding(type.readShort(this.input(), l));
            }
            case 264: 
            case 265: {
                this.metadata.setCellSize(type.readShort(this.input(), l), s == 264);
                break;
            }
            case 288: 
            case 289: 
            case 290: 
            case 291: {
                this.warning(Level.FINE, (short)7, Tags.name(s));
                break;
            }
            case -23424: 
            case -14627: {
                this.metadata.addXML(new XMLMetadata(this.reader, type, l, s));
                break;
            }
            case -23423: {
                this.noData = type.readDouble(this.input(), l);
            }
        }
        return null;
    }

    private void setTileTagFamily(byte by) throws DataStoreContentException {
        if (this.tileTagFamily != by && this.tileTagFamily != 0) {
            throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
        }
        this.tileTagFamily = by;
    }

    private static Vector extremum(Vector vector, Vector vector2, boolean bl) {
        if (vector != null) {
            int n = vector2.size();
            int n2 = vector.size();
            if (n2 > n) {
                n2 = n;
                Vector vector3 = vector;
                vector = vector2;
                vector2 = vector3;
            }
            while (--n2 >= 0) {
                double d = vector.doubleValue(n2);
                double d2 = vector2.doubleValue(n2);
                if (!Double.isNaN(d2) && !(bl ? d > d2 : d < d2)) continue;
                vector2.set(n2, (Number)d);
            }
        }
        return vector2;
    }

    private long pixelToByteCount(long l) {
        return (l = Math.multiplyExact(l, (long)(this.samplesPerPixel * this.bitsPerSample))) % 8L == 0L ? l / 8L : 0L;
    }

    private int computeTileSize(int n) {
        int n2 = this.tileByteCounts.size();
        if (n2 != 0) {
            long l = this.tileByteCounts.longValue(0);
            int n3 = 0;
            do {
                if (++n3 != n2) continue;
                long l2 = this.pixelToByteCount(n);
                if (l2 == 0L || l % l2 != 0L) break;
                return Math.toIntExact(l / l2);
            } while (this.tileByteCounts.longValue(n3) == (long)n2);
        }
        return -1;
    }

    final boolean validateMandatoryTags() throws DataStoreContentException {
        int n;
        long l;
        int n2;
        short s;
        short s2;
        if (this.isValidated) {
            return false;
        }
        if (this.imageWidth < 0L) {
            throw this.missingTag((short)256);
        }
        if (this.imageHeight < 0L) {
            throw this.missingTag((short)257);
        }
        switch (this.tileTagFamily) {
            case 2: 
            case 3: {
                if (this.tileWidth < 0) {
                    this.tileWidth = Math.toIntExact(this.imageWidth);
                }
                if (this.tileHeight < 0) {
                    this.tileHeight = Math.toIntExact(this.imageHeight);
                }
                s2 = 273;
                s = 279;
                break;
            }
            case 1: {
                s2 = 324;
                s = 325;
                break;
            }
            default: {
                throw new DataStoreContentException(this.reader.resources().getString((short)8, this.filename()));
            }
        }
        if (this.tileOffsets == null) {
            throw this.missingTag(s2);
        }
        if (this.samplesPerPixel == 0) {
            this.samplesPerPixel = 1;
            this.missingTag((short)277, 1, false, false);
        }
        if (this.bitsPerSample == 0) {
            this.bitsPerSample = 1;
            this.missingTag((short)258, 1, false, false);
        }
        if (this.colorMap != null) {
            this.ensureSameLength((short)320, (short)258, this.colorMap.size(), 3 * (1 << this.bitsPerSample));
        }
        if (this.sampleFormat != 3) {
            long l2;
            long l3;
            if (this.sampleFormat == 0) {
                l3 = 0L;
                l2 = -1L;
            } else {
                l3 = Long.MIN_VALUE;
                l2 = Long.MAX_VALUE;
            }
            int n3 = 64 - this.bitsPerSample;
            if (n3 >= 0 && n3 < 64 && (l3 >>>= n3) < (l2 >>>= n3)) {
                this.minValues = ImageFileDirectory.extremum(this.minValues, Vector.createSequence((Number)l3, (Number)0, (int)this.samplesPerPixel), false);
                this.maxValues = ImageFileDirectory.extremum(this.maxValues, Vector.createSequence((Number)l2, (Number)0, (int)this.samplesPerPixel), true);
            }
        }
        int n4 = n2 = !this.isPlanar && this.compression.equals((Object)Compression.NONE) ? 0 : 8;
        if (this.tileWidth < 0) {
            n2 |= 1;
        }
        if (this.tileHeight < 0) {
            n2 |= 2;
        }
        if (this.tileByteCounts == null) {
            n2 |= 4;
        }
        switch (n2) {
            case 0: 
            case 8: {
                break;
            }
            case 1: {
                this.tileWidth = this.computeTileSize(this.tileHeight);
                this.missingTag((short)322, this.tileWidth, true, true);
                break;
            }
            case 2: {
                this.tileHeight = this.computeTileSize(this.tileWidth);
                this.missingTag((short)323, this.tileHeight, true, true);
                break;
            }
            case 4: {
                l = this.pixelToByteCount(Math.multiplyExact(this.tileWidth, this.tileHeight));
                if (l == 0L) {
                    throw this.missingTag(s);
                }
                long[] lArray = new long[this.tileOffsets.size()];
                Arrays.fill(lArray, l);
                this.tileByteCounts = Vector.create((Object)lArray, (boolean)true);
                this.missingTag(s, l, true, true);
                break;
            }
            default: {
                short s3;
                switch (Integer.lowestOneBit(n2)) {
                    case 1: {
                        s3 = 322;
                        break;
                    }
                    case 2: {
                        s3 = 323;
                        break;
                    }
                    default: {
                        s3 = s;
                    }
                }
                throw this.missingTag(s3);
            }
        }
        this.ensureSameLength(s, s2, this.tileByteCounts.size(), this.tileOffsets.size());
        l = this.getNumTiles();
        if (this.isPlanar) {
            l = Math.multiplyExact(l, (long)this.samplesPerPixel);
        }
        if ((long)(n = Math.min(this.tileOffsets.size(), this.tileByteCounts.size())) != l) {
            throw new DataStoreContentException(this.reader.resources().getString((short)18, this.filename(), l, n));
        }
        if (this.referencing != null && !this.referencing.validateMandatoryTags()) {
            throw this.missingTag((short)-31614);
        }
        this.isValidated = true;
        return true;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        Metadata metadata;
        ImageMetadataBuilder imageMetadataBuilder = this.metadata;
        if (imageMetadataBuilder == null) {
            return super.createMetadata();
        }
        this.metadata = null;
        boolean bl = !this.isReducedResolution();
        imageMetadataBuilder.newCoverage(bl && this.reader.store.customizer.isElectromagneticMeasurement(this.index));
        List<SampleDimension> list = this.getSampleDimensions();
        for (int i = 0; i < this.samplesPerPixel; ++i) {
            imageMetadataBuilder.addNewBand(list.get(i));
            imageMetadataBuilder.setBitPerSample(this.bitsPerSample);
            if (imageMetadataBuilder.hasSampleValueRange()) continue;
            if (this.isMinSpecified) {
                imageMetadataBuilder.addMinimumSampleValue(this.minValues.doubleValue(Math.min(i, this.minValues.size() - 1)));
            }
            if (!this.isMaxSpecified) continue;
            imageMetadataBuilder.addMaximumSampleValue(this.maxValues.doubleValue(Math.min(i, this.maxValues.size() - 1)));
        }
        if (this.referencing != null) {
            GridGeometry gridGeometry = this.getGridGeometry();
            if (gridGeometry.isDefined(2)) {
                try {
                    imageMetadataBuilder.addExtent(gridGeometry.getEnvelope());
                }
                catch (TransformException transformException) {
                    this.listeners.warning((Exception)((Object)transformException));
                }
            }
            this.referencing.completeMetadata(gridGeometry, imageMetadataBuilder);
        }
        imageMetadataBuilder.finish(this, this.listeners);
        DefaultMetadata defaultMetadata = imageMetadataBuilder.build();
        if (bl && (metadata = this.reader.store.customizer.customize(this.index, defaultMetadata)) != null) {
            return metadata;
        }
        return defaultMetadata;
    }

    final boolean isReducedResolution() {
        return (this.subfileType & 1) != 0;
    }

    final void initReducedResolution(ImageFileDirectory imageFileDirectory, double[] dArray) throws DataStoreException, TransformException {
        if (this.referencing == null) {
            this.gridGeometry = new GridGeometry(imageFileDirectory.getGridGeometry(), this.getExtent(), (MathTransform)MathTransforms.scale((double[])dArray));
        }
        if (this.samplesPerPixel == imageFileDirectory.samplesPerPixel) {
            this.sampleDimensions = imageFileDirectory.getSampleDimensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridGeometry getGridGeometry() throws DataStoreContentException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.gridGeometry == null) {
                if (this.referencing != null) {
                    try {
                        this.gridGeometry = this.referencing.build(this.reader, this.imageWidth, this.imageHeight);
                    }
                    catch (FactoryException factoryException) {
                        throw new DataStoreContentException(this.reader.resources().getString((short)26, this.filename()), factoryException);
                    }
                } else {
                    this.gridGeometry = new GridGeometry(this.getExtent(), null, null);
                }
            }
            return this.gridGeometry;
        }
    }

    final GridExtent getExtent() {
        return new GridExtent(this.imageWidth, this.imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreContentException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (this.sampleDimensions == null) {
                Object[] objectArray = new SampleDimension[this.samplesPerPixel];
                SampleDimension.Builder builder = new SampleDimension.Builder();
                boolean bl = !this.isReducedResolution();
                for (int i = 0; i < objectArray.length; ++i) {
                    NumberRange numberRange = null;
                    if (this.minValues != null && this.maxValues != null) {
                        numberRange = NumberRange.createBestFit((this.sampleFormat == 3 ? 1 : 0) != 0, (Number)this.minValues.get(Math.min(i, this.minValues.size() - 1)), (boolean)true, (Number)this.maxValues.get(Math.min(i, this.maxValues.size() - 1)), (boolean)true);
                    }
                    builder.setName(i + 1).setBackground(this.getFillValue(true));
                    SampleDimension sampleDimension = bl ? this.reader.store.customizer.customize(this.index, i, numberRange, builder) : builder.build();
                    objectArray[i] = sampleDimension;
                    builder.clear();
                }
                this.sampleDimensions = UnmodifiableArrayList.wrap((Object[])objectArray);
            }
            return this.sampleDimensions;
        }
    }

    @Override
    protected SampleModel getSampleModel() throws DataStoreContentException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if (this.sampleModel == null) {
            try {
                this.sampleModel = new SampleModelFactory(this.getDataType(), this.tileWidth, this.tileHeight, this.samplesPerPixel, this.bitsPerSample, this.isPlanar).build();
            }
            catch (RasterFormatException | IllegalArgumentException runtimeException) {
                throw new DataStoreContentException(Errors.format((short)163, (Object)((Object)this.getDataType())), runtimeException);
            }
        }
        return this.sampleModel;
    }

    @Override
    protected int getNumBands() {
        return this.samplesPerPixel;
    }

    @Override
    protected int[] getTileSize() {
        return new int[]{this.tileWidth, this.tileHeight};
    }

    @Override
    final long getNumTiles() {
        return Math.multiplyExact(Numerics.ceilDiv((long)this.imageWidth, (long)this.tileWidth), Numerics.ceilDiv((long)this.imageHeight, (long)this.tileHeight));
    }

    private DataType getDataType() throws DataStoreContentException {
        String string;
        switch (this.sampleFormat) {
            case 1: {
                if (this.bitsPerSample < 8) {
                    return DataType.BYTE;
                }
                if (this.bitsPerSample <= 16) {
                    return DataType.SHORT;
                }
                if (this.bitsPerSample <= 32) {
                    return DataType.INT;
                }
                string = "int";
                break;
            }
            case 0: {
                if (this.bitsPerSample <= 8) {
                    return DataType.BYTE;
                }
                if (this.bitsPerSample <= 16) {
                    return DataType.USHORT;
                }
                if (this.bitsPerSample <= 32) {
                    return DataType.INT;
                }
                string = "unsigned";
                break;
            }
            case 3: {
                if (this.bitsPerSample == 32) {
                    return DataType.FLOAT;
                }
                if (this.bitsPerSample == 64) {
                    return DataType.DOUBLE;
                }
                string = "float";
                break;
            }
            default: {
                string = "?";
            }
        }
        throw new DataStoreContentException(Errors.format((short)163, (Object)(string + ' ' + this.bitsPerSample + " bits")));
    }

    @Override
    protected ColorModel getColorModel() throws DataStoreContentException {
        assert (Thread.holdsLock(this.getSynchronizationLock()));
        if (this.colorModel == null) {
            SampleModel sampleModel = this.getSampleModel();
            int n = sampleModel.getDataType();
            short s = 0;
            switch (this.photometricInterpretation) {
                default: {
                    this.unsupportedTagValue((short)262, this.photometricInterpretation);
                    break;
                }
                case -1: {
                    s = 262;
                    break;
                }
                case 0: 
                case 1: {
                    Object[] objectArray = new Color[]{Color.BLACK, Color.WHITE};
                    if (this.photometricInterpretation == 0) {
                        ArraysExt.swap((Object[])objectArray, (int)0, (int)1);
                    }
                    double d = 0.0;
                    double d2 = Numerics.bitmask((int)this.bitsPerSample);
                    if (this.sampleFormat != 0) {
                        d = -(d2 /= 2.0);
                    }
                    if (this.minValues != null) {
                        d = Math.max(d, this.minValues.doubleValue(0));
                    }
                    if (this.maxValues != null) {
                        d2 = Math.min(d2, this.maxValues.doubleValue(0) + 1.0);
                    }
                    this.colorModel = ColorModelFactory.createColorScale(n, this.samplesPerPixel, 0, d, d2, (Color[])objectArray);
                    break;
                }
                case 2: {
                    int n2 = sampleModel.getNumBands();
                    if (n2 < 3 || n2 > 4) {
                        throw new DataStoreContentException(Errors.format((short)144, (Object)"numBands", (Object)n2));
                    }
                    boolean bl = n2 >= 4;
                    boolean bl2 = sampleModel instanceof SinglePixelPackedSampleModel;
                    this.colorModel = ColorModelFactory.createRGB(this.bitsPerSample, bl2, bl);
                    break;
                }
                case 3: {
                    if (this.colorMap == null) {
                        s = 320;
                        break;
                    }
                    int n3 = this.colorMap.size() / 3;
                    int n4 = n3 * 2;
                    int[] nArray = new int[n3];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = 0xFF000000 | (this.colorMap.intValue(i) & 0xFF00) << 8 | this.colorMap.intValue(n3++) & 0xFF00 | (this.colorMap.intValue(n4++) & 0xFF00) >>> 8;
                    }
                    this.colorModel = ColorModelFactory.createIndexColorModel(this.samplesPerPixel, 0, nArray, true, Double.isFinite(this.noData) ? (int)Math.round(this.noData) : -1);
                    break;
                }
            }
            if (s != 0) {
                this.missingTag(s, "GrayScale", false, true);
            }
        }
        return this.colorModel;
    }

    @Override
    protected Number getFillValue() {
        return this.getFillValue(false);
    }

    private Number getFillValue(boolean bl) {
        if (Double.isFinite(this.noData) && (bl || this.noData != 0.0)) {
            long l;
            long l2;
            switch (this.sampleFormat) {
                case 0: {
                    l2 = 1L << this.bitsPerSample;
                    l = 0L;
                    break;
                }
                case 1: {
                    l2 = 1L << this.bitsPerSample - 1;
                    l = l2 ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                default: {
                    return this.noData;
                }
            }
            long l3 = Math.round(this.noData);
            if (l3 >= l && l3 <= l2 && (bl || l3 != 0L)) {
                return Numbers.narrowestNumber((Number)l3);
            }
        }
        return null;
    }

    @Override
    Vector[] getTileArrayInfo() {
        return new Vector[]{this.tileOffsets, this.tileByteCounts};
    }

    @Override
    boolean isBitOrderReversed() {
        return this.isBitOrderReversed;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    Predictor getPredictor() {
        return this.predictor != null ? this.predictor : Predictor.NONE;
    }

    private void warning(Level level, short s, Object ... objectArray) {
        LogRecord logRecord = this.reader.resources().getLogRecord(level, s, objectArray);
        logRecord.setSourceClassName(GeoTiffStore.class.getName());
        logRecord.setSourceMethodName("components()");
        this.listeners.warning(logRecord);
    }

    private void ensureSameLength(short s, short s2, int n, int n2) {
        if (n != n2) {
            this.warning(Level.WARNING, (short)11, Tags.name(s), Tags.name(s2), n, n2);
        }
    }

    private void missingTag(short s, Object object, boolean bl, boolean bl2) {
        this.warning(bl2 ? Level.WARNING : Level.FINE, bl ? (short)2 : 4, Tags.name(s), object);
    }

    private void unsupportedTagValue(short s, Object object) {
        this.warning(Level.WARNING, (short)29, Tags.name(s), object);
    }

    private DataStoreContentException missingTag(short s) {
        return new DataStoreContentException(this.reader.resources().getString((short)13, this.filename(), Tags.name(s)));
    }
}

