/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.inflater.PixelChannel;
import org.apache.sis.util.ArraysExt;

abstract class PredictorChannel
extends PixelChannel {
    private final CompressionChannel input;
    private byte[] deferred;
    private int deferredCount;

    protected PredictorChannel(CompressionChannel compressionChannel) {
        this.input = compressionChannel;
        this.deferred = ArraysExt.EMPTY_BYTE;
    }

    @Override
    public void setInputRegion(long l, long l2) throws IOException {
        this.input.setInputRegion(l, l2);
        this.deferredCount = 0;
    }

    protected abstract int apply(ByteBuffer var1, int var2);

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        if (this.deferredCount != 0) {
            n = Math.min(this.deferredCount, byteBuffer.remaining());
            byteBuffer.put(this.deferred, 0, n);
            System.arraycopy(this.deferred, n, this.deferred, 0, this.deferredCount -= n);
        }
        this.input.read(byteBuffer);
        n = this.apply(byteBuffer, n2);
        int n3 = byteBuffer.position() - n;
        if (n3 != 0) {
            int n4 = this.deferredCount + n3;
            if (n4 > this.deferred.length) {
                this.deferred = new byte[n4];
            }
            JDK9.get((ByteBuffer)byteBuffer, (int)n, (byte[])this.deferred, (int)this.deferredCount, (int)n3);
            byteBuffer.position(n);
            this.deferredCount = n4;
        }
        return n - n2;
    }

    @Override
    public final boolean isOpen() {
        return this.input.isOpen();
    }

    @Override
    public final void close() {
        this.input.close();
    }
}

