/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.storage.event.StoreListeners;

final class LZW
extends CompressionChannel {
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_ADAPTATIVE_CODE = 258;
    private static final int OFFSET_TO_MAXIMUM = 1;
    private static final int MIN_CODE_SIZE = 9;
    private static final int MAX_CODE_SIZE = 12;
    private int codeSize;
    private static final int LOWEST_OFFSET_BIT = 12;
    private static final int LENGTH_MASK = 4095;
    private static final int STRING_ALIGNMENT = 2;
    private static final int PREALLOCATED_SPACE_IS_USED_MASK = Integer.MIN_VALUE;
    private static final int OFFSET_MASK = 0x7FFFF000;
    private static final int OFFSET_SHIFT = 10;
    private static final int OFFSET_LIMIT = 0x200000;
    private static final int LENGTH_MASK_FOR_ALLOCATE = 3;
    private final int[] entriesForCodes = new int[4095];
    private int previousCode;
    private int pendingOffset;
    private int pendingLength;
    private int indexOfFreeEntry = 258;
    private int indexOfFreeString;
    private byte[] stringsFromCode = new byte[49152];

    private static int length(int n) {
        return n & 0xFFF;
    }

    private static int offset(int n) {
        return (n & 0x7FFFF000) >>> 10;
    }

    private static int offsetAndLength(int n, int n2) {
        int n3 = n << 10 | n2;
        assert (LZW.offset(n3) == n) : n;
        assert (LZW.length(n3) == n2) : n2;
        return n3;
    }

    private static boolean newEntryNeedsAllocation(int n) {
        return (n & 0x80000003) <= 0;
    }

    public LZW(ChannelDataInput channelDataInput, StoreListeners storeListeners) {
        super(channelDataInput, storeListeners);
        for (int i = 0; i < 256; ++i) {
            this.stringsFromCode[i << 2] = (byte)i;
        }
    }

    @Override
    public void setInputRegion(long l, long l2) throws IOException {
        super.setInputRegion(l, l2);
        this.clearTable();
        this.previousCode = 0;
        this.pendingOffset = 0;
        this.pendingLength = 0;
    }

    private void clearTable() {
        for (int i = 0; i < 256; ++i) {
            this.entriesForCodes[i] = i << 12 | 1;
        }
        Arrays.fill(this.entriesForCodes, 258, this.indexOfFreeEntry, 0);
        this.indexOfFreeEntry = 258;
        this.indexOfFreeString = 1024;
        this.codeSize = 9;
    }

    public final int readNextCode() throws IOException {
        try {
            return (int)this.input.readBits(this.codeSize);
        }
        catch (EOFException eOFException) {
            if (this.finished()) {
                this.listeners.warning(null, eOFException);
                return 257;
            }
            throw eOFException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n;
        int n2;
        int n3 = byteBuffer.position();
        int n4 = this.previousCode;
        if (this.pendingLength != 0) {
            n2 = Math.min(this.pendingLength, byteBuffer.remaining());
            byteBuffer.put(this.stringsFromCode, this.pendingOffset, n2);
            this.pendingOffset += n2;
            this.pendingLength -= n2;
            if (this.pendingLength != 0 || n4 == 257) {
                return n2;
            }
        } else if (n4 == 257 || this.finished()) {
            return -1;
        }
        n2 = this.entriesForCodes[n4];
        int n5 = LZW.offset(n2);
        int n6 = LZW.length(n2);
        int n7 = (1 << this.codeSize) - 1;
        while ((n = this.readNextCode()) != 257) {
            block29: {
                int n8;
                if (n == 256) {
                    this.clearTable();
                    n7 = 511;
                    while ((n = this.readNextCode()) == 256) {
                    }
                    if ((n & 0xFFFFFF00) != 0) {
                        if (n == 257) break;
                        throw this.unexpectedData();
                    }
                    n6 = 1;
                    n5 = n << 2;
                    n2 = this.entriesForCodes[n];
                    assert (LZW.offsetAndLength(n5, 1) == n2) : n;
                    assert (Byte.toUnsignedInt(this.stringsFromCode[n5]) == n) : n;
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.put((byte)n);
                        break block29;
                    } else {
                        this.pendingOffset = n5;
                        this.pendingLength = n6;
                        break;
                    }
                }
                assert (n2 == this.entriesForCodes[n4]) : n4;
                assert (n5 == LZW.offset(n2)) : n5;
                assert (n6 == LZW.length(n2)) : n6;
                boolean bl = LZW.newEntryNeedsAllocation(n2);
                int n9 = bl ? this.indexOfFreeString : n5;
                int n10 = n9 + n6;
                if (bl) {
                    this.indexOfFreeString = n10 + (~n10 & 3) + 1;
                    assert ((this.indexOfFreeString & 3) == 0) : n6;
                    if (this.indexOfFreeString > this.stringsFromCode.length) {
                        n8 = Math.min(this.indexOfFreeString * 2, 0x200000);
                        if (this.indexOfFreeString >= n8) {
                            throw new IOException("Dictionary overflow");
                        }
                        this.stringsFromCode = Arrays.copyOf(this.stringsFromCode, n8);
                    }
                    System.arraycopy(this.stringsFromCode, n5, this.stringsFromCode, n9, n6);
                }
                this.entriesForCodes[n4] = n2 | Integer.MIN_VALUE;
                n8 = n6 + 1;
                int n11 = LZW.offsetAndLength(n9, n8);
                n2 = this.entriesForCodes[n];
                if (n2 != 0) {
                    n5 = LZW.offset(n2);
                    n6 = LZW.length(n2);
                } else {
                    n5 = n9;
                    n6 = n8;
                    n2 = n11;
                    n = this.indexOfFreeEntry;
                }
                assert (this.stringsFromCode[n9] == this.stringsFromCode[LZW.offset(this.entriesForCodes[n4])]) : n;
                this.stringsFromCode[n10] = this.stringsFromCode[n5];
                try {
                    this.entriesForCodes[this.indexOfFreeEntry] = n11;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw (IOException)this.unexpectedData().initCause(arrayIndexOutOfBoundsException);
                }
                if (++this.indexOfFreeEntry == n7) {
                    if (this.codeSize < 12) {
                        n7 = (1 << ++this.codeSize) - 1;
                    } else assert (this.indexOfFreeEntry == this.entriesForCodes.length) : this.indexOfFreeEntry;
                }
                int n12 = Math.min(n6, byteBuffer.remaining());
                byteBuffer.put(this.stringsFromCode, n5, n12);
                if (n12 != n6) {
                    this.pendingOffset = n5 + n12;
                    this.pendingLength = n6 - n12;
                    break;
                }
            }
            n4 = n;
        }
        this.previousCode = n;
        return byteBuffer.position() - n3;
    }

    private IOException unexpectedData() {
        return new IOException(this.resources().getString((short)31, this.input.filename, "LZW"));
    }
}

