/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.inflater;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.geotiff.Compression;
import org.apache.sis.internal.geotiff.Predictor;
import org.apache.sis.internal.geotiff.Resources;
import org.apache.sis.internal.storage.inflater.CCITTRLE;
import org.apache.sis.internal.storage.inflater.CompressionChannel;
import org.apache.sis.internal.storage.inflater.CopyFromBytes;
import org.apache.sis.internal.storage.inflater.HorizontalPredictor;
import org.apache.sis.internal.storage.inflater.LZW;
import org.apache.sis.internal.storage.inflater.PackBits;
import org.apache.sis.internal.storage.inflater.PixelChannel;
import org.apache.sis.internal.storage.inflater.ZIP;
import org.apache.sis.internal.storage.io.ChannelDataInput;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.storage.UnsupportedEncodingException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArgumentChecks;

public abstract class Inflater
implements Closeable {
    protected final ChannelDataInput input;
    protected final int chunksPerRow;
    protected final int elementsPerChunk;
    protected final int[] skipAfterChunks;

    protected Inflater(ChannelDataInput channelDataInput, int n, int n2, int[] nArray, int n3, int n4) {
        this.input = channelDataInput;
        ArgumentChecks.ensureStrictlyPositive((String)"chunksPerRow", (int)n);
        ArgumentChecks.ensureStrictlyPositive((String)"samplesPerChunk", (int)n2);
        ArgumentChecks.ensureStrictlyPositive((String)"pixelsPerElement", (int)n3);
        if (nArray != null) {
            if (n3 != 1) {
                nArray = (int[])nArray.clone();
                int n5 = 0;
                while (n5 < nArray.length) {
                    int n6 = nArray[n5];
                    ArgumentChecks.ensurePositive((String)"skipAfterChunks", (int)n6);
                    ArgumentChecks.ensureMultiple((String)"skipAfterChunks", (int)n3, (int)n6);
                    int n7 = n5++;
                    nArray[n7] = nArray[n7] / n3;
                }
            }
        } else {
            n2 = Math.multiplyExact(n2, n);
            n = 1;
            if (n2 > n4) {
                int[] nArray2 = MathFunctions.divisors((int)n2);
                int n8 = Arrays.binarySearch(nArray2, Numerics.ceilDiv((int)n2, (int)n4));
                if (n8 < 0) {
                    n8 ^= 0xFFFFFFFF;
                }
                while (n2 % ((n = nArray2[n8]) * n3) != 0 && ++n8 < nArray2.length) {
                }
                n2 /= n;
            }
        }
        if (n != 1) {
            ArgumentChecks.ensureDivisor((String)"pixelsPerElement", (int)n2, (int)n3);
        }
        this.elementsPerChunk = Numerics.ceilDiv((int)n2, (int)n3);
        this.skipAfterChunks = nArray;
        this.chunksPerRow = n;
    }

    public static Inflater create(StoreListeners storeListeners, ChannelDataInput channelDataInput, Compression compression, Predictor predictor, int n, int n2, int n3, int n4, int[] nArray, int n5, DataType dataType) throws IOException, UnsupportedEncodingException {
        PixelChannel pixelChannel;
        CompressionChannel compressionChannel;
        ArgumentChecks.ensureNonNull((String)"input", (Object)channelDataInput);
        switch (compression) {
            case LZW: {
                compressionChannel = new LZW(channelDataInput, storeListeners);
                break;
            }
            case DEFLATE: {
                compressionChannel = new ZIP(channelDataInput, storeListeners);
                break;
            }
            case PACKBITS: {
                compressionChannel = new PackBits(channelDataInput, storeListeners);
                break;
            }
            case CCITTRLE: {
                compressionChannel = new CCITTRLE(channelDataInput, storeListeners, n2);
                break;
            }
            case NONE: {
                if (predictor == Predictor.NONE) {
                    return CopyFromBytes.create(channelDataInput, dataType, n3, n4, nArray, n5);
                }
                throw Inflater.unsupportedEncoding(storeListeners, (short)30, predictor);
            }
            default: {
                throw Inflater.unsupportedEncoding(storeListeners, (short)27, compression);
            }
        }
        switch (predictor) {
            case NONE: {
                pixelChannel = compressionChannel;
                break;
            }
            case HORIZONTAL: {
                if (n2 == 1) {
                    pixelChannel = compressionChannel;
                    break;
                }
                if (n5 == 1 && (pixelChannel = HorizontalPredictor.create(compressionChannel, dataType, n, n2)) != null) break;
            }
            default: {
                throw Inflater.unsupportedEncoding(storeListeners, (short)30, predictor);
            }
        }
        int n6 = Math.multiplyExact(n2, n * dataType.bytes());
        return CopyFromBytes.create(compressionChannel.createDataInput(pixelChannel, n6), dataType, n3, n4, nArray, n5);
    }

    private static UnsupportedEncodingException unsupportedEncoding(StoreListeners storeListeners, short s, Enum<?> enum_) {
        return new UnsupportedEncodingException(Resources.forLocale(storeListeners.getLocale()).getString(s, enum_));
    }

    public void setInputOutput(long l, long l2, Buffer buffer) throws IOException {
        if (this.input.channel instanceof PixelChannel) {
            ((PixelChannel)this.input.channel).setInputRegion(l, l2);
            this.input.buffer.limit(0);
            this.input.setStreamPosition(l);
        }
    }

    public abstract void skip(long var1) throws IOException;

    public abstract void uncompressRow() throws IOException;

    @Override
    public final void close() throws IOException {
        if (this.input.channel instanceof PixelChannel) {
            this.input.channel.close();
        }
    }
}

