/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.earth.netcdf;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import org.apache.sis.coverage.Category;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.netcdf.AttributeNames;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

public final class GCOM_C
extends Convention {
    private static final Pattern SENTINEL_VALUE = Pattern.compile(".*\\bGCOM-C\\b.*");
    private static final String QA_FLAG = "QA_flag";
    private static final Map<String, String> ATTRIBUTES;
    private static final String GEOMETRY_DATA = "Geometry_data";
    private static final String[] NO_DATA;
    private static final String MINIMUM = "Minimum_valid_DN";
    private static final String MAXIMUM = "Maximum_valid_DN";
    private static final String SUFFIX = "_DN";
    private static final int MISSING_NODATA = 65534;
    private static final String[] CORNERS;

    @Override
    protected boolean isApplicableTo(Decoder decoder) {
        String[] stringArray = decoder.getSearchPath();
        decoder.setSearchPath("Global_attributes");
        String string = decoder.stringValue("Satellite");
        decoder.setSearchPath(stringArray);
        return string != null && SENTINEL_VALUE.matcher(string).matches();
    }

    @Override
    public String[] getSearchPath() {
        return new String[]{"Global_attributes", null, "Processing_attributes"};
    }

    @Override
    public String mapAttributeName(String string, int n) {
        switch (n) {
            case 0: {
                return string;
            }
            case 1: {
                return ATTRIBUTES.get(string);
            }
            case 2: {
                if (AttributeNames.TIME.MINIMUM.equalsIgnoreCase(string)) {
                    return "Image_start_time";
                }
                if (!AttributeNames.TIME.MAXIMUM.equalsIgnoreCase(string)) break;
                return "Image_end_time";
            }
        }
        return null;
    }

    @Override
    public VariableRole roleOf(Variable variable) {
        VariableRole variableRole = super.roleOf(variable);
        if (variableRole == VariableRole.COVERAGE) {
            String string = variable.getGroupName();
            if (GEOMETRY_DATA.equalsIgnoreCase(string)) {
                return VariableRole.OTHER;
            }
            if (QA_FLAG.equals(variable.getName())) {
                return VariableRole.DISCRETE_COVERAGE;
            }
        }
        return variableRole;
    }

    @Override
    public String nameOfDimension(Variable variable, int n) {
        String string = super.nameOfDimension(variable, n);
        if (string == null) {
            if (QA_FLAG.equals(variable.getName()) && variable.getAttributeType("Spatial_resolution") != null) {
                switch (n) {
                    case 0: {
                        string = "Line grids";
                        break;
                    }
                    case 1: {
                        string = "Pixel grids";
                    }
                }
            }
        } else if ("Piexl grids".equalsIgnoreCase(string)) {
            string = "Pixel grids";
        }
        return string;
    }

    @Override
    public Set<Linearizer> linearizers(Decoder decoder) {
        return Collections.singleton(new Linearizer(CommonCRS.WGS84, Linearizer.Type.UNIVERSAL));
    }

    @Override
    public Set<String> nameOfMappingNode(Variable variable) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(4);
        linkedHashSet.add(GEOMETRY_DATA);
        linkedHashSet.addAll(super.nameOfMappingNode(variable));
        return linkedHashSet;
    }

    @Override
    public Map<String, Object> projection(Node node) {
        String string;
        String string2;
        String string3 = node.getAttributeAsString("Image_projection");
        if (string3 == null) {
            return super.projection(node);
        }
        int n = string3.indexOf(32);
        String string4 = string2 = n >= 0 ? string3.substring(0, n) : string3;
        if (string2.equalsIgnoreCase("EQA")) {
            string = "Pseudo sinusoidal";
        } else if (string2.equalsIgnoreCase("EQR")) {
            string = "Equidistant Cylindrical (Spherical)";
        } else if (string2.equalsIgnoreCase("PS")) {
            string = "Polar Stereographic (variant A)";
        } else {
            return super.projection(node);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("grid_mapping_name", string);
        hashMap.put("conversion_name", string3);
        return hashMap;
    }

    @Override
    public MathTransform gridToCRS(Node node, MathTransform mathTransform) throws TransformException {
        double[] dArray = new double[CORNERS.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = node.getAttributeAsDouble(CORNERS[i]);
        }
        mathTransform.transform(dArray, 0, dArray, 0, dArray.length / 2);
        double d = (dArray[2] - dArray[0] + (dArray[6] - dArray[4])) / 2.0;
        double d2 = (dArray[1] - dArray[5] + (dArray[3] - dArray[7])) / 2.0;
        if (Double.isFinite(d /= node.getAttributeAsDouble("Number_of_pixels") - 1.0) && Double.isFinite(d2 /= node.getAttributeAsDouble("Number_of_lines") - 1.0)) {
            Matrix3 matrix3 = new Matrix3();
            matrix3.m00 = d;
            matrix3.m11 = -d2;
            matrix3.m02 = dArray[0];
            matrix3.m12 = dArray[1];
            return MathTransforms.linear((Matrix)matrix3);
        }
        return super.gridToCRS(node, mathTransform);
    }

    @Override
    public CommonCRS defaultHorizontalCRS(boolean bl) {
        return CommonCRS.WGS84;
    }

    @Override
    public NumberRange<?> validRange(Variable variable) {
        NumberRange numberRange = super.validRange(variable);
        if (numberRange == null) {
            Number number = variable.getAttributeAsNumber(MINIMUM);
            Number number2 = variable.getAttributeAsNumber(MAXIMUM);
            if (number != null || number2 != null) {
                numberRange = NumberRange.createBestFit((Number)number, (boolean)true, (Number)number2, (boolean)true);
            }
        }
        return numberRange;
    }

    @Override
    public Map<Number, Object> nodataValues(Variable variable) {
        double d;
        boolean bl = true;
        Map<Number, Object> map = super.nodataValues(variable);
        for (int i = 0; i < NO_DATA.length; ++i) {
            Object object;
            String string = NO_DATA[i];
            Number number = variable.getAttributeAsNumber(string);
            if (number == null) continue;
            if (i != 0) {
                if (string.endsWith(SUFFIX)) {
                    string = string.substring(0, string.length() - SUFFIX.length());
                }
                object = string.replace('_', ' ');
            } else {
                object = 3;
            }
            if (map.putIfAbsent(number, object) != null || !bl) continue;
            bl = Math.floor(number.doubleValue()) > 65534.0;
        }
        if (bl && (d = variable.getAttributeAsDouble(MAXIMUM)) >= 256.0 && d < 65534.0) {
            int n = 3;
            for (int i = 65535; i >= 65534; --i) {
                map.putIfAbsent(i, n);
                n = 2;
            }
        }
        return map;
    }

    @Override
    public TransferFunction transferFunction(Variable variable) {
        TransferFunction transferFunction = super.transferFunction(variable);
        if (transferFunction.isIdentity()) {
            double d = variable.getAttributeAsDouble("Slope");
            double d2 = variable.getAttributeAsDouble("Offset");
            if (Double.isFinite(d)) {
                transferFunction.setScale(d);
            }
            if (Double.isFinite(d2)) {
                transferFunction.setOffset(d2);
            }
        }
        return transferFunction;
    }

    @Override
    public Unit<?> getUnitFallback(Variable variable) throws ParserException {
        String string;
        if ("Image_data".equals(variable.getGroupName()) && (string = variable.getAttributeAsString("Unit")) != null && !string.equalsIgnoreCase("NA")) {
            if (string.equalsIgnoreCase("degree")) {
                return Units.CELSIUS;
            }
            return Units.valueOf((String)string);
        }
        return super.getUnitFallback(variable);
    }

    @Override
    public Function<Category, Color[]> getColors(Variable variable) {
        if (QA_FLAG.equals(variable.getName())) {
            return category -> {
                NumberRange<?> numberRange = category.getSampleRange();
                if (Objects.equals(numberRange.getMinValue(), numberRange.getMaxValue())) {
                    return null;
                }
                return new Color[]{Color.BLUE, Color.CYAN, Color.YELLOW, Color.RED};
            };
        }
        return super.getColors(variable);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("title", "Product_name");
        hashMap.put("product_version", "Product_version");
        hashMap.put(AttributeNames.IDENTIFIER.TEXT, "Product_file_name");
        hashMap.put("date_created", "Processing_UT");
        hashMap.put(AttributeNames.CREATOR.INSTITUTION, "Processing_organization");
        hashMap.put("summary", "Dataset_description");
        hashMap.put(AttributeNames.PLATFORM.TEXT, "Satellite");
        hashMap.put(AttributeNames.INSTRUMENT.TEXT, "Sensor");
        hashMap.put("processing_level", "Product_level");
        hashMap.put("source", "Input_files");
        hashMap.put(AttributeNames.TIME.MINIMUM, "Scene_start_time");
        hashMap.put(AttributeNames.TIME.MAXIMUM, "Scene_end_time");
        ATTRIBUTES = hashMap;
        NO_DATA = new String[]{"Error_DN", "Retrieval_error_DN", "Cloud_error_DN", "Land_DN"};
        CORNERS = new String[]{"Upper_left_latitude", "Upper_left_longitude", "Upper_right_latitude", "Upper_right_longitude", "Lower_left_latitude", "Lower_left_longitude", "Lower_right_latitude", "Lower_right_longitude"};
    }
}

