/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.filter.sqlmm;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.filter.sqlmm.SpatialFunction;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

abstract class FunctionWithSRID<R>
extends SpatialFunction<R> {
    private static final long serialVersionUID = -6870024245928121613L;
    final Expression<? super R, ?> srid;
    private transient Object lastSRID;
    private transient CoordinateReferenceSystem targetCRS;
    final boolean literalCRS;
    static final int PRESENT = 1;
    static final int ABSENT = 0;
    static final int MAYBE = 2;

    FunctionWithSRID(SQLMM sQLMM, Expression<? super R, ?>[] expressionArray, int n) {
        super(sQLMM, expressionArray);
        if (n == 2 && expressionArray.length < sQLMM.maxParamCount) {
            n = 0;
        }
        if (n == 0) {
            this.literalCRS = true;
            this.srid = null;
            return;
        }
        this.srid = expressionArray[sQLMM.maxParamCount - 1];
        if (this.srid instanceof Literal) {
            Object v = ((Literal)this.srid).getValue();
            if (v == null) {
                this.literalCRS = true;
            } else {
                boolean bl = this.literalCRS = n == 1 || FunctionWithSRID.isCRS(v.getClass());
                if (this.literalCRS) {
                    try {
                        this.setTargetCRS(v);
                    }
                    catch (FactoryException factoryException) {
                        throw new IllegalArgumentException(factoryException);
                    }
                }
            }
        } else {
            this.literalCRS = false;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.literalCRS && this.srid != null) {
            try {
                this.setTargetCRS(((Literal)this.srid).getValue());
            }
            catch (FactoryException factoryException) {
                throw (IOException)new InvalidObjectException(factoryException.getLocalizedMessage()).initCause(factoryException);
            }
        }
    }

    private static boolean isCRS(Class<?> clazz) {
        return clazz == Integer.class || clazz == String.class || CoordinateReferenceSystem.class.isAssignableFrom(clazz);
    }

    private void setTargetCRS(Object object) throws FactoryException {
        block1: {
            String string;
            block3: {
                block4: {
                    block5: {
                        block2: {
                            block0: {
                                if (!(object instanceof CoordinateReferenceSystem)) break block0;
                                this.targetCRS = (CoordinateReferenceSystem)object;
                                break block1;
                            }
                            if (!(object instanceof String)) break block2;
                            string = (String)object;
                            break block3;
                        }
                        if (!(object instanceof Integer)) break block4;
                        if ((Integer)object != 0) break block5;
                        this.targetCRS = null;
                        break block1;
                    }
                    string = "EPSG:" + object;
                    break block3;
                }
                throw new InvalidGeodeticParameterException(object == null ? Errors.format((short)157) : Errors.format((short)47, object.getClass()));
            }
            this.targetCRS = CRS.forCode((String)string);
        }
        this.lastSRID = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoordinateReferenceSystem getTargetCRS(R r) throws FactoryException {
        if (this.literalCRS) {
            return this.targetCRS;
        }
        Object obj = this.srid.apply(r);
        if (obj == null) {
            return null;
        }
        FunctionWithSRID functionWithSRID = this;
        synchronized (functionWithSRID) {
            if (!Objects.equals(obj, this.lastSRID)) {
                this.setTargetCRS(obj);
            }
            return this.targetCRS;
        }
    }

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        PropertyTypeBuilder propertyTypeBuilder = super.expectedType(defaultFeatureType, featureTypeBuilder);
        if (propertyTypeBuilder instanceof AttributeTypeBuilder) {
            ((AttributeTypeBuilder)propertyTypeBuilder).setCRS(this.literalCRS ? this.targetCRS : null);
        }
        return propertyTypeBuilder;
    }
}

