/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.geoapi.filter.DistanceOperatorName;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.referencing.ReferencingFactoryContainer;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.crs.DefaultProjectedCRS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class SpatialOperationContext
implements Serializable {
    private static final long serialVersionUID = -6197547343970700471L;
    private static final int BIDIMENSIONAL = 2;
    private final GeographicBoundingBox areaOfInterest;
    private final CoordinateReferenceSystem computationCRS;
    private final Unit<?> systemUnit;
    private final int skipIndex;
    CoordinateReferenceSystem commonCRS;

    public SpatialOperationContext(GeographicBoundingBox geographicBoundingBox, GeometryWrapper<?> geometryWrapper, Unit<?> unit, int n) throws FactoryException, TransformException, IncommensurableException {
        this.areaOfInterest = geographicBoundingBox;
        this.systemUnit = unit;
        this.skipIndex = n;
        if (geometryWrapper == null) {
            this.computationCRS = null;
        } else {
            try {
                CoordinateReferenceSystem coordinateReferenceSystem = SpatialOperationContext.to2D(geometryWrapper.getCoordinateReferenceSystem());
                if (unit != null && coordinateReferenceSystem != null) {
                    coordinateReferenceSystem = SpatialOperationContext.usingSystemUnit(geometryWrapper, coordinateReferenceSystem, coordinateReferenceSystem, unit);
                }
                this.computationCRS = coordinateReferenceSystem;
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(FactoryException.class);
            }
        }
    }

    private static CoordinateReferenceSystem to2D(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (ReferencingUtilities.getDimension((CoordinateReferenceSystem)coordinateReferenceSystem) > 2) {
            coordinateReferenceSystem = CRS.getComponentAt((CoordinateReferenceSystem)coordinateReferenceSystem, (int)0, (int)2);
        }
        return coordinateReferenceSystem;
    }

    public <G> GeometryWrapper<G> transform(GeometryWrapper<G> geometryWrapper) throws FactoryException, TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (this.computationCRS != null && (coordinateReferenceSystem = SpatialOperationContext.to2D(geometryWrapper.getCoordinateReferenceSystem())) != null && !Utilities.equalsIgnoreMetadata(this.computationCRS, coordinateReferenceSystem)) {
            geometryWrapper = geometryWrapper.transform(CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)this.computationCRS, (GeographicBoundingBox)this.areaOfInterest), false);
        }
        return geometryWrapper;
    }

    final <G> boolean transform(GeometryWrapper<G>[] geometryWrapperArray) throws FactoryException, TransformException, IncommensurableException {
        int n;
        CoordinateReferenceSystem[] coordinateReferenceSystemArray;
        block14: {
            coordinateReferenceSystemArray = new CoordinateReferenceSystem[geometryWrapperArray.length];
            try {
                n = coordinateReferenceSystemArray.length;
                while (--n >= 0) {
                    coordinateReferenceSystemArray[n] = n == this.skipIndex ? this.computationCRS : SpatialOperationContext.to2D(geometryWrapperArray[n].getCoordinateReferenceSystem());
                }
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(FactoryException.class);
            }
            n = coordinateReferenceSystemArray.length;
            do {
                if (--n >= 0) continue;
                return true;
            } while ((this.commonCRS = coordinateReferenceSystemArray[n]) == null);
            boolean bl = false;
            if (this.systemUnit != null && this.commonCRS != this.computationCRS) {
                bl = SpatialOperationContext.isCompatibleUnit(this.commonCRS, this.systemUnit);
            }
            if (!bl) {
                CoordinateReferenceSystem coordinateReferenceSystem;
                do {
                    if (--n >= 0) continue;
                    return true;
                } while ((coordinateReferenceSystem = coordinateReferenceSystemArray[n]) == null || Utilities.equalsIgnoreMetadata(this.commonCRS, coordinateReferenceSystem));
            }
            this.commonCRS = this.computationCRS;
            if (this.commonCRS == null) {
                if (this.systemUnit != null) {
                    n = coordinateReferenceSystemArray.length;
                    while (--n >= 0) {
                        this.commonCRS = coordinateReferenceSystemArray[n];
                        Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)this.commonCRS);
                        if (unit == null || !this.systemUnit.equals((Object)unit.getSystemUnit())) continue;
                        break block14;
                    }
                }
                this.commonCRS = CRS.suggestCommonTarget((GeographicBoundingBox)this.areaOfInterest, (CoordinateReferenceSystem[])coordinateReferenceSystemArray);
                if (this.commonCRS == null) {
                    return false;
                }
                if (this.systemUnit != null) {
                    n = coordinateReferenceSystemArray.length;
                    while (--n >= 0) {
                        CoordinateReferenceSystem coordinateReferenceSystem = coordinateReferenceSystemArray[n];
                        if (coordinateReferenceSystem == null) continue;
                        this.commonCRS = SpatialOperationContext.usingSystemUnit(geometryWrapperArray[n], coordinateReferenceSystem, this.commonCRS, this.systemUnit);
                        break block14;
                    }
                    return false;
                }
            }
        }
        for (n = 0; n < coordinateReferenceSystemArray.length; ++n) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            if (n == this.skipIndex || Utilities.equalsIgnoreMetadata(this.commonCRS, coordinateReferenceSystem = coordinateReferenceSystemArray[n])) continue;
            geometryWrapperArray[n] = geometryWrapperArray[n].transform(CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)this.commonCRS, (GeographicBoundingBox)this.areaOfInterest), false);
        }
        return true;
    }

    private static boolean isCompatibleUnit(CoordinateReferenceSystem coordinateReferenceSystem, Unit<?> unit) {
        Unit unit2 = ReferencingUtilities.getUnit((CoordinateReferenceSystem)coordinateReferenceSystem);
        return unit2 != null && unit.equals((Object)unit2.getSystemUnit());
    }

    private static CoordinateReferenceSystem usingSystemUnit(GeometryWrapper<?> geometryWrapper, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, Unit<?> unit) throws FactoryException, TransformException, IncommensurableException {
        while (!SpatialOperationContext.isCompatibleUnit(coordinateReferenceSystem2, unit)) {
            if (Units.isLinear(unit) && coordinateReferenceSystem2 instanceof GeographicCRS) {
                return Projector.instance().create((GeographicCRS)coordinateReferenceSystem2, geometryWrapper.getCentroid(), coordinateReferenceSystem);
            }
            if (coordinateReferenceSystem2 instanceof GeneralDerivedCRS) {
                coordinateReferenceSystem2 = ((GeneralDerivedCRS)coordinateReferenceSystem2).getBaseCRS();
                continue;
            }
            throw new IncommensurableException(Errors.format((short)70, unit));
        }
        return coordinateReferenceSystem2;
    }

    public static boolean negativeResult(SpatialOperatorName spatialOperatorName) {
        return spatialOperatorName == SpatialOperatorName.DISJOINT;
    }

    public static boolean negativeResult(DistanceOperatorName distanceOperatorName) {
        return distanceOperatorName == DistanceOperatorName.BEYOND;
    }

    private static final class Projector {
        private static final boolean CONTINUOUS_WRAPAROUND = false;
        private final Map<String, ?> name;
        private final OperationMethod method;
        private final CartesianCS cartCS;
        private static final Projector INSTANCE;

        private Projector() throws FactoryException {
            ReferencingFactoryContainer referencingFactoryContainer = new ReferencingFactoryContainer();
            this.method = referencingFactoryContainer.getCoordinateOperationFactory().getOperationMethod("Mercator_2SP");
            this.cartCS = referencingFactoryContainer.getStandardProjectedCS();
            this.name = Collections.singletonMap("name", new ImmutableIdentifier(Citations.SIS, "SIS", "Mercator for geometry"));
        }

        ProjectedCRS create(GeographicCRS geographicCRS, DirectPosition directPosition, CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, TransformException, IncommensurableException {
            CoordinateSystemAxis coordinateSystemAxis;
            GeneralDerivedCRS generalDerivedCRS;
            while (coordinateReferenceSystem instanceof GeneralDerivedCRS) {
                generalDerivedCRS = (GeneralDerivedCRS)coordinateReferenceSystem;
                directPosition = generalDerivedCRS.getConversionFromBase().getMathTransform().inverse().transform(directPosition, directPosition);
                coordinateReferenceSystem = generalDerivedCRS.getBaseCRS();
            }
            if (!(coordinateReferenceSystem instanceof GeographicCRS)) {
                throw new FactoryException(Errors.format((short)47, ReferencingUtilities.getInterface(CoordinateReferenceSystem.class, (IdentifiedObject)coordinateReferenceSystem)));
            }
            generalDerivedCRS = coordinateReferenceSystem.getCoordinateSystem();
            double d = Double.NaN;
            double d2 = Double.NaN;
            for (int i = 0; i < 2; ++i) {
                coordinateSystemAxis = generalDerivedCRS.getAxis(i);
                double d3 = directPosition.getOrdinate(i);
                d3 = coordinateSystemAxis.getUnit().getConverterToAny(Units.DEGREE).convert(d3);
                AxisDirection axisDirection = coordinateSystemAxis.getDirection();
                if (axisDirection == AxisDirection.NORTH) {
                    d = d3;
                    continue;
                }
                if (axisDirection == AxisDirection.EAST) {
                    d2 = d3;
                    continue;
                }
                if (axisDirection == AxisDirection.WEST) {
                    d2 = -d3;
                    continue;
                }
                if (axisDirection == AxisDirection.SOUTH) {
                    d = -d3;
                    continue;
                }
                throw new FactoryException(Errors.format((short)177, axisDirection));
            }
            ParameterValueGroup parameterValueGroup = this.method.getParameters().createValue();
            parameterValueGroup.parameter("standard_parallel_1").setValue(d);
            coordinateSystemAxis = new DefaultConversion(this.name, this.method, null, parameterValueGroup);
            return new DefaultProjectedCRS(this.name, geographicCRS, (Conversion)coordinateSystemAxis, this.cartCS);
        }

        static Projector instance() throws FactoryException {
            return INSTANCE != null ? INSTANCE : new Projector();
        }

        static {
            Projector projector;
            try {
                projector = new Projector();
            }
            catch (FactoryException factoryException) {
                projector = null;
            }
            INSTANCE = projector;
        }
    }
}

