/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Optional;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.GeometryFactories;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.math.Vector;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public abstract class Geometries<G>
implements Serializable {
    private static final long serialVersionUID = 1856503921463395122L;
    public static final int BIDIMENSIONAL = 2;
    public static final int TRIDIMENSIONAL = 3;
    public final GeometryLibrary library;
    public final transient Class<G> rootClass;
    public final transient Class<?> pointClass;
    public final transient Class<? extends G> polylineClass;
    public final transient Class<? extends G> polygonClass;
    transient Geometries<?> fallback;
    private final transient boolean isPointClassDistinct;

    protected Geometries(GeometryLibrary geometryLibrary, Class<G> clazz, Class<?> clazz2, Class<? extends G> clazz3, Class<? extends G> clazz4) {
        this.library = geometryLibrary;
        this.rootClass = clazz;
        this.pointClass = clazz2;
        this.polylineClass = clazz3;
        this.polygonClass = clazz4;
        this.isPointClassDistinct = !clazz.isAssignableFrom(clazz2);
    }

    public static Geometries<?> implementation(GeometryLibrary geometryLibrary) {
        Geometries<?> geometries = GeometryFactories.implementation;
        if (geometryLibrary == null) {
            return geometries;
        }
        while (geometries != null) {
            if (geometries.library == geometryLibrary) {
                return geometries;
            }
            geometries = geometries.fallback;
        }
        throw new IllegalArgumentException(Resources.format((short)64, (Object)geometryLibrary));
    }

    public static Geometries<?> implementation(Class<?> clazz) {
        Geometries<?> geometries = GeometryFactories.implementation;
        while (geometries != null) {
            if (super.isSupportedType(clazz)) {
                return geometries;
            }
            geometries = geometries.fallback;
        }
        return null;
    }

    public static boolean isKnownType(Class<?> clazz) {
        Geometries<?> geometries = GeometryFactories.implementation;
        while (geometries != null) {
            if (super.isSupportedType(clazz)) {
                return true;
            }
            geometries = geometries.fallback;
        }
        return GeometryWrapper.class.isAssignableFrom(clazz);
    }

    private boolean isSupportedType(Class<?> clazz) {
        return this.rootClass.isAssignableFrom(clazz) || this.isPointClassDistinct && this.pointClass.isAssignableFrom(clazz);
    }

    public Class<?> getGeometryClass(GeometryType geometryType) {
        switch (geometryType) {
            default: {
                return this.rootClass;
            }
            case POINT: {
                return this.pointClass;
            }
            case LINESTRING: {
                return this.polylineClass;
            }
            case POLYGON: 
        }
        return this.polygonClass;
    }

    public static Optional<GeometryWrapper<?>> wrap(Object object) {
        if (object != null) {
            if (object instanceof GeometryWrapper) {
                return Optional.of((GeometryWrapper)object);
            }
            Geometries<?> geometries = GeometryFactories.implementation;
            while (geometries != null) {
                if (super.isSupportedType(object.getClass())) {
                    return Optional.of(geometries.castOrWrap(object));
                }
                geometries = geometries.fallback;
            }
        }
        return Optional.empty();
    }

    public abstract GeometryWrapper<G> castOrWrap(Object var1);

    protected static Object unwrap(Object object) {
        return object instanceof GeometryWrapper ? ((GeometryWrapper)object).implementation() : object;
    }

    public abstract GeometryWrapper<G> parseWKT(String var1) throws Exception;

    public abstract GeometryWrapper<G> parseWKB(ByteBuffer var1) throws Exception;

    public final GeometryWrapper<G> createPoint(DirectPosition directPosition) {
        Object object;
        int n = directPosition.getDimension();
        switch (n) {
            case 2: {
                object = this.createPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1));
                break;
            }
            case 3: {
                object = this.createPoint(directPosition.getOrdinate(0), directPosition.getOrdinate(1), directPosition.getOrdinate(2));
                break;
            }
            default: {
                throw new MismatchedDimensionException(Errors.format((short)81, "point", n <= 2 ? 2 : 3, n));
            }
        }
        GeometryWrapper<G> geometryWrapper = this.castOrWrap(object);
        if (directPosition.getCoordinateReferenceSystem() != null) {
            geometryWrapper.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
        }
        return geometryWrapper;
    }

    public boolean supportSinglePrecision() {
        return false;
    }

    public Object createPoint(float f, float f2) {
        return this.createPoint((double)f, (double)f2);
    }

    public abstract Object createPoint(double var1, double var3);

    public abstract Object createPoint(double var1, double var3, double var5);

    public abstract G createPolyline(boolean var1, int var2, Vector ... var3);

    public abstract GeometryWrapper<G> createMultiPolygon(Object[] var1);

    public abstract GeometryWrapper<G> createFromComponents(GeometryType var1, Object var2);

    private GeometryWrapper<G> createGeometry2D(Envelope envelope, int n, int n2, boolean bl, boolean bl2) {
        DirectPosition directPosition;
        Object object;
        double d;
        double d2;
        double d3;
        double d4;
        if (bl) {
            d4 = envelope.getMinimum(n);
            d3 = envelope.getMinimum(n2);
            d2 = envelope.getMaximum(n);
            d = envelope.getMaximum(n2);
        } else {
            object = envelope.getLowerCorner();
            directPosition = envelope.getUpperCorner();
            d4 = object.getOrdinate(n);
            d3 = object.getOrdinate(n2);
            d2 = directPosition.getOrdinate(n);
            d = directPosition.getOrdinate(n2);
        }
        if (bl2 && (directPosition = envelope.getCoordinateReferenceSystem()) != null) {
            boolean bl3;
            boolean bl4;
            boolean bl5;
            int n3 = 10;
            CoordinateSystem coordinateSystem = directPosition.getCoordinateSystem();
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(n);
            double d5 = coordinateSystemAxis.getMinimumValue();
            double d6 = coordinateSystemAxis.getMaximumValue();
            coordinateSystemAxis = coordinateSystem.getAxis(n2);
            double d7 = coordinateSystemAxis.getMinimumValue();
            double d8 = coordinateSystemAxis.getMaximumValue();
            boolean bl6 = d4 <= d2;
            boolean bl7 = d3 <= d;
            boolean bl8 = bl6 && d5 > d4;
            if (bl8) {
                n3 += 4;
            }
            if (bl5 = bl7 && d7 > d3) {
                n3 += 4;
            }
            if (bl4 = bl6 && d6 < d2) {
                n3 += 4;
            }
            if (bl3 = bl7 && d8 < d) {
                n3 += 4;
            }
            int n4 = 0;
            object = new double[n3];
            object[n4++] = (DirectPosition)d4;
            object[n4++] = (DirectPosition)d3;
            if (bl5) {
                object[n4++] = (DirectPosition)d4;
                object[n4++] = (DirectPosition)d7;
            }
            if (bl3) {
                object[n4++] = (DirectPosition)d4;
                object[n4++] = (DirectPosition)d8;
            }
            object[n4++] = (DirectPosition)d4;
            object[n4++] = (DirectPosition)d;
            if (bl8) {
                object[n4++] = (DirectPosition)d5;
                object[n4++] = (DirectPosition)d;
            }
            if (bl4) {
                object[n4++] = (DirectPosition)d6;
                object[n4++] = (DirectPosition)d;
            }
            object[n4++] = (DirectPosition)d2;
            object[n4++] = (DirectPosition)d;
            if (bl3) {
                object[n4++] = (DirectPosition)d2;
                object[n4++] = (DirectPosition)d8;
            }
            if (bl5) {
                object[n4++] = (DirectPosition)d2;
                object[n4++] = (DirectPosition)d7;
            }
            object[n4++] = (DirectPosition)d2;
            object[n4++] = (DirectPosition)d3;
            if (bl4) {
                object[n4++] = (DirectPosition)d6;
                object[n4++] = (DirectPosition)d3;
            }
            if (bl8) {
                object[n4++] = (DirectPosition)d5;
                object[n4++] = (DirectPosition)d3;
            }
            object[n4++] = (DirectPosition)d4;
            object[n4++] = (DirectPosition)d3;
            assert (n4 == n3) : n4;
        } else {
            object = new double[]{d4, d3, d4, d, d2, d, d2, d3, d4, d3};
        }
        return this.createWrapper(this.createPolyline(true, 2, Vector.create((double[])object)));
    }

    public GeometryWrapper<G> toGeometry2D(Envelope envelope, WraparoundMethod wraparoundMethod) {
        CoordinateSystem coordinateSystem;
        GeneralEnvelope generalEnvelope;
        Object object;
        int n = 0;
        int n2 = 1;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        int n3 = envelope.getDimension();
        if (n3 != 2) {
            if (n3 < 2) {
                throw new IllegalArgumentException(Errors.format((short)31));
            }
            object = coordinateReferenceSystem;
            if ((coordinateReferenceSystem = CRS.getHorizontalComponent((CoordinateReferenceSystem)object)) == null) {
                coordinateReferenceSystem = CRS.getComponentAt((CoordinateReferenceSystem)object, (int)0, (int)2);
            } else if (coordinateReferenceSystem != object && (n = AxisDirections.indexOfColinear((CoordinateSystem)(generalEnvelope = object.getCoordinateSystem()), (AxisDirection)(coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()).getAxis(0).getDirection())) == (n2 = AxisDirections.indexOfColinear((CoordinateSystem)generalEnvelope, (AxisDirection)coordinateSystem.getAxis(1).getDirection()))) {
                ++n2;
            }
        }
        switch (wraparoundMethod) {
            case NORMALIZE: {
                throw new IllegalArgumentException();
            }
            case NONE: {
                object = this.createGeometry2D(envelope, n, n2, false, false);
                break;
            }
            default: {
                generalEnvelope = new GeneralEnvelope(envelope);
                generalEnvelope.normalize();
                generalEnvelope.wraparound(wraparoundMethod);
                object = this.createGeometry2D((Envelope)generalEnvelope, n, n2, true, false);
                break;
            }
            case SPLIT: {
                generalEnvelope = AbstractEnvelope.castOrCopy((Envelope)envelope).toSimpleEnvelopes();
                if (((GeneralEnvelope)generalEnvelope).length == 1) {
                    object = this.createGeometry2D((Envelope)generalEnvelope[0], n, n2, true, false);
                    break;
                }
                coordinateSystem = new GeometryWrapper[((GeneralEnvelope)generalEnvelope).length];
                for (int i = 0; i < ((GeneralEnvelope)generalEnvelope).length; ++i) {
                    coordinateSystem[i] = this.createGeometry2D((Envelope)generalEnvelope[i], n, n2, true, false);
                    coordinateSystem[i].setCoordinateReferenceSystem(coordinateReferenceSystem);
                }
                object = this.createMultiPolygon((Object[])coordinateSystem);
                break;
            }
        }
        ((GeometryWrapper)object).setCoordinateReferenceSystem(coordinateReferenceSystem);
        return object;
    }

    public static Object mergePolylines(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null) continue;
            Optional<GeometryWrapper<?>> optional = Geometries.wrap(obj);
            if (optional.isPresent()) {
                return optional.get().mergePolylines(iterator);
            }
            throw new ClassCastException(Errors.format((short)163, Classes.getClass(obj)));
        }
        return null;
    }

    protected abstract GeometryWrapper<G> createWrapper(G var1);

    protected static String unsupported(String string) {
        return Errors.format((short)162, string);
    }

    protected static String unsupported(int n) {
        return Resources.format((short)76, n);
    }
}

