/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.image.DataType;
import org.apache.sis.internal.coverage.j2d.ColorModelPatch;
import org.apache.sis.internal.coverage.j2d.ColorsForRange;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.MultiBandsIndexColorModel;
import org.apache.sis.internal.coverage.j2d.ScaledColorModel;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.collection.WeakValueHashMap;

public final class ColorModelFactory {
    public static final Color TRANSPARENT = new Color(0, true);
    private static final WeakHashSet<ColorModelPatch> CACHE = new WeakHashSet<ColorModelPatch>(ColorModelPatch.class);
    private static final Map<ColorModelFactory, ColorModel> PIECEWISES = new WeakValueHashMap<ColorModelFactory, ColorModel>(ColorModelFactory.class);
    private static final Comparator<ColorsForRange> RANGE_COMPARATOR = (colorsForRange, colorsForRange2) -> Double.compare(colorsForRange.sampleRange.getMinDouble(true), colorsForRange2.sampleRange.getMinDouble(true));
    private final int dataType;
    private final int numBands;
    private final int visibleBand;
    private final double minimum;
    private final double maximum;
    private final int[] pieceStarts;
    private final int[][] ARGB;

    private ColorModelFactory(int n, int n2, int n3, ColorsForRange[] colorsForRangeArray) {
        this.dataType = n;
        this.numBands = n2;
        this.visibleBand = n3;
        Arrays.sort(colorsForRangeArray, RANGE_COMPARATOR);
        int n4 = 0;
        int[] nArray = new int[colorsForRangeArray.length + 1];
        Object object = new int[colorsForRangeArray.length][];
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (ColorsForRange colorsForRange : colorsForRangeArray) {
            int n5;
            int n6;
            int n7;
            NumberRange<?> numberRange = colorsForRange.sampleRange;
            double d3 = numberRange.getMinDouble(true);
            double d4 = numberRange.getMaxDouble(false);
            if (d3 < d) {
                d = d3;
            }
            if (d4 > d2) {
                d2 = d4;
            }
            if ((n7 = Math.round((float)d3)) >= (n6 = Math.round((float)d4))) continue;
            if (n7 < 0 || n6 > 65536) {
                nArray = ArraysExt.EMPTY_INT;
                object = null;
                n4 = 0;
                continue;
            }
            if (object == null) continue;
            if (n4 != 0 && (n5 = nArray[n4]) != n7 && n5 <= n7) {
                object = (int[][])Arrays.copyOf(object, ((int[][])object).length + 1);
                nArray = Arrays.copyOf(nArray, nArray.length + 1);
                object[n4++] = ArraysExt.EMPTY_INT;
            }
            object[n4] = colorsForRange.toARGB();
            nArray[n4] = n7;
            nArray[++n4] = n6;
        }
        if (d >= d2) {
            d = 0.0;
            d2 = 1.0;
        }
        if (nArray.length != 0) {
            nArray = ArraysExt.resize(nArray, n4 + 1);
        }
        this.minimum = d;
        this.maximum = d2;
        this.pieceStarts = nArray;
        this.ARGB = object;
    }

    private ColorModel createColorModel() {
        int[] nArray;
        if (this.dataType != 0 && this.dataType != 1) {
            return ColorModelFactory.createGrayScale(this.dataType, this.numBands, this.visibleBand, this.minimum, this.maximum);
        }
        int n = this.pieceStarts.length - 1;
        if (this.numBands == 1 && n <= 0) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            int[] nArray2 = new int[]{DataBuffer.getDataTypeSize(this.dataType)};
            return ColorModelFactory.unique(new ComponentColorModel(colorSpace, nArray2, false, true, 1, this.dataType));
        }
        int n2 = -1;
        if (n <= 0) {
            nArray = ArraysExt.range(0, 256);
        } else {
            nArray = new int[this.pieceStarts[n]];
            for (int i = 0; i < n; ++i) {
                int[] nArray3 = this.ARGB[i];
                int n3 = this.pieceStarts[i];
                int n4 = this.pieceStarts[i + 1];
                if (n2 < 0 && nArray3.length == 0) {
                    n2 = n3;
                }
                ColorModelFactory.expand(nArray3, nArray, n3, n4);
            }
        }
        return ColorModelFactory.createIndexColorModel(this.numBands, this.visibleBand, nArray, true, n2);
    }

    public int hashCode() {
        int n = this.pieceStarts.length - 1;
        int n2 = 962745549 + (this.numBands * 31 + this.visibleBand) * 31 + n;
        for (int i = 0; i < n; ++i) {
            n2 += Arrays.hashCode(this.ARGB[i]);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ColorModelFactory) {
            ColorModelFactory colorModelFactory = (ColorModelFactory)object;
            return this.dataType == colorModelFactory.dataType && this.numBands == colorModelFactory.numBands && this.visibleBand == colorModelFactory.visibleBand && this.minimum == colorModelFactory.minimum && this.maximum == colorModelFactory.maximum && Arrays.equals(this.pieceStarts, colorModelFactory.pieceStarts) && Arrays.deepEquals((Object[])this.ARGB, (Object[])colorModelFactory.ARGB);
        }
        return false;
    }

    public static ColorModel createPiecewise(int n, int n2, int n3, Map<NumberRange<?>, Color[]> map) {
        return ColorModelFactory.createPiecewise(n, n2, n3, ColorsForRange.list(map.entrySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ColorModel createPiecewise(int n, int n2, int n3, ColorsForRange[] colorsForRangeArray) {
        ColorModelFactory colorModelFactory = new ColorModelFactory(n, n2, n3, colorsForRangeArray);
        Map<ColorModelFactory, ColorModel> map = PIECEWISES;
        synchronized (map) {
            return PIECEWISES.computeIfAbsent(colorModelFactory, ColorModelFactory::createColorModel);
        }
    }

    public static IndexColorModel createIndexColorModel(int n, int n2, int[] nArray, boolean bl, int n3) {
        int n4 = nArray.length;
        int n5 = ColorModelFactory.getBitCount(n4);
        int n6 = ColorModelFactory.getTransferType(n4);
        IndexColorModel indexColorModel = n == 1 ? new IndexColorModel(n5, n4, nArray, 0, bl, n3, n6) : new MultiBandsIndexColorModel(n5, n4, nArray, 0, bl, n3, n6, n, n2);
        return ColorModelFactory.unique(indexColorModel);
    }

    public static ColorModel createColorScale(int n, int n2, int n3, double d, double d2, Color ... colorArray) {
        return ColorModelFactory.createPiecewise(n, n2, n3, new ColorsForRange[]{new ColorsForRange(null, new NumberRange<Double>(Double.class, d, true, d2, false), colorArray, true)});
    }

    public static ColorModel createGrayScale(int n, int n2, int n3, double d, double d2) {
        ComponentColorModel componentColorModel;
        if (n2 == 1 && d > -1.0 && ColorModelFactory.isStandardRange(n, d, d2)) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            componentColorModel = new ComponentColorModel(colorSpace, false, true, 1, n);
        } else {
            ScaledColorSpace scaledColorSpace = new ScaledColorSpace(n2, n3, d, d2);
            componentColorModel = new ScaledColorModel(scaledColorSpace, n);
        }
        return ColorModelFactory.unique(componentColorModel);
    }

    static boolean isStandardRange(int n, double d, double d2) {
        double d3;
        boolean bl;
        switch (n) {
            case 0: 
            case 1: {
                bl = false;
                break;
            }
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        int n2 = DataBuffer.getDataTypeSize(n);
        if (bl) {
            d3 = 1L << n2 - 1;
            d += d3;
        } else {
            d3 = 1L << n2;
        }
        return Math.abs(d) < 1.0 && Math.abs(d2 - (d3 - 0.5)) < 1.5;
    }

    public static ColorModel createGrayScale(SampleModel sampleModel, int n, NumberRange<?> numberRange) {
        double d;
        double d2;
        if (numberRange != null) {
            d2 = numberRange.getMinDouble();
            d = numberRange.getMaxDouble();
        } else {
            d2 = 0.0;
            d = 1.0;
            if (ImageUtilities.isIntegerType(sampleModel)) {
                long l = Numerics.bitmask(sampleModel.getSampleSize(n)) - 1L;
                if (!ImageUtilities.isUnsignedType(sampleModel)) {
                    d2 = (l >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
                }
                d = l;
            }
        }
        return ColorModelFactory.createGrayScale(sampleModel.getDataType(), sampleModel.getNumBands(), n, d2, d);
    }

    public static ColorModel createRGB(SampleModel sampleModel) {
        int n = sampleModel.getNumBands();
        assert (n >= 3 && n <= 4) : n;
        assert (ImageUtilities.isIntegerType(sampleModel)) : sampleModel;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, sampleModel.getSampleSize(i));
        }
        return ColorModelFactory.createRGB(n2, sampleModel.getNumDataElements() == 1, n > 3);
    }

    public static ColorModel createRGB(int n, boolean bl, boolean bl2) {
        ColorModel colorModel;
        if (bl2 & bl && n == 8) {
            return ColorModel.getRGBdefault();
        }
        ArgumentChecks.ensureBetween("bitsPerSample", 1, 8, n);
        int n2 = (1 << n) - 1;
        if (bl) {
            colorModel = new DirectColorModel((bl2 ? 4 : 3) * n, n2 << n * 2, n2 << n, n2, bl2 ? n2 << n * 3 : 0);
        } else {
            int[] nArray = new int[bl2 ? 4 : 3];
            Arrays.fill(nArray, n);
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, bl2, false, bl2 ? 3 : 1, 0);
        }
        return ColorModelFactory.unique(colorModel);
    }

    public static Optional<ColorModel> createSubset(ColorModel colorModel, int[] nArray) {
        ColorModel colorModel2;
        assert (nArray != null && nArray.length > 0) : nArray;
        if (colorModel == null) {
            return Optional.empty();
        }
        if (colorModel instanceof MultiBandsIndexColorModel) {
            colorModel2 = ((MultiBandsIndexColorModel)colorModel).createSubsetColorModel(nArray);
        } else if (colorModel instanceof ScaledColorModel) {
            colorModel2 = ((ScaledColorModel)colorModel).createSubsetColorModel(nArray);
        } else if (nArray.length == 1 && colorModel instanceof ComponentColorModel) {
            int n = colorModel.getTransferType();
            if (n < 0 || n > 1) {
                return Optional.empty();
            }
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            colorModel2 = new ComponentColorModel(colorSpace, false, true, 1, n);
        } else {
            return Optional.empty();
        }
        return Optional.of(ColorModelFactory.unique(colorModel2));
    }

    public static void formatDescription(ColorSpace colorSpace, StringBuilder stringBuilder) {
        if (colorSpace != null) {
            if (colorSpace instanceof ScaledColorSpace) {
                ((ScaledColorSpace)colorSpace).formatRange(stringBuilder.append("showing "));
            } else if (colorSpace.getType() == 6) {
                stringBuilder.append("grayscale");
            }
        }
    }

    private static <T extends ColorModel> T unique(T t) {
        ColorModelPatch<T> colorModelPatch = new ColorModelPatch<T>(t);
        colorModelPatch = CACHE.unique(colorModelPatch);
        return colorModelPatch.cm;
    }

    private static int getTransferType(int n) {
        return n <= 256 ? 0 : 1;
    }

    public static int getBitCount(int n) {
        int n2 = 32 - Integer.numberOfLeadingZeros(n - 1);
        assert (1 << n2 >= n) : n;
        assert (1 << n2 - 1 < n) : n;
        return Math.max(1, n2);
    }

    public static void expand(int[] nArray, int[] nArray2, int n, int n2) {
        switch (nArray.length) {
            case 1: {
                Arrays.fill(nArray2, n, n2, nArray[0]);
            }
            case 0: {
                return;
            }
        }
        switch (n2 - n) {
            case 1: {
                nArray2[n] = nArray[0];
            }
            case 0: {
                return;
            }
        }
        double d = (double)(nArray.length - 1) / (double)(n2 - n - 1);
        int n3 = nArray.length - 2;
        float f = 0.0f;
        int n4 = 0;
        int n5 = n;
        while (true) {
            int n6 = nArray[n4];
            int n7 = nArray[n4 + 1];
            int n8 = n6 >>> 24 & 0xFF;
            int n9 = (n7 >>> 24 & 0xFF) - n8;
            int n10 = n6 >>> 16 & 0xFF;
            int n11 = (n7 >>> 16 & 0xFF) - n10;
            int n12 = n6 >>> 8 & 0xFF;
            int n13 = (n7 >>> 8 & 0xFF) - n12;
            int n14 = n6 & 0xFF;
            int n15 = (n7 & 0xFF) - n14;
            int n16 = n4;
            do {
                float f2 = f - (float)n4;
                nArray2[n5] = ColorModelFactory.roundByte((float)n8 + f2 * (float)n9) << 24 | ColorModelFactory.roundByte((float)n10 + f2 * (float)n11) << 16 | ColorModelFactory.roundByte((float)n12 + f2 * (float)n13) << 8 | ColorModelFactory.roundByte((float)n14 + f2 * (float)n15);
                if (++n5 != n2) continue;
                return;
            } while ((n4 = Math.min(n3, (int)((f = (float)((double)(n5 - n) * d)) + Math.ulp(f)))) == n16);
        }
    }

    private static int roundByte(float f) {
        return Math.min(Math.max(Math.round(f), 0), 255);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Strings.toString(this.getClass(), new Object[]{"dataType", DataType.forDataBufferType(this.dataType), "numBands", this.numBands, "visibleBand", this.visibleBand, "range", NumberRange.create(this.minimum, true, this.maximum, false)}));
        int n2 = this.pieceStarts != null ? this.pieceStarts.length : 0;
        for (int i = 0; i < n2; ++i) {
            String string = Integer.toString(this.pieceStarts[i]);
            stringBuilder.append(System.lineSeparator()).append(CharSequences.spaces(9 - string.length())).append(string);
            if (i >= this.ARGB.length) continue;
            stringBuilder.append('\u2026');
            int[] nArray = this.ARGB[i];
            if (nArray == null) continue;
            ColorsForRange.appendColorRange(stringBuilder, nArray.length, n -> nArray[n]);
        }
        return stringBuilder.toString();
    }
}

