/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage;

import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.ImageRenderer;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.ImageCombiner;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class CoverageCombiner {
    private static final int BIDIMENSIONAL = 2;
    private final ImageProcessor processor;
    private final GridCoverage destination;
    private final int xdim;
    private final int ydim;

    public CoverageCombiner(GridCoverage gridCoverage, int n, int n2) {
        ArgumentChecks.ensureNonNull("destination", gridCoverage);
        this.destination = gridCoverage;
        int n3 = gridCoverage.getGridGeometry().getDimension();
        ArgumentChecks.ensureBetween("xdim", 0, n3 - 1, n);
        ArgumentChecks.ensureBetween("ydim", 0, n3 - 1, n2);
        if (n == n2) {
            throw new IllegalArgumentException(Errors.format((short)187, n));
        }
        this.xdim = n;
        this.ydim = n2;
        this.processor = new ImageProcessor();
    }

    public Interpolation getInterpolation() {
        return this.processor.getInterpolation();
    }

    public void setInterpolation(Interpolation interpolation) {
        this.processor.setInterpolation(interpolation);
    }

    private static GridGeometry getGridGeometry(RenderedImage renderedImage, GridCoverage gridCoverage, GridExtent gridExtent) {
        Object object = renderedImage.getProperty("org.apache.sis.GridGeometry");
        if (object instanceof GridGeometry) {
            return (GridGeometry)object;
        }
        return new ImageRenderer(gridCoverage, gridExtent).getImageGeometry(2);
    }

    public boolean apply(GridCoverage ... gridCoverageArray) throws TransformException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        ArgumentChecks.ensureNonNull("sources", gridCoverageArray);
        gridCoverageArray = (GridCoverage[])gridCoverageArray.clone();
        GridGeometry gridGeometry = this.destination.getGridGeometry();
        GridExtent gridExtent = gridGeometry.getExtent();
        int n = gridExtent.getDimension();
        long[] lArray = new long[n];
        Arrays.fill(lArray, Long.MAX_VALUE);
        long[] lArray2 = new long[n];
        Arrays.fill(lArray2, Long.MIN_VALUE);
        MathTransform[] mathTransformArray = new MathTransform[gridCoverageArray.length];
        MathTransform[] mathTransformArray2 = new MathTransform[gridCoverageArray.length];
        block0: for (int i = 0; i < gridCoverageArray.length; ++i) {
            int n2;
            object4 = gridCoverageArray[i];
            ArgumentChecks.ensureNonNullElement("sources", i, object4);
            object3 = ((GridCoverage)object4).getGridGeometry();
            serializable = ((GridGeometry)object3).getExtent();
            MathTransform mathTransform = gridGeometry.createTransformTo((GridGeometry)object3, PixelInCell.CELL_CORNER);
            object2 = serializable.toEnvelope(mathTransform.inverse());
            object = new long[n];
            long[] lArray3 = new long[n];
            for (n2 = 0; n2 < n; ++n2) {
                object[n2] = Math.max(gridExtent.getLow(n2), Math.round(object2.getMinimum(n2)));
                lArray3[n2] = Math.min(gridExtent.getHigh(n2), Math.round(object2.getMaximum(n2) - 1.0));
                if (object[n2] <= lArray3[n2]) continue;
                gridCoverageArray[i] = null;
                continue block0;
            }
            for (n2 = 0; n2 < n; ++n2) {
                lArray[n2] = Math.min(lArray[n2], object[n2]);
                lArray2[n2] = Math.max(lArray2[n2], lArray3[n2]);
            }
            mathTransformArray2[i] = gridGeometry.createTransformTo((GridGeometry)object3, PixelInCell.CELL_CENTER);
            mathTransformArray[i] = mathTransform;
        }
        if (ArraysExt.allEquals(gridCoverageArray, null)) {
            return true;
        }
        long[] lArray4 = (long[])lArray.clone();
        object4 = (long[])lArray2.clone();
        object3 = gridExtent.getPointOfInterest(PixelInCell.CELL_CENTER);
        serializable = this.processor.getInterpolation().getSupportSize();
        ((Dimension)serializable).width = (((Dimension)serializable).width + 1 >> 1) + 1;
        ((Dimension)serializable).height = (((Dimension)serializable).height + 1 >> 1) + 1;
        boolean bl = true;
        block3: while (true) {
            int n3;
            if ((object = (Object)this.destination.render((GridExtent)(object2 = new GridExtent(null, lArray4, (long[])object4, true)))) instanceof WritableRenderedImage) {
                ImageCombiner imageCombiner = new ImageCombiner((WritableRenderedImage)object, this.processor);
                for (int i = 0; i < gridCoverageArray.length; ++i) {
                    GridCoverage gridCoverage = gridCoverageArray[i];
                    if (gridCoverage == null) continue;
                    n3 = gridCoverage.getGridGeometry().getDimension();
                    long[] lArray5 = new long[n3];
                    long[] lArray6 = new long[n3];
                    double[] dArray = new double[n3];
                    mathTransformArray2[i].transform((double[])object3, 0, dArray, 0, 1);
                    GeneralEnvelope generalEnvelope = ((GridExtent)object2).toEnvelope(mathTransformArray[i]);
                    for (int j = 0; j < n3; ++j) {
                        if (j == this.xdim || j == this.ydim) {
                            int n4 = j == this.xdim ? ((Dimension)serializable).width : ((Dimension)serializable).height;
                            lArray5[j] = Numerics.saturatingSubtract(Math.round(generalEnvelope.getMinimum(j)), n4);
                            lArray6[j] = Numerics.saturatingAdd(Math.round(generalEnvelope.getMaximum(j)), n4 - 1);
                            continue;
                        }
                        lArray5[j] = Math.round(dArray[j]);
                        lArray6[j] = lArray5[j];
                    }
                    GridExtent gridExtent2 = new GridExtent(null, lArray5, lArray6, true);
                    RenderedImage renderedImage = gridCoverage.render(gridExtent2);
                    MathTransform mathTransform = CoverageCombiner.getGridGeometry((RenderedImage)object, this.destination, (GridExtent)object2).createTransformTo(CoverageCombiner.getGridGeometry(renderedImage, gridCoverage, gridExtent2), PixelInCell.CELL_CENTER);
                    imageCombiner.resample(renderedImage, null, mathTransform);
                }
            } else {
                bl = false;
            }
            for (int i = 0; i < n; ++i) {
                if (i == this.xdim || i == this.ydim) continue;
                long l = lArray4[i];
                int n5 = n3 = l++ <= lArray2[i] ? 1 : 0;
                if (n3 == 0) {
                    l = lArray[i];
                }
                lArray4[i] = l;
                object4[i] = lArray4[i];
                if (n3 != 0) continue block3;
            }
            break;
        }
        return bl;
    }
}

