/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.DoubleBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import javax.measure.Quantity;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.image.BandSelectImage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.RecoloredImage;
import org.apache.sis.image.ResampledImage;
import org.apache.sis.image.Transferer;
import org.apache.sis.internal.coverage.CompoundTransform;
import org.apache.sis.internal.coverage.SampleDimensions;
import org.apache.sis.internal.coverage.j2d.Colorizer;
import org.apache.sis.internal.coverage.j2d.ImageLayout;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.math.Statistics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class Visualization
extends ResampledImage {
    private final MathTransform1D[] converters;
    private final ColorModel colorModel;

    private static Interpolation combine(Interpolation interpolation, MathTransform1D[] mathTransform1DArray) {
        MathTransform mathTransform = CompoundTransform.create((MathTransform[])mathTransform1DArray);
        if (mathTransform.isIdentity()) {
            return interpolation;
        }
        if (mathTransform instanceof MathTransform1D) {
            return new InterpConvertOneBand(interpolation, (MathTransform1D)mathTransform);
        }
        return new InterpConvert(interpolation, mathTransform);
    }

    private Visualization(Builder builder) {
        super(builder.source, builder.sampleModel, builder.layout.getMinTile(), builder.bounds, builder.toSource, builder.interpolation, builder.fillValues, builder.positionalAccuracyHints);
        this.colorModel = builder.colorModel;
        this.converters = builder.converters;
    }

    @Override
    final boolean hasNoMask() {
        return !(this.interpolation instanceof InterpConvert) && super.hasNoMask();
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    protected Raster computeTile(int n, int n2, WritableRaster writableRaster) throws TransformException {
        if (this.converters == null) {
            try {
                return super.computeTile(n, n2, writableRaster);
            }
            catch (BackingStoreException backingStoreException) {
                throw backingStoreException.unwrapOrRethrow(TransformException.class);
            }
        }
        if (writableRaster == null) {
            writableRaster = this.createTile(n, n2);
        }
        Transferer.create(this.getSource(), writableRaster).compute(this.converters);
        return writableRaster;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            Visualization visualization = (Visualization)object;
            return Arrays.equals(this.converters, visualization.converters) && Objects.equals(this.colorModel, visualization.colorModel);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 67 * Arrays.hashCode(this.converters) + 97 * Objects.hashCode(this.colorModel);
    }

    static final class Builder {
        private static final int NUM_BANDS = 1;
        private static final int VISIBLE_BAND = 0;
        private Rectangle bounds;
        private RenderedImage source;
        private MathTransform toSource;
        private List<SampleDimension> sourceBands;
        private Collection<Map.Entry<NumberRange<?>, Color[]>> rangesAndColors;
        ImageLayout layout;
        Interpolation interpolation;
        Function<Category, Color[]> categoryColors;
        Number[] fillValues;
        Quantity<?>[] positionalAccuracyHints;
        private MathTransform1D[] converters;
        private SampleModel sampleModel;
        private ColorModel colorModel;

        Builder(Rectangle rectangle, RenderedImage renderedImage, MathTransform mathTransform, List<SampleDimension> list) {
            this.bounds = rectangle;
            this.source = renderedImage;
            this.toSource = mathTransform;
            this.sourceBands = list;
        }

        Builder(RenderedImage renderedImage, Collection<Map.Entry<NumberRange<?>, Color[]>> collection) {
            this.source = renderedImage;
            this.rangesAndColors = collection;
        }

        RenderedImage create(ImageProcessor imageProcessor) throws NoninvertibleTransformException {
            DoubleUnaryOperator[] doubleUnaryOperatorArray;
            boolean bl;
            Colorizer colorizer;
            int n = ImageUtilities.getVisibleBand(this.source);
            if (n < 0) {
                throw new IllegalArgumentException(Resources.format((short)55));
            }
            if (this.rangesAndColors != null) {
                colorizer = new Colorizer(this.rangesAndColors);
                bl = true;
            } else {
                colorizer = new Colorizer(this.categoryColors);
                boolean bl2 = bl = this.sourceBands != null && colorizer.initialize(this.source.getSampleModel(), this.sourceBands.get(n));
                if (bl) {
                    colorizer.rescaleMainRange(this.source.getColorModel());
                } else {
                    bl = colorizer.initialize(this.source.getColorModel());
                    if (!bl) {
                        if (this.source instanceof RecoloredImage) {
                            doubleUnaryOperatorArray = (RecoloredImage)this.source;
                            colorizer.initialize(doubleUnaryOperatorArray.minimum, doubleUnaryOperatorArray.maximum);
                            bl = true;
                        } else {
                            bl = colorizer.initialize(this.source.getSampleModel(), n);
                        }
                    }
                }
            }
            this.source = BandSelectImage.create(this.source, new int[]{n});
            if (!bl) {
                doubleUnaryOperatorArray = SampleDimensions.toSampleFilters(imageProcessor, this.sourceBands);
                Statistics statistics = imageProcessor.valueOfStatistics(this.source, null, doubleUnaryOperatorArray)[0];
                colorizer.initialize(statistics.minimum(), statistics.maximum());
            }
            while (this.source instanceof RecoloredImage) {
                this.source = ((RecoloredImage)this.source).source;
            }
            this.colorModel = colorizer.compactColorModel(1, 0);
            this.converters = new MathTransform1D[]{colorizer.getSampleToIndexValues()};
            if (this.toSource == null) {
                this.toSource = MathTransforms.identity((int)2);
            }
            if (this.toSource.isIdentity() && (this.bounds == null || ImageUtilities.getBounds(this.source).contains(this.bounds))) {
                this.layout = ImageLayout.fixedSize(this.source);
                this.interpolation = Interpolation.NEAREST;
            } else {
                this.interpolation = Visualization.combine(this.interpolation.toCompatible(this.source), this.converters);
                this.converters = null;
            }
            this.sampleModel = this.layout.createBandedSampleModel(0, 1, this.source, this.bounds);
            if (this.bounds == null) {
                this.bounds = ImageUtilities.getBounds(this.source);
            }
            return ImageProcessor.unique(new Visualization(this));
        }
    }

    private static final class InterpConvertOneBand
    extends InterpConvert {
        private final MathTransform1D singleConverter;

        InterpConvertOneBand(Interpolation interpolation, MathTransform1D mathTransform1D) {
            super(interpolation, (MathTransform)mathTransform1D);
            this.singleConverter = mathTransform1D;
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            this.interpolation.interpolate(doubleBuffer, n, d, d2, dArray, n2);
            try {
                dArray[n2] = this.singleConverter.transform(dArray[n2]);
            }
            catch (TransformException transformException) {
                throw new BackingStoreException(transformException);
            }
        }
    }

    static class InterpConvert
    extends Interpolation {
        final Interpolation interpolation;
        final MathTransform converter;

        InterpConvert(Interpolation interpolation, MathTransform mathTransform) {
            this.interpolation = interpolation;
            this.converter = mathTransform;
        }

        @Override
        public final Dimension getSupportSize() {
            return this.interpolation.getSupportSize();
        }

        @Override
        public void interpolate(DoubleBuffer doubleBuffer, int n, double d, double d2, double[] dArray, int n2) {
            this.interpolation.interpolate(doubleBuffer, n, d, d2, dArray, n2);
            try {
                this.converter.transform(dArray, n2, dArray, n2, 1);
            }
            catch (TransformException transformException) {
                throw new BackingStoreException(transformException);
            }
        }

        @Override
        Interpolation toCompatible(RenderedImage renderedImage) {
            return this;
        }
    }
}

