/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.ImagingOpException;
import java.awt.image.RenderedImage;
import java.util.function.Function;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.MathTransformsOrFactory;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SliceGeometry
implements Function<RenderedImage, GridGeometry> {
    private final GridGeometry geometry;
    private final GridExtent sliceExtent;
    private final int[] gridDimensions;
    private final MathTransformFactory factory;

    SliceGeometry(GridGeometry gridGeometry, GridExtent gridExtent, int[] nArray, MathTransformFactory mathTransformFactory) {
        this.geometry = gridGeometry;
        this.sliceExtent = gridExtent;
        this.gridDimensions = nArray;
        this.factory = mathTransformFactory;
    }

    @Override
    public GridGeometry apply(RenderedImage renderedImage) {
        try {
            GridExtent gridExtent = new GridExtent(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            return this.reduce(gridExtent, 2);
        }
        catch (FactoryException factoryException) {
            throw SliceGeometry.canNotCompute(factoryException);
        }
    }

    final GridGeometry reduce(GridExtent gridExtent, int n) throws FactoryException {
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        GridExtent gridExtent2 = this.geometry.extent;
        MathTransform mathTransform = this.geometry.gridToCRS;
        MathTransform mathTransform2 = this.geometry.cornerToCRS;
        double[] dArray = this.geometry.resolution;
        int[] nArray = this.gridDimensions;
        if (mathTransform != null) {
            TransformSeparator transformSeparator = new TransformSeparator(mathTransform, this.factory);
            transformSeparator.addSourceDimensions(this.gridDimensions);
            nArray = SliceGeometry.findTargetDimensions(mathTransform, gridExtent2, dArray, this.gridDimensions, n);
            if (nArray != null) {
                transformSeparator.addTargetDimensions(nArray);
            }
            mathTransform = transformSeparator.separate();
            nArray = transformSeparator.getTargetDimensions();
            transformSeparator = new TransformSeparator(mathTransform2, this.factory);
            transformSeparator.addSourceDimensions(this.gridDimensions);
            transformSeparator.addTargetDimensions(nArray);
            mathTransform2 = transformSeparator.separate();
        }
        boolean bl2 = bl = this.sliceExtent != null && !this.sliceExtent.equals(gridExtent2, ComparisonMode.IGNORE_METADATA);
        if (bl) {
            gridExtent2 = this.sliceExtent;
        }
        if (gridExtent2 != null) {
            gridExtent2 = gridExtent2.selectDimensions(this.gridDimensions);
        }
        GeneralEnvelope generalEnvelope = null;
        if (bl && mathTransform2 != null) {
            try {
                generalEnvelope = gridExtent2.toEnvelope(mathTransform2, mathTransform, null);
            }
            catch (TransformException transformException) {
                GridGeometry.recoverableException("reduce", transformException);
            }
        }
        int n2 = nArray.length;
        ImmutableEnvelope immutableEnvelope = this.geometry.envelope;
        if (immutableEnvelope != null) {
            if (generalEnvelope != null || immutableEnvelope.getDimension() != n2) {
                int n3;
                object3 = CRS.selectDimensions((CoordinateReferenceSystem)immutableEnvelope.getCoordinateReferenceSystem(), (int[])nArray);
                object2 = new double[n2];
                object = new double[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4 = nArray[n3];
                    object2[n3] = immutableEnvelope.getLower(n4);
                    object[n3] = immutableEnvelope.getUpper(n4);
                }
                if (generalEnvelope != null) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        double d;
                        double d2;
                        double d3 = generalEnvelope.getLower(n3);
                        if (d2 > object2[n3]) {
                            object2[n3] = d3;
                        }
                        d3 = generalEnvelope.getUpper(n3);
                        if (!(d < object[n3])) continue;
                        object[n3] = d3;
                    }
                }
                immutableEnvelope = new ImmutableEnvelope(object2, object, object3);
            }
        } else if (generalEnvelope != null) {
            immutableEnvelope = new ImmutableEnvelope((Envelope)generalEnvelope);
        }
        if (bl || dArray == null) {
            dArray = GridGeometry.resolution(mathTransform, gridExtent2, PixelInCell.CELL_CENTER);
        } else if (dArray.length != n2) {
            dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray[i] = this.geometry.resolution[nArray[i]];
            }
        }
        if (gridExtent != null) {
            if (gridExtent2 != null && !gridExtent2.startsAtZero()) {
                object3 = new double[this.gridDimensions.length];
                for (int i = 0; i < this.gridDimensions.length; ++i) {
                    object3[i] = (CoordinateReferenceSystem)((double)gridExtent2.getLow(this.gridDimensions[i]));
                }
                object2 = MathTransforms.translation((double[])object3);
                object = MathTransformsOrFactory.wrap((MathTransformFactory)this.factory);
                if (mathTransform != null) {
                    mathTransform = object.concatenate((MathTransform)object2, mathTransform);
                    mathTransform2 = object.concatenate((MathTransform)object2, mathTransform2);
                }
            }
            gridExtent2 = gridExtent;
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l |= (this.geometry.nonLinears >>> nArray[i] & 1L) << i;
        }
        return new GridGeometry(gridExtent2, mathTransform, mathTransform2, immutableEnvelope, dArray, l);
    }

    private static int[] findTargetDimensions(MathTransform mathTransform, GridExtent gridExtent, double[] dArray, int[] nArray, int n) {
        int n2;
        int n3 = -1;
        Matrix matrix = MathTransforms.getMatrix((MathTransform)mathTransform);
        if (matrix == null) {
            if (gridExtent != null) {
                try {
                    matrix = mathTransform.derivative((DirectPosition)new DirectPositionView.Double(gridExtent.getPointOfInterest(PixelInCell.CELL_CENTER)));
                }
                catch (TransformException transformException) {
                    GridGeometry.recoverableException("reduce", transformException);
                    return null;
                }
            } else {
                return null;
            }
            n3 = 0;
        }
        n3 += matrix.getNumRow();
        if (n < 0) {
            n = nArray.length + (mathTransform.getTargetDimensions() - mathTransform.getSourceDimensions());
        }
        long l = 0L;
        while (Long.bitCount(l) < n) {
            double d = -1.0;
            n2 = -1;
            int n4 = -1;
            for (int i = 0; i < n3; ++i) {
                double d2;
                if ((l & Numerics.bitmask(i)) != 0L) continue;
                double d3 = 1.0;
                if (dArray != null && (d2 = dArray[i]) > 0.0) {
                    d3 = d2;
                }
                for (int j = 0; j < nArray.length; ++j) {
                    double d4 = Math.abs(matrix.getElement(i, nArray[j])) / d3;
                    if (!(d4 > d)) continue;
                    d = d4;
                    n2 = j;
                    n4 = i;
                }
            }
            if ((n2 | n4) < 0) {
                return null;
            }
            if (d > 0.0) {
                if (n4 >= 64) {
                    throw GridGeometry.excessiveDimension(mathTransform);
                }
                l |= 1L << n4;
            }
            nArray = ArraysExt.remove(nArray, n2, 1);
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = n2 = Long.numberOfTrailingZeros(l);
            l &= 1L << n2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return nArray2;
    }

    static ImagingOpException canNotCompute(FactoryException factoryException) {
        throw (ImagingOpException)new ImagingOpException(Errors.format((short)5, "ImageGeometry")).initCause(factoryException);
    }
}

