/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

final class GridExtentCRS {
    private static final String NAME_PARAM = "Target grid name";
    private static final String ANCHOR_PARAM = "Pixel in cell";
    private static final OperationMethod METHOD;
    private static final InternationalString SCOPE;
    private static final NamedIdentifier CS_NAME;

    private GridExtentCRS() {
    }

    static DerivedCRS forCoverage(String string, GridGeometry gridGeometry, PixelInCell pixelInCell, Locale locale) throws FactoryException, NoninvertibleTransformException {
        ParameterValueGroup parameterValueGroup;
        Object object;
        TransformSeparator transformSeparator;
        CoordinateReferenceSystem coordinateReferenceSystem = gridGeometry.getCoordinateReferenceSystem();
        boolean bl = false;
        while (!(coordinateReferenceSystem instanceof SingleCRS)) {
            if (!(coordinateReferenceSystem instanceof CompoundCRS)) {
                throw GridExtentCRS.unsupported(locale, coordinateReferenceSystem);
            }
            coordinateReferenceSystem = (CoordinateReferenceSystem)((CompoundCRS)coordinateReferenceSystem).getComponents().get(0);
            bl = true;
        }
        MathTransform mathTransform = gridGeometry.getGridToCRS(pixelInCell);
        ParameterValueGroup parameterValueGroup2 = gridGeometry.getExtent().getAxisTypes();
        if (bl) {
            transformSeparator = new TransformSeparator(mathTransform);
            transformSeparator.addTargetDimensionRange(0, coordinateReferenceSystem.getCoordinateSystem().getDimension());
            mathTransform = transformSeparator.separate();
            object = transformSeparator.getSourceDimensions();
            parameterValueGroup = parameterValueGroup2;
            parameterValueGroup2 = new DimensionNameType[((Object)object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                if (object2 >= ((DimensionNameType[])parameterValueGroup).length) continue;
                parameterValueGroup2[i] = parameterValueGroup[object2];
            }
        }
        if ((transformSeparator = GridExtentCRS.createCS(mathTransform.getSourceDimensions(), null, (DimensionNameType[])parameterValueGroup2, locale)) == null) {
            throw GridExtentCRS.unsupported(locale, coordinateReferenceSystem);
        }
        object = new HashMap<String, ReferenceIdentifier>(8);
        ((HashMap)object).put("name", METHOD.getName());
        ((HashMap)object).put("locale", locale);
        ((HashMap)object).put("scope", SCOPE);
        gridGeometry.getGeographicExtent().ifPresent(arg_0 -> GridExtentCRS.lambda$forCoverage$0((HashMap)object, arg_0));
        parameterValueGroup = METHOD.getParameters().createValue();
        parameterValueGroup.parameter(NAME_PARAM).setValue((Object)string);
        parameterValueGroup.parameter(ANCHOR_PARAM).setValue((Object)pixelInCell);
        DefaultConversion defaultConversion = new DefaultConversion((Map)object, METHOD, mathTransform.inverse(), parameterValueGroup);
        ((HashMap)object).put("name", string);
        return DefaultDerivedCRS.create((Map)object, (SingleCRS)((SingleCRS)coordinateReferenceSystem), (Conversion)defaultConversion, (CoordinateSystem)transformSeparator);
    }

    private static FactoryException unsupported(Locale locale, CoordinateReferenceSystem coordinateReferenceSystem) {
        return new FactoryException(Errors.getResources(locale).getString((short)163, Classes.getShortClassName(coordinateReferenceSystem)));
    }

    private static Map<String, ?> properties(Object object) {
        return Collections.singletonMap("name", object);
    }

    private static CoordinateSystemAxis axis(CSFactory cSFactory, String string, String string2, AxisDirection axisDirection) throws FactoryException {
        return cSFactory.createCoordinateSystemAxis(GridExtentCRS.properties(string), string2, axisDirection, Units.UNITY);
    }

    private static String abbreviation(int n) {
        StringBuilder stringBuilder = new StringBuilder(4).append('x').append(n);
        int n2 = stringBuilder.length();
        while (--n2 >= 1) {
            stringBuilder.setCharAt(n2, Characters.toSuperScript(stringBuilder.charAt(n2)));
        }
        return stringBuilder.toString();
    }

    private static CoordinateSystem createCS(int n, Matrix matrix, DimensionNameType[] dimensionNameTypeArray, Locale locale) throws FactoryException {
        Object object;
        int n2;
        int n3 = dimensionNameTypeArray.length;
        if (matrix != null) {
            n3 = Math.min(matrix.getNumCol() - 1, n3);
        }
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        CSFactory cSFactory = DefaultFactories.forBuildin(CSFactory.class);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            AxisDirection axisDirection;
            String string;
            object = dimensionNameTypeArray[n2];
            if (object == null) continue;
            int n4 = n2;
            double d = 0.0;
            if (matrix != null) {
                n4 = -1;
                for (int i = 0; i < n; ++i) {
                    double d2 = matrix.getElement(i, n2);
                    if (d2 == 0.0) continue;
                    if (n4 >= 0 || coordinateSystemAxisArray[i] != null || Math.abs(d2) != 1.0) {
                        return null;
                    }
                    n4 = i;
                    d = d2;
                }
                if (n4 < 0) {
                    return null;
                }
            }
            if (object == DimensionNameType.COLUMN || object == DimensionNameType.SAMPLE) {
                string = "x";
                axisDirection = AxisDirection.COLUMN_POSITIVE;
            } else if (object == DimensionNameType.ROW || object == DimensionNameType.LINE) {
                string = "y";
                axisDirection = AxisDirection.ROW_POSITIVE;
            } else if (object == DimensionNameType.VERTICAL) {
                string = "z";
                axisDirection = AxisDirection.UP;
                bl = true;
            } else if (object == DimensionNameType.TIME) {
                string = "t";
                axisDirection = AxisDirection.FUTURE;
                bl2 = true;
            } else {
                string = GridExtentCRS.abbreviation(n4);
                axisDirection = AxisDirection.OTHER;
                bl3 = true;
            }
            int n5 = n;
            while (--n5 >= 0) {
                CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[n5];
                if (coordinateSystemAxis == null) continue;
                if (axisDirection.equals((Object)AxisDirections.absolute((AxisDirection)coordinateSystemAxis.getDirection()))) {
                    axisDirection = AxisDirection.OTHER;
                    bl3 = true;
                }
                if (!string.equals(coordinateSystemAxis.getAbbreviation())) continue;
                string = GridExtentCRS.abbreviation(n4);
            }
            if (d < 0.0) {
                axisDirection = AxisDirections.opposite((AxisDirection)axisDirection);
            }
            String string2 = Types.toString(Types.getCodeTitle(object), locale);
            coordinateSystemAxisArray[n4] = GridExtentCRS.axis(cSFactory, string2, string, axisDirection);
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (coordinateSystemAxisArray[n2] != null) continue;
            object = Vocabulary.getResources(locale).getString((short)64, n2);
            String string = GridExtentCRS.abbreviation(n2);
            coordinateSystemAxisArray[n2] = GridExtentCRS.axis(cSFactory, (String)object, string, AxisDirection.OTHER);
        }
        Map<String, ?> map = GridExtentCRS.properties(CS_NAME);
        if (bl3 || n > (bl2 ? 1 : 3)) {
            object = new AbstractCS(map, coordinateSystemAxisArray);
        } else {
            switch (n) {
                case 1: {
                    CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[0];
                    if (bl) {
                        object = cSFactory.createVerticalCS(map, coordinateSystemAxis);
                        break;
                    }
                    if (bl2) {
                        object = cSFactory.createTimeCS(map, coordinateSystemAxis);
                        break;
                    }
                    object = cSFactory.createLinearCS(map, coordinateSystemAxis);
                    break;
                }
                case 2: {
                    object = matrix == null ? cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]) : cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1]);
                    break;
                }
                case 3: {
                    object = matrix == null ? cSFactory.createCartesianCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]) : cSFactory.createAffineCS(map, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
                    break;
                }
                default: {
                    object = null;
                }
            }
        }
        return object;
    }

    static EngineeringCRS forExtentAlone(Matrix matrix, DimensionNameType[] dimensionNameTypeArray) throws FactoryException {
        CoordinateSystem coordinateSystem = GridExtentCRS.createCS(matrix.getNumRow() - 1, matrix, dimensionNameTypeArray, null);
        if (coordinateSystem == null) {
            return null;
        }
        return DefaultFactories.forBuildin(CRSFactory.class).createEngineeringCRS(GridExtentCRS.properties(coordinateSystem.getName()), CommonCRS.Engineering.GRID.datum(), coordinateSystem);
    }

    private static /* synthetic */ void lambda$forCoverage$0(HashMap hashMap, GeographicBoundingBox geographicBoundingBox) {
        hashMap.put("domainOfValidity", new DefaultExtent(null, (GeographicExtent)geographicBoundingBox, null, null));
    }

    static {
        ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
        ParameterDescriptor parameterDescriptor = ((ParameterBuilder)parameterBuilder.addName((CharSequence)NAME_PARAM)).create(String.class, null);
        ParameterDescriptor parameterDescriptor2 = ((ParameterBuilder)parameterBuilder.addName((CharSequence)ANCHOR_PARAM)).create(PixelInCell.class, (Object)PixelInCell.CELL_CENTER);
        ParameterDescriptorGroup parameterDescriptorGroup = ((ParameterBuilder)parameterBuilder.addName((CharSequence)"CRS to grid indices")).createGroup(new GeneralParameterDescriptor[]{parameterDescriptor, parameterDescriptor2});
        METHOD = new DefaultOperationMethod(GridExtentCRS.properties(parameterDescriptorGroup.getName()), parameterDescriptorGroup);
        SCOPE = Resources.formatInternational((short)79, new Object[0]);
        CS_NAME = new NamedIdentifier(Citations.SIS, (CharSequence)Vocabulary.formatInternational((short)97));
    }
}

