/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridCoordinatesView;
import org.apache.sis.coverage.grid.GridExtentCRS;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class GridExtent
implements Serializable,
LenientComparable {
    private static final long serialVersionUID = -4717353677844056017L;
    private static final Map<AxisDirection, DimensionNameType> AXIS_DIRECTIONS;
    private static final DimensionNameType[] DEFAULT_TYPES;
    private static final WeakValueHashMap<DimensionNameType[], DimensionNameType[]> POOL;
    private final DimensionNameType[] types;
    private final long[] coordinates;

    static long[] allocate(int n) throws IllegalArgumentException {
        if (n >= Short.MAX_VALUE) {
            throw new IllegalArgumentException(Errors.format((short)37, n));
        }
        return new long[n << 1];
    }

    private void validateCoordinates() throws IllegalArgumentException {
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            long l = this.coordinates[i];
            long l2 = this.coordinates[i + n];
            if (l <= l2) continue;
            throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(i, i), l, l2));
        }
    }

    private static DimensionNameType[] validateAxisTypes(DimensionNameType[] dimensionNameTypeArray) throws IllegalArgumentException {
        if (dimensionNameTypeArray == null || ArraysExt.allEquals(dimensionNameTypeArray, null)) {
            return null;
        }
        if (Arrays.equals(DEFAULT_TYPES, dimensionNameTypeArray)) {
            return DEFAULT_TYPES;
        }
        DimensionNameType[] dimensionNameTypeArray2 = POOL.get(dimensionNameTypeArray);
        if (dimensionNameTypeArray2 == null) {
            dimensionNameTypeArray = (DimensionNameType[])dimensionNameTypeArray.clone();
            for (int i = 1; i < dimensionNameTypeArray.length; ++i) {
                DimensionNameType dimensionNameType = dimensionNameTypeArray[i];
                if (dimensionNameType == null) continue;
                int n = i;
                while (--n >= 0) {
                    if (!dimensionNameType.equals((Object)dimensionNameTypeArray[n])) continue;
                    throw new IllegalArgumentException(Errors.format((short)24, dimensionNameType));
                }
            }
            dimensionNameTypeArray2 = POOL.putIfAbsent(dimensionNameTypeArray, dimensionNameTypeArray);
            if (dimensionNameTypeArray2 == null) {
                return dimensionNameTypeArray;
            }
        }
        return dimensionNameTypeArray2;
    }

    private GridExtent(int n, DimensionNameType[] dimensionNameTypeArray) {
        this.coordinates = GridExtent.allocate(n);
        this.types = GridExtent.validateAxisTypes(dimensionNameTypeArray);
    }

    public GridExtent(Rectangle rectangle) {
        this((long)rectangle.width, rectangle.height);
        this.translate2D(rectangle.x, rectangle.y);
    }

    public GridExtent(long l, long l2) {
        ArgumentChecks.ensureStrictlyPositive("width", l);
        ArgumentChecks.ensureStrictlyPositive("height", l2);
        this.coordinates = new long[4];
        this.coordinates[2] = l - 1L;
        this.coordinates[3] = l2 - 1L;
        this.types = DEFAULT_TYPES;
    }

    GridExtent(int n, int n2, int n3, int n4) {
        this((long)n3, n4);
        this.translate2D(n, n2);
    }

    private void translate2D(long l, long l2) {
        int n = this.coordinates.length;
        while (--n >= 0) {
            int n2 = n;
            this.coordinates[n2] = this.coordinates[n2] + ((n & 1) == 0 ? l : l2);
        }
    }

    public GridExtent(DimensionNameType[] dimensionNameTypeArray, long[] lArray, long[] lArray2, boolean bl) {
        ArgumentChecks.ensureNonNull("high", lArray2);
        int n = lArray2.length;
        if (lArray != null && lArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)80, lArray.length, n));
        }
        if (dimensionNameTypeArray != null && dimensionNameTypeArray.length != n) {
            throw new IllegalArgumentException(Errors.format((short)77));
        }
        this.coordinates = GridExtent.allocate(n);
        if (lArray != null) {
            System.arraycopy(lArray, 0, this.coordinates, 0, n);
        }
        System.arraycopy(lArray2, 0, this.coordinates, n, n);
        if (!bl) {
            for (int i = n; i < this.coordinates.length; ++i) {
                this.coordinates[i] = Math.decrementExact(this.coordinates[i]);
            }
        }
        this.types = GridExtent.validateAxisTypes(dimensionNameTypeArray);
        this.validateCoordinates();
    }

    static DimensionNameType[] typeFromAxes(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        DimensionNameType[] dimensionNameTypeArray = null;
        if (coordinateReferenceSystem != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            for (int i = 0; i < n; ++i) {
                DimensionNameType dimensionNameType = AXIS_DIRECTIONS.get(AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(i).getDirection()));
                if (dimensionNameType == null) continue;
                if (dimensionNameTypeArray == null) {
                    dimensionNameTypeArray = new DimensionNameType[n];
                }
                dimensionNameTypeArray[i] = dimensionNameType;
            }
        }
        return dimensionNameTypeArray;
    }

    GridExtent(AbstractEnvelope abstractEnvelope, GridRoundingMode gridRoundingMode, GridClippingMode gridClippingMode, int[] nArray, int[] nArray2, GridExtent gridExtent, int[] nArray3) {
        int n = abstractEnvelope.getDimension();
        this.coordinates = gridExtent != null ? (long[])gridExtent.coordinates.clone() : GridExtent.allocate(n);
        this.types = gridExtent != null && gridExtent.types != null ? gridExtent.types : GridExtent.validateAxisTypes(GridExtent.typeFromAxes(abstractEnvelope.getCoordinateReferenceSystem(), n));
        for (int i = 0; i < n; ++i) {
            int n2;
            long l;
            long l2;
            long l3;
            boolean bl;
            double d = abstractEnvelope.getLower(i);
            double d2 = abstractEnvelope.getUpper(i);
            boolean bl2 = d >= -9.223372036854776E18;
            boolean bl3 = bl = d2 <= 9.223372036854776E18;
            if (d > d2 || gridExtent == null && !(bl2 & bl)) {
                throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(i, i), d, d2));
            }
            if (!bl2) {
                d = -9.223372036854776E18;
            }
            if (!bl) {
                d2 = 9.223372036854776E18;
            }
            switch (gridRoundingMode) {
                default: {
                    throw new AssertionError((Object)gridRoundingMode);
                }
                case ENCLOSING: {
                    l3 = (long)Math.floor(d);
                    l2 = (long)Math.ceil(d2);
                    if (l3 == l2) break;
                    --l2;
                    break;
                }
                case CONTAINED: {
                    double d3 = Math.ceil(d);
                    double d4 = Math.floor(d2);
                    if (d3 > d4) {
                        l2 = l3 = (long)(d3 - d > d2 - d4 ? d4 : d3);
                        break;
                    }
                    l3 = (long)d3;
                    l2 = (long)d4;
                    if (l3 == l2) break;
                    --l2;
                    break;
                }
                case NEAREST: {
                    double d5;
                    long l4;
                    l3 = Math.round(d);
                    l2 = Math.round(d2);
                    if (l3 == l2) {
                        if (!(d - Math.floor(d) > Math.ceil(d2) - d2)) break;
                        l2 = --l3;
                        break;
                    }
                    if ((l4 = --l2 - l3 + 1L) < 0L || (l = Math.round(d5 = abstractEnvelope.getSpan(i))) == 0L || Math.abs(l4 -= l) != 1L) break;
                    double d6 = Math.abs(d - Math.rint(d));
                    double d7 = Math.abs(d2 - Math.rint(d2));
                    boolean bl4 = d7 >= d6;
                    double d8 = Math.abs(d5 - (double)l);
                    double d9 = bl4 ? d7 : d6;
                    if (!(d8 < d9)) break;
                    if (bl4) {
                        l2 = Math.subtractExact(l2, l4);
                        break;
                    }
                    l3 = Math.addExact(l3, l4);
                }
            }
            if (gridExtent != null && gridClippingMode == GridClippingMode.BORDER_EXPANSION) {
                int n3 = nArray3 != null ? nArray3[i] : i;
                n2 = n3 + this.getDimension();
                long l5 = Math.max(l3, this.coordinates[n3]);
                if (l5 > (l = Math.min(l2, this.coordinates[n2]))) {
                    throw new DisjointExtentException(this.getAxisIdentification(n3, i), this.coordinates[n3], this.coordinates[n2], l5, l);
                }
                l3 = l5;
                l2 = l;
            }
            if (nArray != null && i < nArray.length) {
                int n4 = nArray[i];
                if (gridExtent != null && n4 > 0) {
                    if (l3 < (l3 -= (long)n4)) {
                        l3 = Long.MIN_VALUE;
                    }
                    if (l2 > (l2 += (long)n4)) {
                        l2 = Long.MAX_VALUE;
                    }
                } else {
                    l3 = Math.subtractExact(l3, (long)n4);
                    l2 = Math.addExact(l2, (long)n4);
                }
            }
            if (l3 > l2) {
                l2 += l3 - l2 >>> 1;
                l3 = l2;
            }
            if (nArray2 != null && i < nArray2.length) {
                int n5 = nArray2[i];
                l3 = Math.subtractExact(l3, Math.floorMod(l3, (long)n5));
                l2 = Math.addExact(l2, (long)(n5 - 1) - Math.floorMod(l2, (long)n5));
            }
            if (gridExtent != null && gridClippingMode == GridClippingMode.STRICT) {
                int n6 = nArray3 != null ? nArray3[i] : i;
                n2 = n6 + this.getDimension();
                long l6 = this.coordinates[n6];
                l = this.coordinates[n2];
                if (l3 > l6) {
                    this.coordinates[n6] = l3;
                }
                if (l2 < l) {
                    this.coordinates[n2] = l2;
                }
                if (l3 <= l && l2 >= l6) continue;
                throw new DisjointExtentException(this.getAxisIdentification(n6, i), l6, l, l3, l2);
            }
            this.coordinates[i] = l3;
            this.coordinates[i + this.getDimension()] = l2;
        }
    }

    GridExtent(GridExtent gridExtent, long[] lArray) {
        this.coordinates = lArray;
        DimensionNameType[] dimensionNameTypeArray = this.types = gridExtent != null ? gridExtent.types : null;
        assert (this.types == null || this.types.length == this.getDimension());
    }

    private GridExtent(GridExtent gridExtent) {
        this.types = gridExtent.types;
        this.coordinates = (long[])gridExtent.coordinates.clone();
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    final int getSubDimension() {
        int n = 0;
        int n2 = this.getDimension();
        for (int i = 0; i < n2; ++i) {
            if (this.coordinates[i] == this.coordinates[i + n2]) continue;
            ++n;
        }
        return n;
    }

    public boolean startsAtZero() {
        return GridExtent.isZero(this.coordinates, this.getDimension());
    }

    private static boolean isZero(long[] lArray, int n) {
        while (--n >= 0) {
            if (lArray[n] == 0L) continue;
            return false;
        }
        return true;
    }

    GridCoordinatesView getLow() {
        return new GridCoordinatesView(this.coordinates, 0);
    }

    GridCoordinatesView getHigh() {
        return new GridCoordinatesView(this.coordinates, this.getDimension());
    }

    public long getLow(int n) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), n);
        return this.coordinates[n];
    }

    public long getHigh(int n) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex(n2, n);
        return this.coordinates[n + n2];
    }

    public long getMedian(int n) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex(n2, n);
        long l = this.coordinates[n];
        long l2 = this.coordinates[n + n2];
        return (l >> 1) + (l2 >> 1) + ((l | l2) & 1L);
    }

    public long getSize(int n) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex(n2, n);
        return Math.incrementExact(Math.subtractExact(this.coordinates[n2 + n], this.coordinates[n]));
    }

    public double getSize(int n, boolean bl) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex(n2, n);
        long l = this.coordinates[n2 + n] - this.coordinates[n];
        if (!bl && ++l == 0L) {
            return 1.8446744073709552E19;
        }
        return Numerics.toUnsignedDouble(l);
    }

    @Deprecated
    public double[] getPointOfInterest() {
        return this.getPointOfInterest(PixelInCell.CELL_CORNER);
    }

    public double[] getPointOfInterest(PixelInCell pixelInCell) {
        int n = this.getDimension();
        double[] dArray = new double[n];
        boolean bl = PixelInCell.CELL_CORNER.equals((Object)pixelInCell);
        for (int i = 0; i < n; ++i) {
            long l = this.coordinates[i];
            if (bl) {
                l = Math.incrementExact(this.coordinates[i]);
            }
            dArray[i] = MathFunctions.average(l, this.coordinates[i + n]);
        }
        return dArray;
    }

    public SortedMap<Integer, Long> getSliceCoordinates() {
        TreeMap<Integer, Long> treeMap = new TreeMap<Integer, Long>();
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            long l = this.coordinates[i];
            if (l != this.coordinates[i + n]) continue;
            treeMap.put(i, l);
        }
        return treeMap;
    }

    public int[] getSubspaceDimensions(int n) {
        int n2;
        ArgumentChecks.ensurePositive("s", n);
        int n3 = this.getDimension();
        if (n > n3) {
            throw new CannotEvaluateException(Resources.format((short)22, n));
        }
        int[] nArray = new int[n];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            long l = this.coordinates[n2];
            long l2 = this.coordinates[n2 + n3];
            if (l == l2) continue;
            if (n4 < n) {
                nArray[n4++] = n2;
                continue;
            }
            long l3 = l2 - l;
            if (l3 != -1L) {
                ++l3;
            }
            throw new SubspaceNotSpecifiedException(Resources.format((short)50, n, this.getAxisIdentification(n2, n2), Numerics.toUnsignedDouble(l3)));
        }
        if (n != n4) {
            n2 = 0;
            while (true) {
                if (this.coordinates[n2] == this.coordinates[n2 + n3]) {
                    nArray[n4++] = n2;
                    if (n4 == n) break;
                }
                ++n2;
            }
            Arrays.sort(nArray);
        }
        return nArray;
    }

    public Optional<DimensionNameType> getAxisType(int n) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), n);
        return Optional.ofNullable(this.types != null ? this.types[n] : null);
    }

    final DimensionNameType[] getAxisTypes() {
        return this.types != null ? this.types : DEFAULT_TYPES;
    }

    final Object getAxisIdentification(int n, int n2) {
        DimensionNameType dimensionNameType;
        if (this.types != null && (dimensionNameType = this.types[n]) != null) {
            return n2 + " (" + Types.getCodeTitle(dimensionNameType) + ')';
        }
        return n2;
    }

    public GridExtent withRange(int n, long l, long l2) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureValidIndex(n2, n);
        if (this.coordinates[n] == l && this.coordinates[n2 += n] == l2) {
            return this;
        }
        if (l > l2) {
            throw new IllegalArgumentException(Resources.format((short)27, this.getAxisIdentification(n, n), l, l2));
        }
        GridExtent gridExtent = new GridExtent(this);
        gridExtent.coordinates[n] = l;
        gridExtent.coordinates[n2] = l2;
        return gridExtent;
    }

    public GeneralEnvelope toEnvelope(MathTransform mathTransform) throws TransformException {
        ArgumentChecks.ensureNonNull("cornerToCRS", mathTransform);
        GeneralEnvelope generalEnvelope = this.toEnvelope(mathTransform, mathTransform, null);
        Matrix matrix = MathTransforms.getMatrix((MathTransform)mathTransform);
        if (matrix != null && Matrices.isAffine((Matrix)matrix)) {
            try {
                generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)GridExtentCRS.forExtentAlone(matrix, this.getAxisTypes()));
            }
            catch (FactoryException factoryException) {
                throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
            }
        }
        return generalEnvelope;
    }

    final GeneralEnvelope toEnvelope(MathTransform mathTransform, MathTransform mathTransform2, Envelope envelope) throws TransformException {
        GeneralEnvelope generalEnvelope = Envelopes.transform((MathTransform)mathTransform, (Envelope)this.toEnvelope());
        this.complete(generalEnvelope, mathTransform2, mathTransform2 != mathTransform, envelope);
        return generalEnvelope;
    }

    final GeneralEnvelope toEnvelope() {
        int n = this.getDimension();
        GeneralEnvelope generalEnvelope = new GeneralEnvelope(n);
        for (int i = 0; i < n; ++i) {
            long l = this.coordinates[i + n];
            if (l != Long.MAX_VALUE) {
                ++l;
            }
            generalEnvelope.setRange(i, (double)this.coordinates[i], (double)l);
        }
        return generalEnvelope;
    }

    final GeneralEnvelope[] toEnvelopes(MathTransform mathTransform, MathTransform mathTransform2, Envelope envelope) throws TransformException {
        GeneralEnvelope[] generalEnvelopeArray;
        for (GeneralEnvelope generalEnvelope : generalEnvelopeArray = Envelopes.wraparound((MathTransform)mathTransform, (Envelope)this.toEnvelope())) {
            this.complete(generalEnvelope, mathTransform2, mathTransform2 != mathTransform, envelope);
        }
        return generalEnvelopeArray;
    }

    private void complete(GeneralEnvelope generalEnvelope, MathTransform mathTransform, boolean bl, Envelope envelope) {
        if (generalEnvelope.isEmpty()) {
            try {
                int n;
                int n2 = this.getDimension();
                TransformSeparator transformSeparator = null;
                for (n = 0; n < n2; ++n) {
                    if (this.coordinates[n + n2] != 0L || this.coordinates[n] != 0L) continue;
                    if (transformSeparator == null) {
                        transformSeparator = new TransformSeparator(mathTransform);
                    }
                    transformSeparator.addSourceDimensionRange(n, n + 1);
                    Matrix matrix = MathTransforms.getMatrix((MathTransform)transformSeparator.separate());
                    if (matrix != null) {
                        int[] nArray = transformSeparator.getTargetDimensions();
                        for (int i = 0; i < nArray.length; ++i) {
                            int n3 = nArray[i];
                            double d = generalEnvelope.getLower(n3);
                            double d2 = generalEnvelope.getUpper(n3);
                            double d3 = matrix.getElement(i, matrix.getNumCol() - 1);
                            if (bl) {
                                double d4 = d2 - d3;
                                if (Double.isNaN(d4) && Double.isNaN(d4 = d3 - d)) {
                                    d4 = 0.0;
                                }
                                if (Double.isNaN(d)) {
                                    d = d3 - d4;
                                }
                                if (Double.isNaN(d2)) {
                                    d2 = d3 + d4;
                                }
                            } else if (Double.isNaN(d)) {
                                d = d3;
                            }
                            generalEnvelope.setRange(n3, d, d2);
                        }
                    }
                    transformSeparator.clear();
                }
                if (envelope != null) {
                    n = generalEnvelope.getDimension();
                    while (--n >= 0) {
                        boolean bl2 = false;
                        double d = generalEnvelope.getLower(n);
                        double d5 = generalEnvelope.getUpper(n);
                        if (Double.isNaN(d)) {
                            d = envelope.getMinimum(n);
                            bl2 = true;
                        }
                        if (Double.isNaN(d5)) {
                            d5 = envelope.getMaximum(n);
                            bl2 = true;
                        }
                        if (!bl2 || d > d5) continue;
                        generalEnvelope.setRange(n, d, d5);
                    }
                }
            }
            catch (FactoryException factoryException) {
                Logging.recoverableException(Logger.getLogger("org.apache.sis.raster"), GridExtent.class, "toEnvelope", factoryException);
            }
        }
    }

    public GridExtent insertDimension(int n, DimensionNameType dimensionNameType, long l, long l2, boolean bl) {
        int n2 = this.getDimension();
        ArgumentChecks.ensureBetween("offset", 0, n2, n);
        if (!bl) {
            l2 = Math.decrementExact(l2);
        }
        int n3 = n2 + 1;
        DimensionNameType[] dimensionNameTypeArray = null;
        if (this.types != null || dimensionNameType != null) {
            dimensionNameTypeArray = this.types != null ? ArraysExt.insert(this.types, n, 1) : new DimensionNameType[n3];
            dimensionNameTypeArray[n] = dimensionNameType;
        }
        GridExtent gridExtent = new GridExtent(n3, dimensionNameTypeArray);
        System.arraycopy(this.coordinates, 0, gridExtent.coordinates, 0, n);
        System.arraycopy(this.coordinates, n, gridExtent.coordinates, n + 1, n2 - n);
        System.arraycopy(this.coordinates, n2, gridExtent.coordinates, n3, n);
        System.arraycopy(this.coordinates, n2 + n, gridExtent.coordinates, n3 + n + 1, n2 - n);
        gridExtent.coordinates[n] = l;
        gridExtent.coordinates[n + n3] = l2;
        gridExtent.validateCoordinates();
        return gridExtent;
    }

    public GridExtent selectDimensions(int ... nArray) {
        return (nArray = GridExtent.verifyDimensions(nArray, this.getDimension())) != null ? this.reorder(nArray) : this;
    }

    @Deprecated
    public GridExtent reduceDimension(int ... nArray) {
        return this.selectDimensions(nArray);
    }

    static int[] verifyDimensions(int[] nArray, int n) {
        ArgumentChecks.ensureNonNull("dimensions", nArray);
        int n2 = nArray.length;
        ArgumentChecks.ensureSizeBetween("dimensions", 1, n, n2);
        nArray = (int[])nArray.clone();
        if (!ArraysExt.isSorted(nArray, true)) {
            throw new IllegalArgumentException(Resources.format((short)54));
        }
        int n3 = nArray[0];
        if (n3 >= 0 && (n3 = nArray[n2 - 1]) < n) {
            return (int[])(n2 != n ? nArray : null);
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, n3));
    }

    final GridExtent reorder(int[] nArray) {
        int n = this.getDimension();
        int n2 = nArray.length;
        DimensionNameType[] dimensionNameTypeArray = null;
        if (this.types != null) {
            dimensionNameTypeArray = new DimensionNameType[n2];
            for (int i = 0; i < n2; ++i) {
                dimensionNameTypeArray[i] = this.types[nArray[i]];
            }
        }
        GridExtent gridExtent = new GridExtent(n2, dimensionNameTypeArray);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            gridExtent.coordinates[i] = this.coordinates[n3];
            gridExtent.coordinates[i + n2] = this.coordinates[n3 + n];
        }
        return gridExtent;
    }

    public GridExtent expand(long ... lArray) {
        ArgumentChecks.ensureNonNull("margins", lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        if (GridExtent.isZero(lArray, n2)) {
            return this;
        }
        GridExtent gridExtent = new GridExtent(this);
        long[] lArray2 = gridExtent.coordinates;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            lArray2[i] = Math.subtractExact(lArray2[i], l);
            lArray2[i + n] = Math.addExact(lArray2[i + n], l);
        }
        return gridExtent;
    }

    final GridExtent forChunkSize(int ... nArray) {
        int n = this.getDimension();
        int n2 = Math.min(n, nArray.length);
        GridExtent gridExtent = new GridExtent(this);
        long[] lArray = gridExtent.coordinates;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = i + n;
            lArray[i] = Math.subtractExact(lArray[i], Math.floorMod(lArray[i], (long)n3));
            lArray[n4] = Math.addExact(lArray[n4], (long)(n3 - 1) - Math.floorMod(lArray[n4], (long)n3));
        }
        return gridExtent;
    }

    public GridExtent resize(long ... lArray) {
        ArgumentChecks.ensureNonNull("sizes", lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        GridExtent gridExtent = new GridExtent(this);
        long[] lArray2 = gridExtent.coordinates;
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            if (l <= 0L) {
                throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("sizes", i), l));
            }
            long l2 = lArray2[i];
            long l3 = lArray2[i + n];
            long l4 = Math.incrementExact(Math.subtractExact(l3, l2));
            if (Math.abs(l2) <= Math.abs(l3)) {
                l2 = Numerics.multiplyDivide(l2, l, l4);
                l3 = Math.addExact(l2, l - 1L);
            } else {
                l3 = Numerics.multiplyDivide(l3, l, l4);
                l2 = Math.subtractExact(l3, l - 1L);
            }
            lArray2[i] = l2;
            lArray2[i + n] = l3;
        }
        return Arrays.equals(lArray2, this.coordinates) ? this : gridExtent;
    }

    public GridExtent subsample(int ... nArray) {
        ArgumentChecks.ensureNonNull("periods", nArray);
        int n = this.getDimension();
        int n2 = Math.min(n, nArray.length);
        GridExtent gridExtent = new GridExtent(this);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 > 1) {
                int n4 = i + n;
                long l = this.coordinates[i];
                long l2 = this.coordinates[n4] - l + 1L;
                if (l2 == 0L) {
                    throw new ArithmeticException(Errors.format((short)10, 64));
                }
                long l3 = Long.divideUnsigned(l2, n3);
                if (l3 * (long)n3 == l2) {
                    --l3;
                }
                gridExtent.coordinates[i] = l /= (long)n3;
                gridExtent.coordinates[n4] = l + l3;
                continue;
            }
            if (n3 > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("periods", i), n3));
        }
        return Arrays.equals(this.coordinates, gridExtent.coordinates) ? this : gridExtent;
    }

    public GridExtent upsample(int ... nArray) {
        ArgumentChecks.ensureNonNull("periods", nArray);
        int n = this.getDimension();
        int n2 = Math.min(n, nArray.length);
        GridExtent gridExtent = new GridExtent(this);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 > 1) {
                int n4 = i + n;
                gridExtent.coordinates[i] = Math.multiplyExact(this.coordinates[i], (long)n3);
                gridExtent.coordinates[n4] = Math.addExact(Math.multiplyExact(this.coordinates[n4], (long)n3), (long)(n3 - 1));
                continue;
            }
            if (n3 > 0) continue;
            throw new IllegalArgumentException(Errors.format((short)165, Strings.toIndexed("periods", i), n3));
        }
        return Arrays.equals(this.coordinates, gridExtent.coordinates) ? this : gridExtent;
    }

    final GridExtent sliceByRatio(DirectPosition directPosition, double d, int[] nArray) {
        int n = directPosition.getDimension();
        while (--n >= 0) {
            directPosition.setOrdinate(n, d * this.getSize(n, true) + (double)this.getLow(n));
        }
        for (n = 0; n < nArray.length; ++n) {
            directPosition.setOrdinate(nArray[n], Double.NaN);
        }
        return this.slice(directPosition, null);
    }

    final GridExtent slice(DirectPosition directPosition, int[] nArray) {
        GridExtent gridExtent = new GridExtent(this);
        int n = directPosition.getDimension();
        int n2 = this.getDimension();
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (Double.isNaN(d)) continue;
            long l = Math.round(d);
            int n3 = nArray != null ? nArray[i] : i;
            long l2 = this.coordinates[n3];
            long l3 = this.coordinates[n3 + n2];
            if (l >= l2 && l <= l3) {
                gridExtent.coordinates[n3 + n2] = gridExtent.coordinates[n3] = l;
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                if (j != 0) {
                    stringBuilder.append(", ");
                }
                if (Double.isNaN(d = directPosition.getOrdinate(j))) {
                    stringBuilder.append("NaN");
                    continue;
                }
                stringBuilder.append(Math.round(d));
            }
            throw new PointOutsideCoverageException(Resources.format((short)21, this.getAxisIdentification(n3, i), l2, l3, stringBuilder.toString()));
        }
        return Arrays.equals(this.coordinates, gridExtent.coordinates) ? this : gridExtent;
    }

    final MatrixSIS cornerToCRS(Envelope envelope, long l, int[] nArray) {
        int n = this.getDimension();
        int n2 = envelope.getDimension();
        MatrixSIS matrixSIS = Matrices.create((int)(n2 + 1), (int)(n + 1), (Number[])ExtendedPrecisionMatrix.ZERO);
        DoubleDouble doubleDouble = new DoubleDouble();
        DoubleDouble doubleDouble2 = new DoubleDouble();
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = n3 = nArray != null ? nArray[i] : i;
            if (n3 < n) {
                boolean bl = (l & Numerics.bitmask(i)) != 0L;
                doubleDouble2.set(this.coordinates[n3]);
                doubleDouble.set(this.coordinates[n3 + n]);
                doubleDouble.subtract(doubleDouble2);
                doubleDouble.add(1.0);
                doubleDouble.inverseDivideGuessError(envelope.getSpan(i));
                if (bl) {
                    doubleDouble.negate();
                }
                if (!doubleDouble2.isZero()) {
                    doubleDouble2.multiply(doubleDouble);
                    doubleDouble2.negate();
                }
                doubleDouble2.addGuessError(bl ? envelope.getMaximum(i) : envelope.getMinimum(i));
                matrixSIS.setNumber(i, n, (Number)doubleDouble2);
            } else {
                doubleDouble.value = Double.NaN;
                doubleDouble.error = Double.NaN;
            }
            matrixSIS.setNumber(i, n3, (Number)doubleDouble);
        }
        matrixSIS.setElement(n2, n, 1.0);
        return matrixSIS;
    }

    public GridExtent translate(long ... lArray) {
        ArgumentChecks.ensureNonNull("translation", lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        if (!GridExtent.isZero(lArray, n2)) {
            GridExtent gridExtent = new GridExtent(this);
            long[] lArray2 = gridExtent.coordinates;
            for (int i = 0; i < n2; ++i) {
                int n3 = i + n;
                long l = lArray[i];
                lArray2[i] = Math.addExact(lArray2[i], l);
                lArray2[n3] = Math.addExact(lArray2[n3], l);
            }
            return gridExtent;
        }
        return this;
    }

    public boolean contains(long ... lArray) {
        ArgumentChecks.ensureNonNull("indices", lArray);
        int n = this.getDimension();
        int n2 = Math.min(n, lArray.length);
        for (int i = 0; i < n2; ++i) {
            long l = lArray[i];
            if (l >= this.coordinates[i] && l <= this.coordinates[i + n]) continue;
            return false;
        }
        return true;
    }

    public GridExtent intersect(GridExtent gridExtent) {
        return this.combine(gridExtent, false);
    }

    public GridExtent union(GridExtent gridExtent) {
        return this.combine(gridExtent, true);
    }

    private GridExtent combine(GridExtent gridExtent, boolean bl) {
        int n;
        int n2 = this.coordinates.length;
        int n3 = n2 >>> 1;
        if (n2 != gridExtent.coordinates.length) {
            throw new MismatchedDimensionException(Errors.format((short)81, "other", n3, gridExtent.getDimension()));
        }
        if (this.types != gridExtent.types && this.types != null && gridExtent.types != null) {
            for (int i = 0; i < n3; ++i) {
                DimensionNameType dimensionNameType;
                DimensionNameType dimensionNameType2 = this.types[i];
                if (dimensionNameType2 == null || (dimensionNameType = gridExtent.types[i]) == null || dimensionNameType2.equals((Object)dimensionNameType)) continue;
                throw new IllegalArgumentException(Errors.format((short)200, i, dimensionNameType2, dimensionNameType));
            }
        }
        long[] lArray = new long[n2];
        for (n = 0; n < n3; ++n) {
            lArray[n] = GridExtent.extremum(this.coordinates[n], gridExtent.coordinates[n], !bl);
        }
        while (n < n2) {
            lArray[n] = GridExtent.extremum(this.coordinates[n], gridExtent.coordinates[n], bl);
            ++n;
        }
        if (Arrays.equals(lArray, this.coordinates)) {
            return this;
        }
        if (Arrays.equals(lArray, gridExtent.coordinates)) {
            return gridExtent;
        }
        if (!bl) {
            for (n = 0; n < n3; ++n) {
                if (lArray[n] <= lArray[n + n3]) continue;
                throw new DisjointExtentException(this, gridExtent, n);
            }
        }
        return new GridExtent(this, lArray);
    }

    private static long extremum(long l, long l2, boolean bl) {
        return bl ? Math.max(l, l2) : Math.min(l, l2);
    }

    final boolean isSameSize(GridExtent gridExtent) {
        if (gridExtent == null || this.coordinates.length != gridExtent.coordinates.length) {
            return false;
        }
        int n = this.getDimension();
        long[] lArray = gridExtent.coordinates;
        for (int i = 0; i < n; ++i) {
            if (this.coordinates[i + n] - this.coordinates[i] == lArray[i + n] - lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridExtent) {
            GridExtent gridExtent = (GridExtent)object;
            if (Arrays.equals(this.coordinates, gridExtent.coordinates)) {
                switch (comparisonMode) {
                    case STRICT: {
                        if (!this.getClass().equals(object.getClass())) {
                            return false;
                        }
                    }
                    case BY_CONTRACT: {
                        if (Arrays.equals(this.types, gridExtent.types)) break;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) + Arrays.hashCode(this.types) ^ 0xD838F82F;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        try {
            this.appendTo(stringBuilder, Vocabulary.getResources((Locale)null));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return stringBuilder.toString();
    }

    final void appendTo(Appendable appendable, Vocabulary vocabulary) throws IOException {
        TableAppender tableAppender = new TableAppender(appendable, "");
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            InternationalString internationalString;
            String string = null;
            if (this.types != null && (internationalString = Types.getCodeTitle(this.types[i])) != null) {
                string = internationalString.toString(vocabulary.getLocale());
            }
            if (string == null) {
                string = vocabulary.getString((short)64, i);
            }
            long l = this.coordinates[i];
            long l2 = this.coordinates[i + n];
            tableAppender.setCellAlignment((byte)-1);
            tableAppender.append(string).append(": ").nextColumn();
            tableAppender.append('[').nextColumn();
            tableAppender.setCellAlignment((byte)1);
            tableAppender.append(Long.toString(l)).append(" \u2026 ").nextColumn();
            tableAppender.append(Long.toString(l2)).append("] ").nextColumn();
            tableAppender.append('(').append(vocabulary.getString((short)22, GridExtent.toSizeString(l2 - l + 1L))).append(')').nextLine();
        }
        tableAppender.flush();
    }

    static String toSizeString(long l) {
        return l != 0L ? Long.toUnsignedString(l) : "2\u2076\u2074";
    }

    static {
        HashMap<AxisDirection, DimensionNameType> hashMap = new HashMap<AxisDirection, DimensionNameType>(6);
        hashMap.put(AxisDirection.COLUMN_POSITIVE, DimensionNameType.COLUMN);
        hashMap.put(AxisDirection.ROW_POSITIVE, DimensionNameType.ROW);
        hashMap.put(AxisDirection.UP, DimensionNameType.VERTICAL);
        hashMap.put(AxisDirection.FUTURE, DimensionNameType.TIME);
        AXIS_DIRECTIONS = hashMap;
        DEFAULT_TYPES = new DimensionNameType[]{DimensionNameType.COLUMN, DimensionNameType.ROW};
        POOL = new WeakValueHashMap(DimensionNameType[].class);
    }
}

