/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.measure.Quantity;
import org.apache.sis.coverage.RegionOfInterest;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.ConvertedGridCoverage;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.ResampledGridCoverage;
import org.apache.sis.coverage.grid.TranslatedGridCoverage;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.internal.util.FinalFieldSetter;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridCoverageProcessor
implements Cloneable {
    private static final WeakHashSet<ImageProcessor> PROCESSORS = new WeakHashSet<ImageProcessor>(ImageProcessor.class);
    protected final ImageProcessor imageProcessor;
    protected final EnumSet<Optimization> optimizations = EnumSet.allOf(Optimization.class);

    static ImageProcessor unique(ImageProcessor imageProcessor) {
        return PROCESSORS.unique(imageProcessor);
    }

    public GridCoverageProcessor() {
        this.imageProcessor = new ImageProcessor();
    }

    public GridCoverageProcessor(ImageProcessor imageProcessor) {
        ArgumentChecks.ensureNonNull("processor", imageProcessor);
        this.imageProcessor = imageProcessor.clone();
    }

    public Interpolation getInterpolation() {
        return this.imageProcessor.getInterpolation();
    }

    public void setInterpolation(Interpolation interpolation) {
        this.imageProcessor.setInterpolation(interpolation);
    }

    public Quantity<?>[] getPositionalAccuracyHints() {
        return this.imageProcessor.getPositionalAccuracyHints();
    }

    public void setPositionalAccuracyHints(Quantity<?> ... quantityArray) {
        this.imageProcessor.setPositionalAccuracyHints(quantityArray);
    }

    public synchronized Set<Optimization> getOptimizations() {
        return this.optimizations.clone();
    }

    public synchronized void setOptimizations(Set<Optimization> set) {
        ArgumentChecks.ensureNonNull("enabled", set);
        this.optimizations.clear();
        this.optimizations.addAll(set);
    }

    public Number[] getFillValues() {
        return this.imageProcessor.getFillValues();
    }

    public void setFillValues(Number ... numberArray) {
        this.imageProcessor.setFillValues(numberArray);
    }

    public GridCoverage mask(GridCoverage gridCoverage, RegionOfInterest regionOfInterest, boolean bl) throws TransformException {
        ArgumentChecks.ensureNonNull("source", gridCoverage);
        ArgumentChecks.ensureNonNull("mask", regionOfInterest);
        Shape shape = regionOfInterest.toShape2D(gridCoverage.getGridGeometry());
        RenderedImage renderedImage = gridCoverage.render(null);
        renderedImage = this.imageProcessor.mask(renderedImage, shape, bl);
        return new GridCoverage2D(gridCoverage, renderedImage);
    }

    public GridCoverage convert(GridCoverage gridCoverage, MathTransform1D[] mathTransform1DArray, Function<SampleDimension.Builder, SampleDimension> function) {
        ArgumentChecks.ensureNonNull("source", gridCoverage);
        ArgumentChecks.ensureNonNull("converters", mathTransform1DArray);
        List<SampleDimension> list = gridCoverage.getSampleDimensions();
        ArgumentChecks.ensureSizeBetween("converters", 1, list.size(), mathTransform1DArray.length);
        SampleDimension[] sampleDimensionArray = new SampleDimension[mathTransform1DArray.length];
        SampleDimension.Builder builder = new SampleDimension.Builder();
        if (function == null) {
            function = SampleDimension.Builder::build;
        }
        for (int i = 0; i < mathTransform1DArray.length; ++i) {
            MathTransform1D mathTransform1D = mathTransform1DArray[i];
            ArgumentChecks.ensureNonNullElement("converters", i, mathTransform1D);
            SampleDimension sampleDimension = list.get(i);
            sampleDimension.getBackground().ifPresent(builder::setBackground);
            sampleDimension.getCategories().forEach(category -> {
                if (category.isQuantitative()) {
                    builder.addQuantitative((CharSequence)category.getName(), category.getSampleRange(), mathTransform1D, null);
                } else {
                    builder.addQualitative((CharSequence)category.getName(), category.getSampleRange());
                }
            });
            sampleDimensionArray[i] = function.apply(builder.setName(sampleDimension.getName())).forConvertedValues(true);
            builder.clear();
        }
        return new ConvertedGridCoverage(gridCoverage, UnmodifiableArrayList.wrap(sampleDimensionArray), mathTransform1DArray, true, GridCoverageProcessor.unique(this.imageProcessor), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage shiftGrid(GridCoverage gridCoverage, long ... lArray) {
        boolean bl;
        ArgumentChecks.ensureNonNull("source", gridCoverage);
        ArgumentChecks.ensureNonNull("translation", lArray);
        GridCoverageProcessor gridCoverageProcessor = this;
        synchronized (gridCoverageProcessor) {
            bl = this.optimizations.contains((Object)Optimization.REPLACE_SOURCE);
        }
        return TranslatedGridCoverage.create(gridCoverage, null, lArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage resample(GridCoverage gridCoverage, GridGeometry gridGeometry) throws TransformException {
        GridCoverage gridCoverage2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        ArgumentChecks.ensureNonNull("source", gridCoverage);
        ArgumentChecks.ensureNonNull("target", gridGeometry);
        GridCoverageProcessor gridCoverageProcessor = this;
        synchronized (gridCoverageProcessor) {
            bl3 = this.optimizations.contains((Object)Optimization.REPLACE_SOURCE);
            bl2 = this.optimizations.contains((Object)Optimization.REPLACE_OPERATION);
        }
        boolean bl4 = bl = gridCoverage == gridCoverage.forConvertedValues(true);
        while (true) {
            if (ResampledGridCoverage.equivalent(gridCoverage.getGridGeometry(), gridGeometry)) {
                return gridCoverage;
            }
            if (!bl3 || !(gridCoverage instanceof DerivedGridCoverage) || ((DerivedGridCoverage)(gridCoverage2 = (DerivedGridCoverage)gridCoverage)).IsNotRepleacable()) break;
            gridCoverage = ((DerivedGridCoverage)gridCoverage2).source;
        }
        if (!Interpolation.NEAREST.equals(this.imageProcessor.getInterpolation())) {
            gridCoverage = gridCoverage.forConvertedValues(true);
        }
        try {
            gridCoverage2 = ResampledGridCoverage.create(gridCoverage, gridGeometry, this.imageProcessor, bl2);
        }
        catch (IllegalGridGeometryException illegalGridGeometryException) {
            Throwable throwable = illegalGridGeometryException.getCause();
            if (throwable instanceof TransformException) {
                throw (TransformException)throwable;
            }
            throw illegalGridGeometryException;
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
        }
        return gridCoverage2.forConvertedValues(bl);
    }

    public GridCoverage resample(GridCoverage gridCoverage, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        ArgumentChecks.ensureNonNull("target", coordinateReferenceSystem);
        return this.resample(gridCoverage, new GridGeometry(null, PixelInCell.CELL_CENTER, null, coordinateReferenceSystem));
    }

    static void recoverableException(String string, Exception exception) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.raster"), GridCoverageProcessor.class, string, exception);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GridCoverageProcessor gridCoverageProcessor = (GridCoverageProcessor)object;
            return this.imageProcessor.equals(gridCoverageProcessor.imageProcessor);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.imageProcessor);
    }

    public GridCoverageProcessor clone() {
        try {
            GridCoverageProcessor gridCoverageProcessor = (GridCoverageProcessor)super.clone();
            FinalFieldSetter.set(GridCoverageProcessor.class, "imageProcessor", gridCoverageProcessor, this.imageProcessor.clone());
            return gridCoverageProcessor;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw FinalFieldSetter.cloneFailure(reflectiveOperationException);
        }
    }

    public static enum Optimization {
        REPLACE_OPERATION,
        REPLACE_SOURCE;

    }
}

