/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.referencing.DirectPositionView;
import org.apache.sis.internal.referencing.WraparoundAxesFinder;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

class DefaultEvaluator
implements GridCoverage.Evaluator {
    private final GridCoverage coverage;
    private CoordinateReferenceSystem inputCRS;
    private MathTransform inputToGrid;
    private FractionalGridCoordinates.Position position;
    double[] values;
    private boolean nullIfOutside;
    private long wraparoundAxes;
    private double[] wraparoundExtent;
    private MathTransform gridToWraparound;
    private double[] periods;
    private Map<Integer, Long> slice;

    protected DefaultEvaluator(GridCoverage gridCoverage) {
        ArgumentChecks.ensureNonNull("coverage", gridCoverage);
        this.coverage = gridCoverage;
    }

    @Override
    public GridCoverage getCoverage() {
        return this.coverage;
    }

    @Override
    public Map<Integer, Long> getDefaultSlice() {
        if (this.slice == null) {
            GridExtent gridExtent = this.coverage.getGridGeometry().getExtent();
            this.slice = CollectionsExt.unmodifiableOrCopy(gridExtent.getSliceCoordinates());
        }
        return this.slice;
    }

    @Override
    public void setDefaultSlice(Map<Integer, Long> map) {
        if (!Objects.equals(this.slice, map)) {
            if (map != null) {
                map = CollectionsExt.unmodifiableOrCopy(new TreeMap<Integer, Long>(map));
                GridExtent gridExtent = this.coverage.getGridGeometry().getExtent();
                int n = gridExtent.getDimension() - 1;
                for (Map.Entry<Integer, Long> entry : map.entrySet()) {
                    int n2 = entry.getKey();
                    ArgumentChecks.ensureBetween("slice.key", 0, n, n2);
                    ArgumentChecks.ensureBetween(gridExtent.getAxisIdentification(n2, n2).toString(), gridExtent.getLow(n2), gridExtent.getHigh(n2), entry.getValue());
                }
            }
            this.slice = map;
            this.inputCRS = null;
            this.inputToGrid = null;
        }
    }

    @Override
    public boolean isWraparoundEnabled() {
        return this.wraparoundAxes != 0L;
    }

    @Override
    public void setWraparoundEnabled(boolean bl) {
        this.wraparoundAxes = 0L;
        if (bl) {
            try {
                WraparoundAxesFinder wraparoundAxesFinder = new WraparoundAxesFinder(this.coverage.getCoordinateReferenceSystem());
                this.periods = wraparoundAxesFinder.periods();
                if (this.periods != null) {
                    int n;
                    GridGeometry gridGeometry = this.coverage.getGridGeometry();
                    GridExtent gridExtent = gridGeometry.getExtent();
                    MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                    this.gridToWraparound = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)wraparoundAxesFinder.preferredToSpecified.inverse());
                    Matrix matrix = this.gridToWraparound.derivative((DirectPosition)new DirectPositionView.Double(gridExtent.getPointOfInterest(PixelInCell.CELL_CENTER)));
                    int n2 = this.periods.length;
                    while (--n2 >= 0) {
                        if (!(this.periods[n2] > 0.0)) continue;
                        int n3 = Math.min(matrix.getNumCol(), 64);
                        while (--n3 >= 0) {
                            if (matrix.getElement(n2, n3) == 0.0) continue;
                            this.wraparoundAxes |= 1L << n3;
                        }
                    }
                    this.wraparoundExtent = new double[Long.bitCount(this.wraparoundAxes) << 1];
                    long l = this.wraparoundAxes;
                    int n4 = 0;
                    do {
                        n = Long.numberOfTrailingZeros(l);
                        this.wraparoundExtent[n4++] = gridExtent.getLow(n);
                        this.wraparoundExtent[n4++] = gridExtent.getHigh(n);
                    } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    assert (this.wraparoundExtent.length == n4) : n4;
                }
            }
            catch (TransformException transformException) {
                DefaultEvaluator.recoverableException("setWraparoundEnabled", transformException);
            }
        }
    }

    @Override
    public boolean isNullIfOutside() {
        return this.nullIfOutside;
    }

    @Override
    public void setNullIfOutside(boolean bl) {
        this.nullIfOutside = bl;
    }

    @Override
    public double[] apply(DirectPosition directPosition) throws CannotEvaluateException {
        GridGeometry gridGeometry = this.coverage.gridGeometry;
        long[] lArray = new long[gridGeometry.getDimension()];
        Arrays.fill(lArray, 1L);
        try {
            FractionalGridCoordinates.Position position = this.toGridPosition(directPosition);
            try {
                GridExtent gridExtent = position.toExtent(gridGeometry.extent, lArray, this.nullIfOutside);
                if (gridExtent != null) {
                    return this.evaluate(this.coverage.render(gridExtent), 0, 0);
                }
            }
            catch (ArithmeticException | IndexOutOfBoundsException | DisjointExtentException runtimeException) {
                if (!this.nullIfOutside) {
                    throw (PointOutsideCoverageException)new PointOutsideCoverageException(position.pointOutsideCoverage(gridGeometry.extent)).initCause(runtimeException);
                }
            }
        }
        catch (PointOutsideCoverageException pointOutsideCoverageException) {
            throw pointOutsideCoverageException;
        }
        catch (RuntimeException | TransformException | FactoryException throwable) {
            throw new CannotEvaluateException(throwable.getMessage(), throwable);
        }
        return null;
    }

    final double[] evaluate(RenderedImage renderedImage, int n, int n2) {
        int n3 = ImageUtilities.pixelToTileX(renderedImage, n);
        int n4 = ImageUtilities.pixelToTileY(renderedImage, n2);
        this.values = renderedImage.getTile(n3, n4).getPixel(n, n2, this.values);
        return this.values;
    }

    @Override
    public FractionalGridCoordinates toGridCoordinates(DirectPosition directPosition) throws TransformException {
        ArgumentChecks.ensureNonNull("point", directPosition);
        try {
            return new FractionalGridCoordinates(this.toGridPosition(directPosition));
        }
        catch (FactoryException factoryException) {
            throw new TransformException(factoryException.getMessage(), (Throwable)factoryException);
        }
    }

    final FractionalGridCoordinates.Position toGridPosition(DirectPosition directPosition) throws FactoryException, TransformException {
        block13: {
            double d;
            int n;
            long l;
            DirectPosition directPosition2;
            CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
            if (coordinateReferenceSystem != this.inputCRS || this.inputToGrid == null) {
                this.setInputCRS(coordinateReferenceSystem);
            }
            if ((directPosition2 = this.inputToGrid.transform(directPosition, (DirectPosition)this.position)) != this.position) {
                double[] dArray = this.position.coordinates;
                System.arraycopy(directPosition2.getCoordinate(), 0, dArray, 0, dArray.length);
            }
            if ((l = this.wraparoundAxes) == 0L) break block13;
            double[] dArray = this.position.coordinates;
            long l2 = 0L;
            int n2 = 0;
            do {
                block15: {
                    block14: {
                        double d2;
                        double d3;
                        if ((d3 = dArray[n = Long.numberOfTrailingZeros(l)]) < (d = this.wraparoundExtent[n2++])) break block14;
                        d = this.wraparoundExtent[n2];
                        if (!(d3 > d2)) break block15;
                    }
                    if (l2 == 0L) {
                        int n3 = dArray.length;
                        dArray = Arrays.copyOf(dArray, 2 * Math.max(n3, this.gridToWraparound.getTargetDimensions()));
                        System.arraycopy(dArray, 0, dArray, n3, n3);
                    }
                    dArray[n] = d;
                    l2 |= 1L << n;
                }
                ++n2;
            } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            assert (this.wraparoundExtent.length == n2) : n2;
            if (l2 != 0L) {
                double d4;
                this.gridToWraparound.transform(dArray, 0, dArray, 0, 2);
                n = this.gridToWraparound.getTargetDimensions();
                int n4 = this.periods.length;
                while (--n4 >= 0) {
                    d4 = this.periods[n4];
                    if (!(d4 > 0.0)) continue;
                    int n5 = n4 + n;
                    double d5 = dArray[n4] - dArray[n5];
                    d5 = Math.copySign(Math.ceil(Math.abs(d5) / d4), d5) * d4;
                    int n6 = n5;
                    dArray[n6] = dArray[n6] + d5;
                }
                this.gridToWraparound.inverse().transform(dArray, n, dArray, 0, 1);
                n2 = 0;
                do {
                    if (!((d4 = dArray[n4 = Long.numberOfTrailingZeros(l2)]) < this.wraparoundExtent[n2++])) {
                        int n7 = n2++;
                        if (!(d4 > this.wraparoundExtent[n7])) continue;
                    }
                    return this.position;
                } while ((l2 &= 1L << n4 ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                double[] dArray2 = this.position.coordinates;
                int n8 = dArray2.length;
                while (--n8 >= 0) {
                    d = dArray[n8];
                    if (Double.isNaN(d)) continue;
                    dArray2[n8] = d;
                }
            }
        }
        return this.position;
    }

    private void setInputCRS(CoordinateReferenceSystem coordinateReferenceSystem) throws FactoryException, NoninvertibleTransformException {
        GridGeometry gridGeometry = this.coverage.getGridGeometry();
        MathTransform mathTransform = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
        MathTransform mathTransform2 = mathTransform.inverse();
        if (coordinateReferenceSystem != null) {
            CoordinateReferenceSystem coordinateReferenceSystem2 = this.coverage.getCoordinateReferenceSystem();
            GeographicBoundingBox geographicBoundingBox = gridGeometry.geographicBBox();
            try {
                CoordinateOperation coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coordinateReferenceSystem2, (GeographicBoundingBox)geographicBoundingBox);
                mathTransform2 = MathTransforms.concatenate((MathTransform)coordinateOperation.getMathTransform(), (MathTransform)mathTransform2);
            }
            catch (FactoryException factoryException) {
                Map<Integer, Long> map = this.getDefaultSlice();
                try {
                    int n;
                    CoordinateOperation coordinateOperation = CRS.findOperation((CoordinateReferenceSystem)coordinateReferenceSystem2, (CoordinateReferenceSystem)coordinateReferenceSystem, (GeographicBoundingBox)geographicBoundingBox);
                    mathTransform = MathTransforms.concatenate((MathTransform)mathTransform, (MathTransform)coordinateOperation.getMathTransform());
                    TransformSeparator transformSeparator = new TransformSeparator(mathTransform);
                    int n2 = mathTransform.getTargetDimensions();
                    int n3 = mathTransform.getSourceDimensions();
                    int[] nArray = new int[n3];
                    int n4 = 0;
                    for (n = 0; n < n3; ++n) {
                        if (map.containsKey(n)) continue;
                        nArray[n4++] = n;
                    }
                    nArray = ArraysExt.resize(nArray, n4);
                    transformSeparator.addSourceDimensions(nArray);
                    transformSeparator.setSourceExpandable(true);
                    transformSeparator.addTargetDimensionRange(0, n2);
                    mathTransform = transformSeparator.separate();
                    mathTransform2 = mathTransform.inverse();
                    nArray = transformSeparator.getSourceDimensions();
                    n = nArray.length;
                    MatrixSIS matrixSIS = Matrices.createZero((int)(n3 + 1), (int)(n + 1));
                    matrixSIS.setElement(n3, n, 1.0);
                    n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        if (Arrays.binarySearch(nArray, i) >= 0) {
                            matrixSIS.setElement(i, n4++, 1.0);
                            continue;
                        }
                        Long l = map.get(i);
                        if (l == null) {
                            GridExtent gridExtent = gridGeometry.extent;
                            throw new FactoryException(Resources.format((short)50, n2, gridExtent.getAxisIdentification(i, i), gridExtent.getSize(i)));
                        }
                        matrixSIS.setElement(i, n, (double)l.longValue());
                    }
                    mathTransform2 = MathTransforms.concatenate((MathTransform)mathTransform2, (MathTransform)MathTransforms.linear((Matrix)matrixSIS));
                }
                catch (RuntimeException | NoninvertibleTransformException | FactoryException throwable) {
                    factoryException.addSuppressed(throwable);
                    throw factoryException;
                }
            }
        }
        this.position = new FractionalGridCoordinates.Position(mathTransform2.getTargetDimensions());
        this.inputCRS = coordinateReferenceSystem;
        this.inputToGrid = mathTransform2;
    }

    private static void recoverableException(String string, TransformException transformException) {
        Logging.recoverableException(Logger.getLogger("org.apache.sis.raster"), DefaultEvaluator.class, string, transformException);
    }
}

