/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.stream;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.apache.sis.internal.stream.PaginedDoubleStream;
import org.apache.sis.internal.stream.StreamWrapper;

public final class PaginedStream<T>
extends StreamWrapper<T> {
    private Stream<?> root;

    public PaginedStream(Stream<T> stream, Stream<?> stream2) {
        super(stream);
        this.root = stream2;
    }

    @Override
    public Stream<T> skip(long l) {
        this.root = this.root.skip(l);
        return this;
    }

    @Override
    public Stream<T> limit(long l) {
        this.root = this.root.limit(l);
        return this;
    }

    @Override
    public long count() {
        return this.root.count();
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return new PaginedDoubleStream(super.mapToDouble(toDoubleFunction), this.root);
    }

    @Override
    public Stream<T> distinct() {
        return this.delegate().distinct();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.delegate().unordered();
    }

    @Override
    public Stream<T> sorted() {
        return this.delegate().sorted();
    }

    @Override
    public Stream<T> sorted(Comparator<? super T> comparator) {
        return this.delegate().sorted(comparator);
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        return this.delegate().filter(predicate);
    }
}

