/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.metadata.sql.Syntax;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.TableReference;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

final class ExtentEstimator {
    private final Database database;
    private final TableReference table;
    private final Column[] columns;
    private final SQLBuilder builder;
    private GeneralEnvelope envelope;
    private TransformException error;

    ExtentEstimator(Database database, TableReference tableReference, Column[] columnArray) {
        this.database = database;
        this.table = tableReference;
        this.columns = columnArray;
        this.builder = new SQLBuilder((Syntax)database);
    }

    GeneralEnvelope estimate(Statement statement, boolean bl) throws SQLException {
        this.query(statement);
        if (this.envelope == null && !bl) {
            this.builder.append("ANALYZE ").appendIdentifier(this.table.catalog, this.table.schema, this.table.table);
            String string = this.builder.toString();
            this.builder.clear();
            statement.execute(string);
            this.query(statement);
        }
        if (this.error != null) {
            this.database.listeners.warning((Exception)this.error);
        }
        return this.envelope;
    }

    private void query(Statement statement) throws SQLException {
        block7: for (Column column : this.columns) {
            if (!column.getGeometryType().isPresent()) continue;
            this.database.appendFunctionCall(this.builder.append("SELECT "), "ST_EstimatedExtent");
            this.builder.append('(');
            if (this.table.schema != null) {
                this.builder.appendValue(this.table.schema).append(", ");
            }
            String string = this.builder.appendValue(this.table.table).append(", ").appendValue(column.name).append(')').toString();
            this.builder.clear();
            ResultSet resultSet = statement.executeQuery(string);
            block8: while (true) {
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1);
                    if (string2 == null) continue;
                    GeneralEnvelope generalEnvelope = new GeneralEnvelope((CharSequence)string2);
                    column.getDefaultCRS().ifPresent(arg_0 -> ((GeneralEnvelope)generalEnvelope).setCoordinateReferenceSystem(arg_0));
                    if (this.envelope == null) {
                        this.envelope = generalEnvelope;
                        continue;
                    }
                    try {
                        this.envelope.add(Envelopes.transform((Envelope)generalEnvelope, (CoordinateReferenceSystem)this.envelope.getCoordinateReferenceSystem()));
                        continue block8;
                    }
                    catch (TransformException transformException) {
                        if (this.error == null) {
                            this.error = transformException;
                            continue;
                        }
                        this.error.addSuppressed((Throwable)transformException);
                    }
                }
                continue block7;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }
}

