/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.postgis;

import java.awt.image.RasterFormatException;
import org.apache.sis.util.resources.Errors;

final class Band {
    private static final int IS_OFFLINE = 128;
    private static final int HAS_NODATA = 64;
    private static final int IS_NODATA = 32;
    private static final int PIXEL_TYPE = 15;
    final int header;
    Number noDataValue;
    Object data;
    static final int OPPOSITE_SIGN = 8;
    private static final byte[] PIXEL_TO_BUFFER_TYPE = new byte[]{0, 0, 0, 8, 0, 2, 1, 3, 11, 32, 4, 5};
    private static final byte[] BUFFER_TO_PIXEL_TYPE = new byte[8];
    private static final byte[] PIXEL_TYPE_TO_SIZE;
    private static final byte[] SIZE_TO_PIXEL_TYPE;

    Band(int n) {
        this.header = n;
    }

    Band(int n, Number number) {
        if (number != null) {
            n |= 0x40;
        }
        this.header = n;
        this.noDataValue = number;
    }

    private int getPixelType() {
        return this.header & 0xF;
    }

    final boolean isOffline() {
        return (this.header & 0x80) != 0;
    }

    final boolean hasNodata() {
        return (this.header & 0x40) != 0;
    }

    final boolean isNodata() {
        return (this.header & 0x20) != 0;
    }

    final boolean isUnsigned() {
        int n = this.getDataBufferType();
        return n == 0 || n == 1 || n == 11;
    }

    final int getDataBufferType() {
        int n = this.getPixelType();
        return n < PIXEL_TO_BUFFER_TYPE.length ? PIXEL_TO_BUFFER_TYPE[n] : 32;
    }

    static int bufferToPixelType(int n) {
        if (n >= 0 && n < BUFFER_TO_PIXEL_TYPE.length) {
            return BUFFER_TO_PIXEL_TYPE[n];
        }
        throw new RasterFormatException(Errors.format((short)163, n));
    }

    final int getDataTypeSize() {
        byte by;
        int n = this.getPixelType();
        if (n < PIXEL_TYPE_TO_SIZE.length && (by = PIXEL_TYPE_TO_SIZE[n]) != 0) {
            return by;
        }
        throw new RasterFormatException(Errors.format((short)163, n));
    }

    static int sizeToPixelType(int n) {
        if (n > 0) {
            int n2 = 31 - Integer.numberOfLeadingZeros(n);
            if (1 << n2 != n) {
                ++n2;
            }
            if (n2 >= 0 && n2 < SIZE_TO_PIXEL_TYPE.length) {
                return SIZE_TO_PIXEL_TYPE[n2];
            }
        }
        throw new RasterFormatException(Errors.format((short)45, "size", n));
    }

    final float[] toNaN(float[] fArray) {
        if (this.noDataValue != null) {
            float f = this.noDataValue.floatValue();
            if (!Float.isNaN(f)) {
                for (int i = 0; i < fArray.length; ++i) {
                    if (fArray[i] != f) continue;
                    fArray[i] = Float.NaN;
                }
            }
            this.noDataValue = null;
        }
        return fArray;
    }

    final double[] toNaN(double[] dArray) {
        if (this.noDataValue != null) {
            double d = this.noDataValue.doubleValue();
            if (!Double.isNaN(d)) {
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] != d) continue;
                    dArray[i] = Double.NaN;
                }
            }
            this.noDataValue = null;
        }
        return dArray;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("WKB Raster Band:");
        stringBuilder.append("\n- pixel type: ").append(this.getPixelType());
        stringBuilder.append("\n- is offline: ").append(this.isOffline());
        stringBuilder.append("\n- has nodata: ").append(this.hasNodata());
        stringBuilder.append("\n- is no data: ").append(this.isNodata());
        stringBuilder.append("\n- nodata val: ").append(this.noDataValue);
        return stringBuilder.toString();
    }

    static {
        Band.BUFFER_TO_PIXEL_TYPE[0] = 4;
        Band.BUFFER_TO_PIXEL_TYPE[1] = 6;
        Band.BUFFER_TO_PIXEL_TYPE[2] = 5;
        Band.BUFFER_TO_PIXEL_TYPE[3] = 7;
        Band.BUFFER_TO_PIXEL_TYPE[4] = 10;
        Band.BUFFER_TO_PIXEL_TYPE[5] = 11;
        PIXEL_TYPE_TO_SIZE = new byte[]{1, 2, 4, 8, 8, 16, 16, 32, 32, 0, 32, 64};
        SIZE_TO_PIXEL_TYPE = new byte[]{0, 1, 2, 4, 6, 8};
    }
}

