/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.internal.filter.Visitor;
import org.apache.sis.internal.geoapi.filter.BetweenComparisonOperator;
import org.apache.sis.internal.geoapi.filter.BinaryComparisonOperator;
import org.apache.sis.internal.geoapi.filter.ComparisonOperatorName;
import org.apache.sis.internal.geoapi.filter.Literal;
import org.apache.sis.internal.geoapi.filter.LogicalOperator;
import org.apache.sis.internal.geoapi.filter.LogicalOperatorName;
import org.apache.sis.internal.geoapi.filter.SpatialOperatorName;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.internal.sql.feature.Database;
import org.apache.sis.internal.sql.feature.SelectionClause;

public class SelectionClauseWriter
extends Visitor<AbstractFeature, SelectionClause> {
    protected static final SelectionClauseWriter DEFAULT = new SelectionClauseWriter();

    private SelectionClauseWriter() {
        this.setFilterHandler(LogicalOperatorName.AND, new Logic(" AND ", false));
        this.setFilterHandler(LogicalOperatorName.OR, new Logic(" OR ", false));
        this.setFilterHandler(LogicalOperatorName.NOT, new Logic("NOT ", true));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_EQUAL_TO, new Comparison(" = "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_NOT_EQUAL_TO, new Comparison(" <> "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN, new Comparison(" > "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_GREATER_THAN_OR_EQUAL_TO, new Comparison(" >= "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_LESS_THAN, new Comparison(" < "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_LESS_THAN_OR_EQUAL_TO, new Comparison(" <= "));
        this.setFilterHandler(ComparisonOperatorName.PROPERTY_IS_BETWEEN, (filter, selectionClause) -> {
            BetweenComparisonOperator betweenComparisonOperator = (BetweenComparisonOperator)filter;
            if (this.write((SelectionClause)((Object)selectionClause), betweenComparisonOperator.getExpression())) {
                return;
            }
            selectionClause.append(" BETWEEN ");
            if (this.write((SelectionClause)((Object)selectionClause), betweenComparisonOperator.getLowerBoundary())) {
                return;
            }
            selectionClause.append(" AND ");
            this.write((SelectionClause)((Object)selectionClause), betweenComparisonOperator.getUpperBoundary());
        });
        this.setNullAndNilHandlers((filter, selectionClause) -> {
            List list = filter.getExpressions();
            if (list.size() == 1) {
                this.write((SelectionClause)((Object)selectionClause), list.get(0));
                selectionClause.append(" IS NULL");
            } else {
                selectionClause.invalidate();
            }
        });
        this.setFilterHandler(SpatialOperatorName.CONTAINS, new Function("ST_Contains"));
        this.setFilterHandler(SpatialOperatorName.CROSSES, new Function("ST_Crosses"));
        this.setFilterHandler(SpatialOperatorName.DISJOINT, new Function("ST_Disjoint"));
        this.setFilterHandler(SpatialOperatorName.EQUALS, new Function("ST_Equals"));
        this.setFilterHandler(SpatialOperatorName.INTERSECTS, new Function("ST_Intersects"));
        this.setFilterHandler(SpatialOperatorName.OVERLAPS, new Function("ST_Overlaps"));
        this.setFilterHandler(SpatialOperatorName.TOUCHES, new Function("ST_Touches"));
        this.setFilterHandler(SpatialOperatorName.WITHIN, new Function("ST_Within"));
        this.setExpressionHandler("Add", new Arithmetic(" + "));
        this.setExpressionHandler("Subtract", new Arithmetic(" - "));
        this.setExpressionHandler("Divide", new Arithmetic(" / "));
        this.setExpressionHandler("Multiply", new Arithmetic(" * "));
        this.setExpressionHandler("Literal", (expression, selectionClause) -> selectionClause.appendLiteral(((Literal)expression).getValue()));
        this.setExpressionHandler("ValueReference", (expression, selectionClause) -> selectionClause.appendColumnName((ValueReference)expression));
        this.setExpressionHandler("PropertyName", this.getExpressionHandler("ValueReference"));
    }

    protected SelectionClauseWriter(SelectionClauseWriter selectionClauseWriter) {
        super(selectionClauseWriter, true, false);
    }

    protected SelectionClauseWriter duplicate() {
        return new SelectionClauseWriter(this);
    }

    final SelectionClauseWriter removeUnsupportedFunctions(Database<?> database) {
        Object object;
        HashMap<String, SpatialOperatorName> hashMap = new HashMap<String, SpatialOperatorName>();
        try {
            object = database.source.getConnection();
            try {
                DatabaseMetaData databaseMetaData = object.getMetaData();
                boolean bl = databaseMetaData.storesLowerCaseIdentifiers();
                boolean bl2 = databaseMetaData.storesUpperCaseIdentifiers();
                for (SpatialOperatorName spatialOperatorName : SpatialOperatorName.values()) {
                    BiConsumer biConsumer = this.getFilterHandler(spatialOperatorName);
                    if (!(biConsumer instanceof Function)) continue;
                    String string = ((Function)biConsumer).name;
                    if (bl) {
                        string = string.toLowerCase(Locale.US);
                    }
                    if (bl2) {
                        string = string.toUpperCase(Locale.US);
                    }
                    hashMap.put(string, spatialOperatorName);
                }
                String string = (bl ? "st_%" : "ST\\_%").replace("\\", databaseMetaData.getSearchStringEscape());
                try (ResultSet resultSet = databaseMetaData.getFunctions(database.catalogOfSpatialTables, database.schemaOfSpatialTables, string);){
                    while (resultSet.next()) {
                        hashMap.remove(resultSet.getString("FUNCTION_NAME"));
                    }
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (SQLException sQLException) {
            database.listeners.warning((Exception)sQLException);
        }
        if (hashMap.isEmpty()) {
            return this;
        }
        object = this.duplicate();
        ((Visitor)object).removeFilterHandlers(hashMap.values());
        return object;
    }

    @Override
    protected final void typeNotFound(Enum<?> enum_, Filter<AbstractFeature> filter, SelectionClause selectionClause) {
        selectionClause.invalidate();
    }

    @Override
    protected final void typeNotFound(String string, Expression<AbstractFeature, ?> expression, SelectionClause selectionClause) {
        selectionClause.invalidate();
    }

    final boolean write(SelectionClause selectionClause, Filter<? super AbstractFeature> filter) {
        this.visit(filter, selectionClause);
        return selectionClause.isInvalid;
    }

    private boolean write(SelectionClause selectionClause, Expression<? super AbstractFeature, ?> expression) {
        this.visit(expression, selectionClause);
        return selectionClause.isInvalid;
    }

    protected final void writeBinaryOperator(SelectionClause selectionClause, Filter<AbstractFeature> filter, String string) {
        this.writeParameters(selectionClause, filter.getExpressions(), string, true);
    }

    private void writeParameters(SelectionClause selectionClause, List<Expression<? super AbstractFeature, ?>> list, String string, boolean bl) {
        int n = list.size();
        if (bl && n != 2) {
            selectionClause.invalidate();
            return;
        }
        selectionClause.append('(');
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                selectionClause.append(string);
            }
            if (!this.write(selectionClause, list.get(i))) continue;
            return;
        }
        selectionClause.append(')');
    }

    private final class Logic
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;
        private final boolean unary;

        Logic(String string, boolean bl) {
            this.operator = string;
            this.unary = bl;
        }

        @Override
        public void accept(Filter<AbstractFeature> filter, SelectionClause selectionClause) {
            LogicalOperator logicalOperator = (LogicalOperator)filter;
            List list = logicalOperator.getOperands();
            int n = list.size();
            if (this.unary ? n != 1 : n == 0) {
                selectionClause.invalidate();
            } else {
                if (this.unary) {
                    selectionClause.append(this.operator);
                }
                selectionClause.append('(');
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        selectionClause.append(this.operator);
                    }
                    if (!SelectionClauseWriter.this.write(selectionClause, list.get(i))) continue;
                    return;
                }
                selectionClause.append(')');
            }
        }
    }

    private final class Comparison
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        private final String operator;

        Comparison(String string) {
            this.operator = string;
        }

        @Override
        public void accept(Filter<AbstractFeature> filter, SelectionClause selectionClause) {
            BinaryComparisonOperator binaryComparisonOperator = (BinaryComparisonOperator)filter;
            if (binaryComparisonOperator.isMatchingCase()) {
                SelectionClauseWriter.this.writeBinaryOperator(selectionClause, binaryComparisonOperator, this.operator);
            } else {
                selectionClause.invalidate();
            }
        }
    }

    private final class Function
    implements BiConsumer<Filter<AbstractFeature>, SelectionClause> {
        final String name;

        Function(String string) {
            this.name = string;
        }

        @Override
        public void accept(Filter<AbstractFeature> filter, SelectionClause selectionClause) {
            selectionClause.append(this.name);
            SelectionClauseWriter.this.writeParameters(selectionClause, filter.getExpressions(), ", ", false);
        }
    }

    private final class Arithmetic
    implements BiConsumer<Expression<AbstractFeature, ?>, SelectionClause> {
        private final String operator;

        Arithmetic(String string) {
            this.operator = string;
        }

        @Override
        public void accept(Expression<AbstractFeature, ?> expression, SelectionClause selectionClause) {
            SelectionClauseWriter.this.writeParameters(selectionClause, expression.getParameters(), this.operator, true);
        }
    }
}

