/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Filter;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.SelectionClauseWriter;
import org.apache.sis.internal.sql.feature.Table;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class SelectionClause
extends SQLBuilder {
    private final Table table;
    boolean isInvalid;

    SelectionClause(Table table) {
        super(table.database);
        this.table = table;
    }

    final void appendColumnName(ValueReference<AbstractFeature, ?> valueReference) {
        Column column = this.table.getColumn(valueReference.getXPath());
        if (column != null) {
            this.appendIdentifier(column.name);
        } else {
            this.invalidate();
        }
    }

    final void appendLiteral(Object object) {
        if (object instanceof GeographicBoundingBox) {
            this.appendGeometry(null, (Envelope)new GeneralEnvelope((GeographicBoundingBox)object));
        } else if (object instanceof Envelope) {
            this.appendGeometry(null, (Envelope)object);
        } else if (object instanceof Geometry) {
            this.appendGeometry(Geometries.wrap((Geometry)object).orElse(null), null);
        } else {
            this.appendValue(object);
        }
    }

    private void appendGeometry(GeometryWrapper<?> geometryWrapper, Envelope envelope) {
        Object object;
        if (envelope == null) {
            if (geometryWrapper == null) {
                this.invalidate();
                return;
            }
            envelope = geometryWrapper.getEnvelope();
        }
        if (envelope.getDimension() < 2) {
            this.invalidate();
            return;
        }
        double d = (envelope.getSpan(0) + envelope.getSpan(1)) / 2.0;
        if (Double.isNaN(d)) {
            object = new GeneralEnvelope(envelope);
            for (int i = 0; i < 2; ++i) {
                double d2 = SelectionClause.clampInfinity(object.getLower(i));
                double d3 = SelectionClause.clampInfinity(object.getUpper(i));
                if (Double.isNaN(d2) || Double.isNaN(d3)) {
                    this.invalidate();
                    return;
                }
                object.setRange(i, d2, d3);
            }
            envelope = object;
        }
        if (geometryWrapper == null) {
            geometryWrapper = this.table.database.geomLibrary.toGeometry2D(envelope, WraparoundMethod.SPLIT);
        }
        object = geometryWrapper.formatWKT(0.05 * d);
        this.append("ST_GeomFromText(").appendValue((String)object).append(')');
    }

    private static double clampInfinity(double d) {
        if (d == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        return d;
    }

    final void invalidate() {
        this.isInvalid = true;
    }

    final boolean tryAppend(SelectionClauseWriter selectionClauseWriter, Filter<? super AbstractFeature> filter) {
        int n = this.buffer.length();
        if (n != 0) {
            this.buffer.append(" AND ");
        }
        if (selectionClauseWriter.write(this, filter)) {
            this.buffer.setLength(n);
            this.isInvalid = false;
            return false;
        }
        return true;
    }
}

