/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.internal.filter.SortByComparator;
import org.apache.sis.internal.geoapi.filter.SortBy;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.Column;
import org.apache.sis.internal.sql.feature.FeatureIterator;
import org.apache.sis.internal.sql.feature.SelectionClause;
import org.apache.sis.internal.sql.feature.SelectionClauseWriter;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.stream.DeferredStream;
import org.apache.sis.internal.stream.PaginedStream;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.BackingStoreException;

final class FeatureStream
extends DeferredStream<AbstractFeature> {
    private final Table table;
    private SelectionClauseWriter filterToSQL;
    private SelectionClause selection;
    private boolean hasPredicates;
    private boolean hasComparator;
    private boolean distinct;
    private SortBy<? super AbstractFeature> sort;
    private long offset;
    private long count;

    FeatureStream(Table table, boolean bl) {
        super(256, bl);
        this.table = table;
    }

    @Override
    private Stream<AbstractFeature> empty() {
        this.count = 0L;
        this.delegate();
        return Stream.empty();
    }

    private boolean isPagined() {
        return (this.offset | this.count) != 0L;
    }

    @Override
    public Stream<AbstractFeature> filter(Predicate<? super AbstractFeature> predicate) {
        ArgumentChecks.ensureNonNull("predicate", predicate);
        if (predicate == Filter.include()) {
            return this;
        }
        if (predicate == Filter.exclude()) {
            return this.empty();
        }
        if (this.isPagined()) {
            return this.delegate().filter(predicate);
        }
        if (!(predicate instanceof Filter)) {
            this.hasPredicates = true;
            return super.filter(predicate);
        }
        if (this.selection == null) {
            this.selection = new SelectionClause(this.table);
            this.filterToSQL = this.table.database.getFilterToSupportedSQL();
        }
        Optimization optimization = new Optimization();
        optimization.setFeatureType(this.table.featureType);
        Stream<AbstractFeature> stream = this;
        for (Filter filter : optimization.applyAndDecompose((Filter)predicate)) {
            if (filter == Filter.include()) continue;
            if (filter == Filter.exclude()) {
                return this.empty();
            }
            if (this.selection.tryAppend(this.filterToSQL, filter)) continue;
            stream = super.filter(filter);
            this.hasPredicates = true;
        }
        return stream;
    }

    @Override
    public Stream<AbstractFeature> distinct() {
        if (this.isPagined()) {
            return this.delegate().distinct();
        }
        this.distinct = true;
        return this;
    }

    @Override
    public Stream<AbstractFeature> unordered() {
        if (this.isPagined()) {
            return (Stream)this.delegate().unordered();
        }
        this.sort = null;
        return super.unordered();
    }

    @Override
    public Stream<AbstractFeature> sorted() {
        if (this.isPagined()) {
            return this.delegate().sorted();
        }
        return super.sorted();
    }

    @Override
    public Stream<AbstractFeature> sorted(Comparator<? super AbstractFeature> comparator) {
        if (this.isPagined() || this.hasComparator) {
            return this.delegate().sorted(comparator);
        }
        SortBy<? super AbstractFeature> sortBy = SortByComparator.concatenate(this.sort, comparator);
        if (sortBy != null) {
            this.sort = sortBy;
            return this;
        }
        this.hasComparator = true;
        return super.sorted(comparator);
    }

    @Override
    public Stream<AbstractFeature> skip(long l) {
        ArgumentChecks.ensurePositive("n", l);
        this.offset = Math.addExact(this.offset, l);
        if (this.count != 0L) {
            if (l >= this.count) {
                return this.empty();
            }
            this.count -= l;
        }
        return this;
    }

    @Override
    public Stream<AbstractFeature> limit(long l) {
        ArgumentChecks.ensurePositive("maxSize", l);
        if (l == 0L) {
            return this.empty();
        }
        this.count = this.count != 0L ? Math.min(this.count, l) : l;
        return this;
    }

    @Override
    public <R> Stream<R> map(Function<? super AbstractFeature, ? extends R> function) {
        return new PaginedStream<R>(super.map(function), this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long count() {
        Object object;
        if (this.hasPredicates) return super.count();
        if (this.count != 0L) {
            return super.count();
        }
        SQLBuilder sQLBuilder = new SQLBuilder(this.table.database).append("SELECT ").append("COUNT(");
        if (this.distinct) {
            object = "DISTINCT ";
            for (Column column : this.table.attributes) {
                sQLBuilder.append((String)object).appendIdentifier(column.label);
                object = ", ";
            }
        } else {
            sQLBuilder.appendIdentifier(this.table.attributes[0].label);
        }
        this.table.appendFromClause(sQLBuilder.append(')'));
        if (this.selection != null && !this.selection.isEmpty()) {
            sQLBuilder.append(" WHERE ").append(this.selection.toString());
        }
        try {
            object = this.getConnection();
            try {
                this.makeReadOnly((Connection)object);
                try (Statement statement = object.createStatement();
                     ResultSet resultSet = statement.executeQuery(sQLBuilder.toString());){
                    long l;
                    do {
                        if (!resultSet.next()) return Math.max(super.count() - this.offset, 0L);
                        l = resultSet.getLong(1);
                    } while (resultSet.wasNull());
                    long l2 = l;
                    return l2;
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (SQLException sQLException) {
            throw new BackingStoreException(sQLException);
        }
    }

    private Connection getConnection() throws SQLException {
        return this.table.database.source.getConnection();
    }

    private void makeReadOnly(Connection connection) throws SQLException {
        connection.setReadOnly(true);
    }

    @Override
    protected Spliterator<AbstractFeature> createSourceIterator() throws Exception {
        String string = this.selection != null && !this.selection.isEmpty() ? this.selection.toString() : null;
        this.selection = null;
        Connection connection = this.getConnection();
        this.setCloseHandler(connection);
        this.makeReadOnly(connection);
        FeatureIterator featureIterator = new FeatureIterator(this.table, connection, this.distinct, string, this.sort, this.offset, this.count);
        this.setCloseHandler(featureIterator);
        return featureIterator;
    }

    public String toString() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "table";
        objectArray[1] = this.table.name.table;
        objectArray[2] = "predicates";
        objectArray[3] = this.hasPredicates ? (this.filterToSQL != null ? "mixed" : "Java") : (this.filterToSQL != null ? "SQL" : null);
        objectArray[4] = "comparator";
        objectArray[5] = this.hasComparator ? (this.sort != null ? "mixed" : "Java") : (this.sort != null ? "SQL" : null);
        objectArray[6] = "distinct";
        objectArray[7] = this.distinct ? Boolean.TRUE : null;
        objectArray[8] = "offset";
        objectArray[9] = this.offset != 0L ? Long.valueOf(this.offset) : null;
        objectArray[10] = "count";
        objectArray[11] = this.count != 0L ? Long.valueOf(this.count) : null;
        return Strings.toString(this.getClass(), objectArray);
    }
}

