/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.distribution;

import java.util.Collection;
import javax.measure.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.gco.GO_Real;
import org.apache.sis.internal.jaxb.metadata.CI_Citation;
import org.apache.sis.internal.jaxb.metadata.MD_Identifier;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.internal.util.CodeLists;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.distribution.Medium;
import org.opengis.metadata.distribution.MediumFormat;
import org.opengis.metadata.distribution.MediumName;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Medium_Type", propOrder={"identifier", "name", "newName", "density", "densities", "densityUnits", "volumes", "mediumFormats", "mediumNote"})
@XmlRootElement(name="MD_Medium")
public class DefaultMedium
extends ISOMetadata
implements Medium {
    private static final long serialVersionUID = 7751002701087451894L;
    private MediumName name;
    private Collection<Double> densities;
    private Unit<?> densityUnits;
    private Integer volumes;
    private Collection<MediumFormat> mediumFormats;
    private InternationalString mediumNote;

    public DefaultMedium() {
    }

    public DefaultMedium(Medium medium) {
        super(medium);
        if (medium != null) {
            this.name = medium.getName();
            this.densities = this.copyCollection(medium.getDensities(), Double.class);
            this.densityUnits = medium.getDensityUnits();
            this.volumes = medium.getVolumes();
            this.mediumFormats = this.copyCollection(medium.getMediumFormats(), MediumFormat.class);
            this.mediumNote = medium.getMediumNote();
            if (medium instanceof DefaultMedium) {
                this.identifiers = this.singleton(((DefaultMedium)medium).getIdentifier(), Identifier.class);
            }
        }
    }

    public static DefaultMedium castOrCopy(Medium medium) {
        if (medium == null || medium instanceof DefaultMedium) {
            return (DefaultMedium)medium;
        }
        return new DefaultMedium(medium);
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/gmd")
    public MediumName getName() {
        return FilterByVersion.LEGACY_METADATA.accept() ? this.name : null;
    }

    public void setName(MediumName mediumName) {
        this.checkWritePermission(this.name);
        this.name = mediumName;
    }

    @XmlElement(name="density")
    @XmlJavaTypeAdapter(value=GO_Real.Since2014.class)
    @ValueRange(minimum=0.0, isMinIncluded=false)
    @UML(identifier="density", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Double getDensity() {
        return LegacyPropertyAdapter.getSingleton(this.densities, Double.class, null, DefaultMedium.class, "getDensity");
    }

    public void setDensity(Double d) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.densities));
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "density", true, d)) {
            this.densities = this.writeCollection(CollectionsExt.singletonOrEmpty(d), this.densities, Double.class);
        }
    }

    @Deprecated
    @Dependencies(value={"getDensity"})
    @XmlElement(name="density", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Double> getDensities() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        this.densities = this.nonNullCollection(this.densities, Double.class);
        return this.densities;
    }

    @Deprecated
    public void setDensities(Collection<? extends Double> collection) {
        this.densities = this.writeCollection(collection, this.densities, Double.class);
    }

    @XmlElement(name="densityUnits")
    public Unit<?> getDensityUnits() {
        return this.densityUnits;
    }

    public void setDensityUnits(Unit<?> unit) {
        this.checkWritePermission(this.densityUnits);
        this.densityUnits = unit;
    }

    @ValueRange(minimum=0.0)
    @XmlElement(name="volumes")
    public Integer getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Integer n) {
        this.checkWritePermission(this.volumes);
        if (ImplementationHelper.ensurePositive(DefaultMedium.class, "volumes", false, n)) {
            this.volumes = n;
        }
    }

    @XmlElement(name="mediumFormat")
    public Collection<MediumFormat> getMediumFormats() {
        this.mediumFormats = this.nonNullCollection(this.mediumFormats, MediumFormat.class);
        return this.mediumFormats;
    }

    public void setMediumFormats(Collection<? extends MediumFormat> collection) {
        this.mediumFormats = this.writeCollection(collection, this.mediumFormats, MediumFormat.class);
    }

    @XmlElement(name="mediumNote")
    public InternationalString getMediumNote() {
        return this.mediumNote;
    }

    public void setMediumNote(InternationalString internationalString) {
        this.checkWritePermission(this.mediumNote);
        this.mediumNote = internationalString;
    }

    @Override
    @XmlElement(name="identifier")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="identifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    @Override
    public void setIdentifier(Identifier identifier) {
        super.setIdentifier(identifier);
    }

    @XmlElement(name="name")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    private Citation getNewName() {
        return this.name != null ? new DefaultCitation(this.name.name()) : null;
    }

    private void setNewName(Citation citation) {
        InternationalString internationalString;
        if (citation != null && (internationalString = citation.getTitle()) != null) {
            this.name = CodeLists.forName(MediumName.class, internationalString.toString(), false);
        }
    }
}

