/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.lan.LocaleAndCharset;
import org.apache.sis.internal.jaxb.lan.PT_Locale;
import org.apache.sis.internal.metadata.Dependencies;
import org.apache.sis.internal.metadata.ImplementationHelper;
import org.apache.sis.internal.metadata.legacy.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.content.AbstractContentInformation;
import org.apache.sis.metadata.iso.content.DefaultFeatureTypeInfo;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.content.FeatureCatalogueDescription;
import org.opengis.util.GenericName;

@XmlType(name="MD_FeatureCatalogueDescription_Type", propOrder={"compliant", "locale", "languages", "includedWithDataset", "featureTypesInfo", "featureTypes", "featureCatalogueCitations"})
@XmlRootElement(name="MD_FeatureCatalogueDescription")
public class DefaultFeatureCatalogueDescription
extends AbstractContentInformation
implements FeatureCatalogueDescription {
    private static final long serialVersionUID = 4637544662644655274L;
    private Boolean compliant;
    private Map<Locale, Charset> locales;
    private boolean includedWithDataset;
    private Collection<DefaultFeatureTypeInfo> featureTypes;
    private Collection<Citation> featureCatalogueCitations;

    public DefaultFeatureCatalogueDescription() {
    }

    public DefaultFeatureCatalogueDescription(FeatureCatalogueDescription featureCatalogueDescription) {
        super((ContentInformation)featureCatalogueDescription);
        if (featureCatalogueDescription != null) {
            this.compliant = featureCatalogueDescription.isCompliant();
            this.includedWithDataset = featureCatalogueDescription.isIncludedWithDataset();
            this.featureCatalogueCitations = this.copyCollection(featureCatalogueDescription.getFeatureCatalogueCitations(), Citation.class);
            if (featureCatalogueDescription instanceof DefaultFeatureCatalogueDescription) {
                this.locales = this.copyMap(((DefaultFeatureCatalogueDescription)featureCatalogueDescription).getLocalesAndCharsets(), Locale.class);
                this.featureTypes = this.copyCollection(((DefaultFeatureCatalogueDescription)featureCatalogueDescription).getFeatureTypeInfo(), DefaultFeatureTypeInfo.class);
            } else {
                this.setLanguages(this.copyCollection(featureCatalogueDescription.getLanguages(), Locale.class));
                this.setFeatureTypes(featureCatalogueDescription.getFeatureTypes());
            }
        }
    }

    public static DefaultFeatureCatalogueDescription castOrCopy(FeatureCatalogueDescription featureCatalogueDescription) {
        if (featureCatalogueDescription == null || featureCatalogueDescription instanceof DefaultFeatureCatalogueDescription) {
            return (DefaultFeatureCatalogueDescription)featureCatalogueDescription;
        }
        return new DefaultFeatureCatalogueDescription(featureCatalogueDescription);
    }

    @XmlElement(name="complianceCode")
    public Boolean isCompliant() {
        return this.compliant;
    }

    public void setCompliant(Boolean bl) {
        this.checkWritePermission(this.compliant);
        this.compliant = bl;
    }

    @UML(identifier="locale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> map) {
        this.locales = this.writeMap(map, this.locales, Locale.class);
    }

    @Deprecated
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated
    public void setLanguages(Collection<? extends Locale> collection) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), collection));
    }

    @XmlElement(name="includedWithDataset")
    public boolean isIncludedWithDataset() {
        return this.includedWithDataset;
    }

    public void setIncludedWithDataset(boolean bl) {
        this.checkWritePermission(this.includedWithDataset ? Boolean.TRUE : null);
        this.includedWithDataset = bl;
    }

    @UML(identifier="featureTypes", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultFeatureTypeInfo> getFeatureTypeInfo() {
        this.featureTypes = this.nonNullCollection(this.featureTypes, DefaultFeatureTypeInfo.class);
        return this.featureTypes;
    }

    public void setFeatureTypeInfo(Collection<? extends DefaultFeatureTypeInfo> collection) {
        this.featureTypes = this.writeCollection(collection, this.featureTypes, DefaultFeatureTypeInfo.class);
    }

    @Deprecated
    @Dependencies(value={"getFeatureTypeInfo"})
    @XmlElement(name="featureTypes", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<GenericName> getFeatureTypes() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new LegacyPropertyAdapter<GenericName, DefaultFeatureTypeInfo>(this.getFeatureTypeInfo()){

            @Override
            protected DefaultFeatureTypeInfo wrap(GenericName genericName) {
                return new DefaultFeatureTypeInfo(genericName);
            }

            @Override
            protected GenericName unwrap(DefaultFeatureTypeInfo defaultFeatureTypeInfo) {
                return defaultFeatureTypeInfo.getFeatureTypeName();
            }

            @Override
            protected boolean update(DefaultFeatureTypeInfo defaultFeatureTypeInfo, GenericName genericName) {
                if (defaultFeatureTypeInfo instanceof DefaultFeatureTypeInfo) {
                    defaultFeatureTypeInfo.setFeatureTypeName(genericName);
                    return true;
                }
                return false;
            }
        }.validOrNull();
    }

    @Deprecated
    public void setFeatureTypes(Collection<? extends GenericName> collection) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.featureTypes));
        ((LegacyPropertyAdapter)this.getFeatureTypes()).setValues(collection);
    }

    @XmlElement(name="featureCatalogueCitation")
    public Collection<Citation> getFeatureCatalogueCitations() {
        this.featureCatalogueCitations = this.nonNullCollection(this.featureCatalogueCitations, Citation.class);
        return this.featureCatalogueCitations;
    }

    public void setFeatureCatalogueCitations(Collection<? extends Citation> collection) {
        this.featureCatalogueCitations = this.writeCollection(collection, this.featureCatalogueCitations, Citation.class);
    }

    @XmlElement(name="featureTypes")
    private Collection<DefaultFeatureTypeInfo> getFeatureTypesInfo() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getFeatureTypeInfo() : null;
    }

    @XmlElement(name="locale")
    private Collection<PT_Locale> getLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.wrap(this.locales) : null;
    }
}

