/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.sis.internal.simple.SimpleIdentifier;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.DomainRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.opengis.annotation.UML;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.Obligation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

final class PropertyInformation<E>
extends SimpleIdentifier
implements ExtendedElementInformation,
CheckedContainer<E> {
    private static final long serialVersionUID = 6279709738674566891L;
    private final Class<?> parent;
    private final Class<E> elementType;
    private final byte minimumOccurs;
    private final byte maximumOccurs;
    private volatile Object domainValue;

    PropertyInformation(Citation citation, String string, Method method, Class<E> clazz, ValueRange valueRange) {
        super(citation, string, method.isAnnotationPresent(Deprecated.class));
        Class<?> clazz2;
        this.parent = method.getDeclaringClass();
        this.elementType = clazz;
        UML uML = method.getAnnotation(UML.class);
        int n = 0;
        int n2 = 1;
        if (uML != null) {
            switch (uML.obligation()) {
                case MANDATORY: {
                    n = 1;
                    break;
                }
                case FORBIDDEN: {
                    n2 = 0;
                    break;
                }
                case CONDITIONAL: {
                    n = -1;
                }
            }
        }
        if (n2 != 0 && ((clazz2 = method.getReturnType()).isArray() || Collection.class.isAssignableFrom(clazz2))) {
            n2 = -1;
        }
        this.minimumOccurs = n;
        this.maximumOccurs = n2;
        this.domainValue = valueRange;
    }

    public String getName() {
        return this.code;
    }

    @Override
    public final String getCodeSpace() {
        String string = Types.getStandardName(this.parent);
        if (string == null) {
            string = this.parent.getSimpleName();
        }
        return string;
    }

    @Deprecated
    public String getShortName() {
        return null;
    }

    @Deprecated
    public Integer getDomainCode() {
        return null;
    }

    public final InternationalString getDefinition() {
        return Types.getDescription(this.parent, this.code);
    }

    public Obligation getObligation() {
        switch (this.minimumOccurs) {
            case -1: {
                return Obligation.CONDITIONAL;
            }
            case 0: {
                return Obligation.OPTIONAL;
            }
        }
        return Obligation.MANDATORY;
    }

    public InternationalString getCondition() {
        return null;
    }

    public Datatype getDataType() {
        if (CharSequence.class.isAssignableFrom(this.elementType)) {
            return Datatype.CHARACTER_STRING;
        }
        if (CodeList.class.isAssignableFrom(this.elementType)) {
            return Datatype.CODE_LIST;
        }
        if (Enum.class.isAssignableFrom(this.elementType)) {
            return Datatype.ENUMERATION;
        }
        if (Numbers.isInteger(this.elementType)) {
            return Datatype.INTEGER;
        }
        return Datatype.TYPE_CLASS;
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    public Integer getMaximumOccurrence() {
        int n = Byte.toUnsignedInt(this.maximumOccurs);
        return n == 255 ? Integer.MAX_VALUE : n;
    }

    public InternationalString getDomainValue() {
        DomainRange<E> domainRange = this.domainValue;
        if (domainRange != null && !(domainRange instanceof DomainRange)) {
            try {
                domainRange = new DomainRange<E>(this.elementType, (ValueRange)((Object)domainRange));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Logging.unexpectedException(Logger.getLogger("org.apache.sis.metadata"), PropertyInformation.class, "getDomainValue", illegalArgumentException);
                domainRange = null;
            }
            this.domainValue = domainRange;
        }
        return domainRange;
    }

    public Collection<String> getParentEntity() {
        return Collections.singleton(this.getCodeSpace());
    }

    public InternationalString getRule() {
        return null;
    }

    public InternationalString getRationale() {
        return null;
    }

    @Deprecated
    public Collection<InternationalString> getRationales() {
        return Collections.emptyList();
    }

    public Collection<? extends ResponsibleParty> getSources() {
        return this.authority.getCitedResponsibleParties();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PropertyInformation propertyInformation = (PropertyInformation)object;
            return this.parent == propertyInformation.parent && this.elementType == propertyInformation.elementType && this.minimumOccurs == propertyInformation.minimumOccurs && this.maximumOccurs == propertyInformation.maximumOccurs;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.parent.hashCode() + 31 * this.code.hashCode() ^ 0x6A4236EB;
    }

    @Override
    protected void appendStringTo(StringBuilder stringBuilder) {
        stringBuilder.append(" : ").append(Types.getCodeLabel(this.getDataType())).append(", ").append(this.getObligation().name().toLowerCase(Locale.US)).append(", maxOccurs=");
        int n = this.getMaximumOccurrence();
        if (n != Integer.MAX_VALUE) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append('\u221e');
        }
        InternationalString internationalString = this.getDomainValue();
        if (internationalString != null) {
            stringBuilder.append(", domain=").append((CharSequence)internationalString);
        }
    }
}

