/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.TypeName;

abstract class Parameter<T>
extends SimpleIdentifiedObject
implements ParameterDescriptor<T> {
    private volatile transient ParameterDescriptor<T> descriptor;

    Parameter() {
    }

    Parameter(ParameterDescriptor<T> parameterDescriptor) {
        super((IdentifiedObject)parameterDescriptor);
        this.descriptor = parameterDescriptor;
    }

    public TypeName getValueType() {
        return ReferencingServices.getInstance().getValueType(this.descriptor);
    }

    public Class<T> getValueClass() {
        ParameterDescriptor<T> parameterDescriptor = this.descriptor;
        return parameterDescriptor != null ? parameterDescriptor.getValueClass() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ParameterValue<T> createValue() {
        ParameterDescriptor<T> parameterDescriptor;
        Parameter parameter = this;
        synchronized (parameter) {
            parameterDescriptor = this.descriptor;
            if (parameterDescriptor == null) {
                this.descriptor = parameterDescriptor = ReferencingServices.getInstance().toImplementation(this);
            }
        }
        return parameterDescriptor.createValue();
    }

    public Set<T> getValidValues() {
        return null;
    }

    public Comparable<T> getMinimumValue() {
        return null;
    }

    public Comparable<T> getMaximumValue() {
        return null;
    }

    public T getDefaultValue() {
        return null;
    }

    public Unit<?> getUnit() {
        return null;
    }

    @Override
    public final boolean equals(Object object, ComparisonMode comparisonMode) {
        ParameterDescriptor parameterDescriptor;
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode) && object instanceof ParameterDescriptor && (parameterDescriptor = (ParameterDescriptor)object).getUnit() == null && parameterDescriptor.getDefaultValue() == null && parameterDescriptor.getValueClass() == this.getValueClass()) {
            if (comparisonMode.isIgnoringMetadata()) {
                return Objects.equals(Parameter.toString((Identifier)this.getName()), Parameter.toString((Identifier)parameterDescriptor.getName()));
            }
            return parameterDescriptor.getMinimumOccurs() == this.getMinimumOccurs() && parameterDescriptor.getMaximumOccurs() == this.getMaximumOccurs() && parameterDescriptor.getValidValues() == null && parameterDescriptor.getMinimumValue() == null && parameterDescriptor.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

