/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.CascadedStoreEvent;
import org.apache.sis.storage.event.CloseEvent;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;

public class StoreListeners
implements Localized {
    private final StoreListeners parent;
    private final Resource source;
    private volatile ForType<?> listeners;
    private volatile Set<Class<? extends StoreEvent>> permittedEventTypes;
    private static final Set<Class<? extends StoreEvent>> READ_EVENT_TYPES = JDK9.setOf(WarningEvent.class, CloseEvent.class);
    private Map<Class<?>, StoreListener<?>> cascadedListeners;

    public StoreListeners(StoreListeners storeListeners, Resource resource) {
        ArgumentChecks.ensureNonNull("source", resource);
        this.source = resource;
        this.parent = storeListeners;
        if (storeListeners != null) {
            this.permittedEventTypes = storeListeners.permittedEventTypes;
        }
    }

    public Optional<StoreListeners> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Resource getSource() {
        return this.source;
    }

    private static DataStore getDataStore(StoreListeners storeListeners) {
        do {
            DataStore dataStore;
            Resource resource;
            if ((resource = storeListeners.source) instanceof StoreResource && (dataStore = ((StoreResource)resource).getOriginator()) != null) {
                return dataStore;
            }
            if (!(resource instanceof DataStore)) continue;
            return (DataStore)resource;
        } while ((storeListeners = storeListeners.parent) != null);
        return null;
    }

    public String getSourceName() {
        DataStore dataStore = StoreListeners.getDataStore(this);
        if (dataStore != null) {
            String string = dataStore.getDisplayName();
            if (string != null) {
                return string;
            }
            DataStoreProvider dataStoreProvider = dataStore.getProvider();
            if (dataStoreProvider != null && (string = dataStoreProvider.getShortName()) != null) {
                return string;
            }
        }
        return Vocabulary.getResources(this.getLocale()).getString((short)208);
    }

    @Override
    public Locale getLocale() {
        DataStore dataStore = StoreListeners.getDataStore(this);
        return dataStore != null ? dataStore.getLocale() : null;
    }

    public Logger getLogger() {
        Resource resource = this.source;
        DataStore dataStore = StoreListeners.getDataStore(this);
        if (dataStore != null) {
            Logger logger;
            DataStoreProvider dataStoreProvider = dataStore.getProvider();
            if (dataStoreProvider != null && (logger = dataStoreProvider.getLogger()) != null) {
                return logger;
            }
            resource = dataStore;
        }
        return Logging.getLogger(resource.getClass());
    }

    @Deprecated
    public void useWarningEventsOnly() {
        this.useReadOnlyEvents();
    }

    public void warning(String string) {
        ArgumentChecks.ensureNonNull("message", string);
        this.warning(Level.WARNING, string, null);
    }

    public void warning(Exception exception) {
        ArgumentChecks.ensureNonNull("exception", exception);
        this.warning(Level.WARNING, null, exception);
    }

    public void warning(String string, Exception exception) {
        this.warning(Level.WARNING, string, exception);
    }

    public void warning(Level level, String string, Exception exception) {
        LogRecord logRecord;
        StackTraceElement[] stackTraceElementArray;
        ArgumentChecks.ensureNonNull("level", level);
        if (exception != null) {
            stackTraceElementArray = exception.getStackTrace();
            string = Exceptions.formatChainedMessages(this.getLocale(), string, exception);
            if (string == null) {
                string = exception.toString();
            }
            logRecord = new LogRecord(level, string);
            logRecord.setThrown(exception);
        } else {
            ArgumentChecks.ensureNonEmpty("message", string);
            stackTraceElementArray = Thread.currentThread().getStackTrace();
            logRecord = new LogRecord(level, string);
        }
        try {
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                if (StoreListeners.setPublicSource(logRecord, Class.forName(stackTraceElement.getClassName()), stackTraceElement.getMethodName())) break;
            }
        }
        catch (ClassNotFoundException | SecurityException exception2) {
            Logging.ignorableException(StoreUtilities.LOGGER, StoreListeners.class, "warning", exception2);
        }
        this.warning(logRecord, StoreUtilities.removeStackTraceInLogs());
    }

    private static boolean setPublicSource(LogRecord logRecord, Class<?> clazz, String string) {
        if (Resource.class.isAssignableFrom(clazz)) {
            logRecord.setSourceClassName(clazz.getCanonicalName());
            logRecord.setSourceMethodName(string);
            for (Method method : clazz.getMethods()) {
                if (!string.equals(method.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void warning(LogRecord logRecord) {
        this.warning(logRecord, null);
    }

    public void warning(LogRecord logRecord, Filter filter) {
        if (!this.fire(WarningEvent.class, new WarningEvent(this.source, logRecord)) && (filter == null || filter.isLoggable(logRecord))) {
            Logger logger;
            String string = logRecord.getLoggerName();
            if (string != null) {
                logger = Logger.getLogger(string);
            } else {
                logger = this.getLogger();
                logRecord.setLoggerName(logger.getName());
            }
            logger.log(logRecord);
        }
    }

    static void canNotNotify(String string, ExecutionException executionException) {
        Logging.unexpectedException(Logger.getLogger("org.apache.sis.storage"), StoreListeners.class, string, executionException);
    }

    @Deprecated
    public <E extends StoreEvent> boolean fire(E e, Class<E> clazz) {
        return this.fire(clazz, e);
    }

    public <E extends StoreEvent> boolean fire(Class<E> clazz, E e) {
        ArgumentChecks.ensureNonNull("event", e);
        ArgumentChecks.ensureNonNull("eventType", clazz);
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        if (set != null && !set.contains(clazz)) {
            throw this.illegalEventType(clazz);
        }
        try {
            return StoreListeners.fire(this, clazz, e);
        }
        catch (ExecutionException executionException) {
            StoreListeners.canNotNotify("fire", executionException);
            return true;
        }
    }

    static <E extends StoreEvent> boolean fire(StoreListeners storeListeners, Class<E> clazz, E e) throws ExecutionException {
        Map<StoreListener<?>, Boolean> map = null;
        ExecutionException executionException = null;
        do {
            ForType<?> forType = storeListeners.listeners;
            while (forType != null) {
                if (forType.type.isAssignableFrom(clazz)) {
                    try {
                        map = forType.eventOccured(e, map);
                    }
                    catch (ExecutionException executionException2) {
                        if (executionException == null) {
                            executionException = executionException2;
                        }
                        executionException.getCause().addSuppressed(executionException2.getCause());
                    }
                }
                forType = forType.next;
            }
        } while (!e.isConsumedForParent() && (storeListeners = storeListeners.parent) != null);
        if (executionException != null) {
            throw executionException;
        }
        return map != null && !map.isEmpty();
    }

    private IllegalArgumentException illegalEventType(Class<?> clazz) {
        return new IllegalArgumentException(Resources.forLocale(this.getLocale()).getString((short)65, clazz));
    }

    private static boolean isPossibleEvent(Set<Class<? extends StoreEvent>> set, Class<?> clazz) {
        if (set == null) {
            return true;
        }
        for (Class<? extends StoreEvent> clazz2 : set) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    public synchronized <E extends StoreEvent> void addListener(Class<E> clazz, StoreListener<? super E> storeListener) {
        ArgumentChecks.ensureNonNull("listener", storeListener);
        ArgumentChecks.ensureNonNull("eventType", clazz);
        if (StoreListeners.isPossibleEvent(this.permittedEventTypes, clazz)) {
            ForType<Object> forType = null;
            CascadedStoreEvent.ParentListener<E> parentListener = this.listeners;
            while (parentListener != null) {
                if (((ForType)((Object)parentListener)).type.equals(clazz)) {
                    forType = parentListener;
                    break;
                }
                parentListener = ((ForType)((Object)parentListener)).next;
            }
            if (forType == null) {
                forType = new ForType<E>(clazz, this.listeners);
                this.listeners = forType;
            }
            forType.add(storeListener);
            if (this.parent != null && CascadedStoreEvent.class.isAssignableFrom(clazz)) {
                if (this.cascadedListeners == null) {
                    this.cascadedListeners = new IdentityHashMap(4);
                }
                if ((parentListener = this.cascadedListeners.get(clazz)) == null) {
                    parentListener = new CascadedStoreEvent.ParentListener<E>(clazz, this.parent, this);
                    this.cascadedListeners.put(clazz, parentListener);
                    this.parent.addListener(clazz, parentListener);
                }
            }
        }
    }

    public synchronized <E extends StoreEvent> void removeListener(Class<E> clazz, StoreListener<? super E> storeListener) {
        ArgumentChecks.ensureNonNull("listener", storeListener);
        ArgumentChecks.ensureNonNull("eventType", clazz);
        ForType<?> forType = this.listeners;
        while (forType != null) {
            if (forType.type.equals(clazz)) {
                StoreListener<?> storeListener2;
                if (!forType.remove(storeListener) || this.cascadedListeners == null || (storeListener2 = this.cascadedListeners.remove(clazz)) == null) break;
                this.parent.removeListener(clazz, storeListener2);
                break;
            }
            forType = forType.next;
        }
    }

    public <E extends StoreEvent> boolean hasListener(Class<E> clazz, StoreListener<? super E> storeListener) {
        ArgumentChecks.ensureNonNull("listener", storeListener);
        ArgumentChecks.ensureNonNull("eventType", clazz);
        ForType<? super E> forType = this.listeners;
        while (forType != null) {
            if (forType.type.equals(clazz) && forType.hasListener(storeListener)) {
                return true;
            }
            forType = forType.next;
        }
        return false;
    }

    public boolean hasListeners(Class<? extends StoreEvent> clazz) {
        ArgumentChecks.ensureNonNull("eventType", clazz);
        StoreListeners storeListeners = this;
        do {
            ForType<?> forType = storeListeners.listeners;
            while (forType != null) {
                if (clazz.isAssignableFrom(forType.type) && forType.count() != 0) {
                    return true;
                }
                forType = forType.next;
            }
        } while ((storeListeners = storeListeners.parent) != null);
        return false;
    }

    public synchronized void setUsableEventTypes(Class<?> ... classArray) {
        ArgumentChecks.ensureNonEmpty("permitted", classArray);
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        HashSet<Class<? extends StoreEvent>> hashSet = new HashSet<Class<? extends StoreEvent>>(Containers.hashMapCapacity(classArray.length));
        for (Class<?> clazz : classArray) {
            if (!(set != null ? set.contains(clazz) : StoreEvent.class.isAssignableFrom(clazz))) {
                throw this.illegalEventType(clazz);
            }
            hashSet.add(clazz);
        }
        this.permittedEventTypes = READ_EVENT_TYPES.equals(hashSet) ? READ_EVENT_TYPES : CollectionsExt.compact(hashSet);
        ForType.removeUnreachables(this.listeners, hashSet);
    }

    public synchronized void useReadOnlyEvents() {
        Set<Class<? extends StoreEvent>> set = this.permittedEventTypes;
        if (set == null) {
            this.permittedEventTypes = READ_EVENT_TYPES;
        } else if (!READ_EVENT_TYPES.equals(set)) {
            throw this.illegalEventType(WarningEvent.class);
        }
        ForType.removeUnreachables(this.listeners, READ_EVENT_TYPES);
    }

    public void close() {
        try {
            StoreListeners.fire(this, CloseEvent.class, new CloseEvent(this.source));
        }
        catch (ExecutionException executionException) {
            StoreListeners.canNotNotify("close", executionException);
        }
        this.listeners = null;
    }

    public String toString() {
        int n = 0;
        ForType<?> forType = this.listeners;
        while (forType != null) {
            n += forType.count();
            forType = forType.next;
        }
        return Strings.toString(this.getClass(), "parent", this.parent != null ? Classes.getShortClassName(this.parent.source) : null, "source", Classes.getShortClassName(this.source), "count", n);
    }

    private static final class ForType<E extends StoreEvent> {
        final Class<E> type;
        private volatile StoreListener<? super E>[] listeners;
        final ForType<?> next;

        ForType(Class<E> clazz, ForType<?> forType) {
            this.type = clazz;
            this.next = forType;
        }

        final void add(StoreListener<? super E> storeListener) {
            StoreListener<? super E>[] storeListenerArray = this.listeners;
            int n = storeListenerArray != null ? storeListenerArray.length : 0;
            StoreListener[] storeListenerArray2 = new StoreListener[n + 1];
            if (storeListenerArray != null) {
                System.arraycopy(storeListenerArray, 0, storeListenerArray2, 0, n);
            }
            storeListenerArray2[n] = storeListener;
            this.listeners = storeListenerArray2;
        }

        final boolean remove(StoreListener<? super E> storeListener) {
            Object object = this.listeners;
            if (object != null) {
                int n = ((StoreListener<? super E>[])object).length;
                while (--n >= 0) {
                    if (object[n] != storeListener) continue;
                    object = ((StoreListener<? super E>[])object).length == 1 ? null : ArraysExt.remove(object, n, 1);
                    this.listeners = object;
                    break;
                }
            }
            return object == null;
        }

        static void removeUnreachables(ForType<?> forType, Set<Class<? extends StoreEvent>> set) {
            while (forType != null) {
                if (!StoreListeners.isPossibleEvent(set, forType.type)) {
                    forType.listeners = null;
                }
                forType = forType.next;
            }
        }

        final boolean hasListener(StoreListener<?> storeListener) {
            return ArraysExt.containsIdentity(this.listeners, storeListener);
        }

        final int count() {
            return this.listeners != null ? this.listeners.length : 0;
        }

        final Map<StoreListener<?>, Boolean> eventOccured(E e, Map<StoreListener<?>, Boolean> map) throws ExecutionException {
            RuntimeException runtimeException = null;
            StoreListener<? super E>[] storeListenerArray = this.listeners;
            if (storeListenerArray != null) {
                if (map == null) {
                    map = new IdentityHashMap(storeListenerArray.length);
                }
                for (StoreListener<E> storeListener : storeListenerArray) {
                    if (((StoreEvent)e).isConsumed()) break;
                    if (map.put(storeListener, Boolean.TRUE) != null) continue;
                    try {
                        storeListener.eventOccured(e);
                    }
                    catch (RuntimeException runtimeException2) {
                        if (runtimeException == null) {
                            runtimeException = runtimeException2;
                            continue;
                        }
                        runtimeException.addSuppressed(runtimeException2);
                    }
                }
            }
            if (runtimeException != null) {
                throw new ExecutionException(Resources.format((short)74, this.type), runtimeException);
            }
            return map;
        }
    }
}

