/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Locale;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class GroupByCRS<E>
extends Group<E> {
    private final CoordinateReferenceSystem crs;

    private GroupByCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
    }

    @Override
    final String createName(Locale locale) {
        return IdentifiedObjects.getDisplayName((IdentifiedObject)this.crs, (Locale)locale);
    }

    static <E> GroupByCRS<E> getOrAdd(List<GroupByCRS<E>> list, GridGeometry gridGeometry) {
        return GroupByCRS.getOrAdd(list, gridGeometry.isDefined(1) ? gridGeometry.getCoordinateReferenceSystem() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> GroupByCRS<E> getOrAdd(List<GroupByCRS<E>> list, CoordinateReferenceSystem coordinateReferenceSystem) {
        List<GroupByCRS<Object>> list2 = list;
        synchronized (list2) {
            for (GroupByCRS<Object> groupByCRS : list) {
                if (!Utilities.equalsIgnoreMetadata(coordinateReferenceSystem, groupByCRS.crs)) continue;
                return groupByCRS;
            }
            GroupByCRS<E> groupByCRS = new GroupByCRS<E>(coordinateReferenceSystem);
            list.add((GroupByCRS<Object>)groupByCRS);
            return groupByCRS;
        }
    }
}

