/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.GridSlice;
import org.apache.sis.storage.aggregate.Group;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.GroupByCRS;
import org.apache.sis.storage.aggregate.GroupBySample;
import org.apache.sis.storage.aggregate.GroupByTransform;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.collection.BackingStoreException;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public final class CoverageAggregator
extends Group<GroupBySample> {
    private final StoreListeners listeners;
    private final Map<Set<Resource>, Queue<Aggregate>> aggregates;
    private volatile MergeStrategy strategy;

    public CoverageAggregator(StoreListeners storeListeners) {
        this.listeners = storeListeners;
        this.aggregates = new HashMap<Set<Resource>, Queue<Aggregate>>();
    }

    @Override
    final String createName(Locale locale) {
        return this.listeners != null ? this.listeners.getSourceName() : null;
    }

    public void addAll(Stream<? extends GridCoverageResource> stream) throws DataStoreException {
        try {
            stream.forEach(gridCoverageResource -> {
                try {
                    this.add((GridCoverageResource)gridCoverageResource);
                }
                catch (DataStoreException dataStoreException) {
                    throw new BackingStoreException(dataStoreException);
                }
            });
        }
        catch (BackingStoreException backingStoreException) {
            throw backingStoreException.unwrapOrRethrow(DataStoreException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(GridCoverageResource gridCoverageResource) throws DataStoreException {
        List list;
        GroupBySample groupBySample = GroupBySample.getOrAdd(this.members, gridCoverageResource.getSampleDimensions());
        GridSlice gridSlice = new GridSlice(gridCoverageResource);
        try {
            list = gridSlice.getList((List<GroupByCRS<GroupByTransform>>)groupBySample.members, (MergeStrategy)this.strategy).members;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new DataStoreContentException(noninvertibleTransformException);
        }
        List list2 = list;
        synchronized (list2) {
            list.add(gridSlice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addComponents(Aggregate aggregate) throws DataStoreException {
        boolean bl = false;
        Set set2 = Collections.newSetFromMap(new IdentityHashMap());
        for (Resource resource : aggregate.components()) {
            if (set2.add(resource)) {
                if (resource instanceof GridCoverageResource) {
                    this.add((GridCoverageResource)resource);
                    continue;
                }
                if (!(resource instanceof Aggregate)) continue;
                this.addComponents((Aggregate)resource);
                continue;
            }
            bl = true;
        }
        if (!bl && !set2.isEmpty()) {
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                this.aggregates.computeIfAbsent(set2, set -> new ArrayDeque(1)).add(aggregate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Optional<Aggregate> existingAggregate(Resource[] resourceArray) {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        if (Collections.addAll(set, resourceArray)) {
            Queue<Aggregate> queue;
            Map<Set<Resource>, Queue<Aggregate>> map = this.aggregates;
            synchronized (map) {
                queue = this.aggregates.get(set);
            }
            if (queue != null) {
                return Optional.ofNullable(queue.poll());
            }
        }
        return Optional.empty();
    }

    public MergeStrategy getMergeStrategy() {
        return this.strategy;
    }

    public void setMergeStrategy(MergeStrategy mergeStrategy) {
        this.strategy = mergeStrategy;
    }

    public Resource build() {
        GroupAggregate groupAggregate = this.prepareAggregate(this.listeners);
        groupAggregate.fillWithChildAggregates(this, GroupBySample::createComponents);
        return groupAggregate.simplify(this);
    }
}

