/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.internal.storage.MemoryGridResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.RangeArgument;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridCoverage;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.GroupAggregate;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.ArraysExt;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedGridResource
extends AbstractGridCoverageResource
implements AggregatedResource {
    private String name;
    private final GridGeometry gridGeometry;
    private final List<SampleDimension> sampleDimensions;
    final boolean isConverted;
    private final GridCoverageResource[] slices;
    private int[] deferredLoading;
    final GridSliceLocator locator;
    final MergeStrategy strategy;
    private ImmutableEnvelope envelope;
    private boolean envelopeIsEvaluated;
    private double[][] resolutions;

    ConcatenatedGridResource(String string, StoreListeners storeListeners, GridGeometry gridGeometry, List<SampleDimension> list, GridCoverageResource[] gridCoverageResourceArray, GridSliceLocator gridSliceLocator, MergeStrategy mergeStrategy) {
        super(storeListeners, false);
        this.name = string;
        this.gridGeometry = gridGeometry;
        this.sampleDimensions = list;
        this.slices = gridCoverageResourceArray;
        this.locator = gridSliceLocator;
        this.strategy = mergeStrategy;
        this.deferredLoading = new int[Numerics.ceilDiv(gridCoverageResourceArray.length, 32)];
        for (SampleDimension sampleDimension : list) {
            if (sampleDimension.forConvertedValues(true) == sampleDimension) continue;
            this.isConverted = false;
            return;
        }
        this.isConverted = true;
    }

    private ConcatenatedGridResource(ConcatenatedGridResource concatenatedGridResource, MergeStrategy mergeStrategy) {
        super(concatenatedGridResource.listeners, true);
        this.name = concatenatedGridResource.name;
        this.gridGeometry = concatenatedGridResource.gridGeometry;
        this.sampleDimensions = concatenatedGridResource.sampleDimensions;
        this.isConverted = concatenatedGridResource.isConverted;
        this.slices = concatenatedGridResource.slices;
        this.deferredLoading = concatenatedGridResource.deferredLoading;
        this.locator = concatenatedGridResource.locator;
        this.envelope = concatenatedGridResource.envelope;
        this.envelopeIsEvaluated = concatenatedGridResource.envelopeIsEvaluated;
        this.resolutions = concatenatedGridResource.resolutions;
        this.strategy = mergeStrategy;
    }

    @Override
    public final synchronized Resource apply(MergeStrategy mergeStrategy) {
        if (Objects.equals(this.strategy, mergeStrategy)) {
            return this;
        }
        return new ConcatenatedGridResource(this, mergeStrategy);
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        metadataBuilder.addTitle(this.name);
        metadataBuilder.addDefaultMetadata(this, this.listeners);
        return metadataBuilder.build();
    }

    @Override
    public final GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    @Override
    public final List<SampleDimension> getSampleDimensions() {
        return this.sampleDimensions;
    }

    @Override
    public synchronized Optional<Envelope> getEnvelope() throws DataStoreException {
        if (!this.envelopeIsEvaluated) {
            try {
                this.envelope = GroupAggregate.unionOfComponents(this.slices);
            }
            catch (TransformException transformException) {
                this.listeners.warning((Exception)((Object)transformException));
            }
            this.envelopeIsEvaluated = true;
        }
        return Optional.ofNullable(this.envelope);
    }

    @Override
    public synchronized List<double[]> getResolutions() throws DataStoreException {
        double[][] dArray = this.resolutions;
        if (dArray == null) {
            int n = 0;
            for (GridCoverageResource gridCoverageResource : this.slices) {
                double[][] dArray2 = CollectionsExt.toArray(gridCoverageResource.getResolutions(), double[].class);
                if (dArray2 == null) continue;
                if (dArray == null) {
                    dArray = dArray2;
                    n = dArray2.length;
                    continue;
                }
                int n2 = 0;
                block1: for (int i = 0; i < n; ++i) {
                    double[] dArray3 = dArray[i];
                    for (int j = 0; j < dArray2.length; ++j) {
                        if (!Arrays.equals(dArray3, dArray2[j])) continue;
                        dArray[n2++] = dArray3;
                        dArray2[j] = null;
                        continue block1;
                    }
                }
                n = n2;
                if (n == 0) break;
            }
            this.resolutions = dArray = (double[][])ArraysExt.resize(dArray, n);
        }
        return UnmodifiableArrayList.wrap(dArray);
    }

    @Override
    public synchronized RasterLoadingStrategy getLoadingStrategy() throws DataStoreException {
        RasterLoadingStrategy rasterLoadingStrategy = RasterLoadingStrategy.AT_GET_TILE_TIME;
        for (int i = 0; i < this.slices.length; ++i) {
            GridCoverageResource gridCoverageResource = this.slices[i];
            RasterLoadingStrategy rasterLoadingStrategy2 = gridCoverageResource.getLoadingStrategy();
            if (rasterLoadingStrategy2 == null || rasterLoadingStrategy2.ordinal() == 0) {
                RasterLoadingStrategy rasterLoadingStrategy3 = rasterLoadingStrategy2 = this.isDeferred(i) ? RasterLoadingStrategy.AT_RENDER_TIME : RasterLoadingStrategy.AT_READ_TIME;
            }
            if (rasterLoadingStrategy2.ordinal() >= rasterLoadingStrategy.ordinal()) continue;
            rasterLoadingStrategy = rasterLoadingStrategy2;
            if (rasterLoadingStrategy2.ordinal() == 0) break;
        }
        return rasterLoadingStrategy;
    }

    @Override
    public synchronized boolean setLoadingStrategy(RasterLoadingStrategy rasterLoadingStrategy) throws DataStoreException {
        boolean bl = rasterLoadingStrategy.ordinal() != 0;
        int[] nArray = new int[this.deferredLoading.length];
        boolean bl2 = true;
        for (int i = 0; i < this.slices.length; ++i) {
            GridCoverageResource gridCoverageResource = this.slices[i];
            if (gridCoverageResource.setLoadingStrategy(rasterLoadingStrategy)) continue;
            if (bl) {
                int n = i >>> 5;
                nArray[n] = nArray[n] | 1 << i;
            }
            bl2 = false;
        }
        if (!Arrays.equals(this.deferredLoading, nArray)) {
            this.deferredLoading = nArray;
        }
        return bl2;
    }

    private boolean isDeferred(int n) {
        return (this.deferredLoading[n >>> 5] & 1 << n) != 0;
    }

    @Override
    public GridCoverage read(GridGeometry gridGeometry, int ... nArray) throws DataStoreException {
        Object[] objectArray;
        if (nArray != null) {
            nArray = RangeArgument.validate(this.sampleDimensions.size(), nArray, this.listeners).getSelectedBands();
        }
        int n = 0;
        int n2 = this.slices.length;
        if (gridGeometry != null) {
            GridDerivation gridDerivation = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(gridGeometry);
            gridGeometry = gridDerivation.build();
            objectArray = gridDerivation.getIntersection();
            n2 = this.locator.getUpper((GridExtent)objectArray, n, n2);
            n = this.locator.getLower((GridExtent)objectArray, n, n2);
        }
        int n3 = n2 - n;
        objectArray = new Object[n3];
        GridGeometry[] gridGeometryArray = new GridGeometry[n3];
        int[] nArray2 = null;
        for (int i = 0; i < n3; ++i) {
            GridCoverage gridCoverage;
            int n4 = n + i;
            GridCoverageResource gridCoverageResource = this.slices[n4];
            if (gridCoverageResource instanceof MemoryGridResource) {
                gridCoverage = ((MemoryGridResource)gridCoverageResource).coverage;
                objectArray[i] = gridCoverage;
                gridGeometryArray[i] = gridCoverage.getGridGeometry();
                continue;
            }
            if (!this.isDeferred(n4) || n3 <= 1) {
                gridCoverage = gridCoverageResource.read(gridGeometry, nArray);
                objectArray[i] = gridCoverage;
                gridGeometryArray[i] = gridCoverage.getGridGeometry();
                continue;
            }
            objectArray[i] = gridCoverageResource;
            gridGeometryArray[i] = gridCoverageResource.getGridGeometry();
            if (nArray2 == null) {
                nArray2 = new int[Numerics.ceilDiv(n3, 32)];
            }
            int n5 = i >>> 5;
            nArray2[n5] = nArray2[n5] | 1 << i;
        }
        if (n3 == 1) {
            return (GridCoverage)objectArray[0];
        }
        if (Arrays.equals(nArray2, this.deferredLoading)) {
            nArray2 = this.deferredLoading;
        }
        GridGeometry gridGeometry2 = this.locator.union(this.gridGeometry, Arrays.asList(gridGeometryArray), GridGeometry::getExtent);
        return new ConcatenatedGridCoverage(this, gridGeometry2, objectArray, n, nArray2, gridGeometry, nArray);
    }
}

