/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.SubspaceNotSpecifiedException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.aggregate.ConcatenatedGridResource;
import org.apache.sis.storage.aggregate.GridSliceLocator;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedGridCoverage
extends GridCoverage {
    private final GridSliceLocator locator;
    private final int startAt;
    private final Loader loader;
    private final Object[] slices;
    private final boolean isConverted;
    private final MergeStrategy strategy;

    ConcatenatedGridCoverage(ConcatenatedGridResource concatenatedGridResource, GridGeometry gridGeometry, Object[] objectArray, int n, int[] nArray, GridGeometry gridGeometry2, int[] nArray2) {
        super(gridGeometry, concatenatedGridResource.getSampleDimensions());
        this.loader = nArray != null ? new Loader(nArray, gridGeometry2, nArray2) : null;
        this.slices = objectArray;
        this.startAt = n;
        this.isConverted = concatenatedGridResource.isConverted;
        this.locator = concatenatedGridResource.locator;
        this.strategy = concatenatedGridResource.strategy;
    }

    private ConcatenatedGridCoverage(ConcatenatedGridCoverage concatenatedGridCoverage, Object[] objectArray, List<SampleDimension> list, boolean bl) {
        super(concatenatedGridCoverage.getGridGeometry(), list);
        this.slices = objectArray;
        this.loader = concatenatedGridCoverage.loader;
        this.startAt = concatenatedGridCoverage.startAt;
        this.locator = concatenatedGridCoverage.locator;
        this.strategy = concatenatedGridCoverage.strategy;
        this.isConverted = bl;
    }

    private boolean isDeferred(int n) {
        return this.loader == null || (this.loader.deferred[n >>> 5] & 1 << n) != 0;
    }

    @Override
    protected GridCoverage createConvertedValues(boolean bl) {
        List<SampleDimension> list;
        boolean bl2 = false;
        GridCoverage gridCoverage = null;
        Object[] objectArray = (Object[])this.slices.clone();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isDeferred(i)) {
                GridCoverage gridCoverage2 = (GridCoverage)objectArray[i];
                objectArray[i] = gridCoverage2.forConvertedValues(bl);
                bl2 |= objectArray[i] != gridCoverage2;
                gridCoverage = gridCoverage2;
                continue;
            }
            bl2 |= bl != this.isConverted;
        }
        if (!bl2) {
            return this;
        }
        if (gridCoverage != null) {
            list = gridCoverage.getSampleDimensions();
        } else {
            list = new ArrayList<SampleDimension>(this.getSampleDimensions());
            list.replaceAll(sampleDimension -> sampleDimension.forConvertedValues(bl));
        }
        return new ConcatenatedGridCoverage(this, objectArray, list, bl);
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) {
        Object object;
        int n;
        GridGeometry[] gridGeometryArray;
        GridGeometry gridGeometry;
        int n2 = this.startAt;
        int n3 = n2 + this.slices.length;
        if (gridExtent != null) {
            n3 = this.locator.getUpper(gridExtent, n2, n3);
            n2 = this.locator.getLower(gridExtent, n2, n3);
        } else {
            gridExtent = this.gridGeometry.getExtent();
        }
        int n4 = n3 - n2;
        if (n4 > 1) {
            if (this.strategy == null) {
                Object[] objectArray;
                short s;
                if (this.locator.isSlice(gridExtent)) {
                    s = 79;
                    objectArray = new Object[]{this.locator.getDimensionName(gridExtent), n2, n4};
                } else {
                    s = 80;
                    objectArray = new Object[]{this.locator.getDimensionName(gridExtent), n4};
                }
                throw new SubspaceNotSpecifiedException(Resources.format(s, objectArray));
            }
            try {
                gridGeometry = new GridGeometry(this.getGridGeometry(), gridExtent, null);
                gridGeometryArray = new GridGeometry[n4];
                for (int i = 0; i < n4; ++i) {
                    n = n2 + i;
                    object = this.slices[n];
                    gridGeometryArray[i] = this.isDeferred(n) ? ((GridCoverageResource)object).getGridGeometry() : ((GridCoverage)object).getGridGeometry();
                }
            }
            catch (DataStoreException | TransformException throwable) {
                throw new CannotEvaluateException(Resources.format((short)81), throwable);
            }
        } else {
            gridGeometry = null;
            gridGeometryArray = null;
        }
        DisjointExtentException disjointExtentException = null;
        if (n4 > 0) {
            while (true) {
                GridCoverage gridCoverage;
                n = n2;
                if (gridGeometryArray != null) {
                    object = this.strategy.apply(gridGeometry, gridGeometryArray);
                    if (object == null) break;
                    gridGeometryArray[((Integer)object).intValue()] = null;
                    n += ((Integer)object).intValue();
                }
                object = this.slices[n];
                if (!this.isDeferred(n)) {
                    gridCoverage = (GridCoverage)object;
                } else {
                    try {
                        gridCoverage = this.loader.getOrLoad(n, (GridCoverageResource)object).forConvertedValues(this.isConverted);
                    }
                    catch (DataStoreException dataStoreException) {
                        throw new CannotEvaluateException(Resources.format((short)78, n + this.startAt), dataStoreException);
                    }
                }
                try {
                    RenderedImage renderedImage = gridCoverage.render(this.locator.toSliceExtent(gridExtent, n));
                    if (disjointExtentException != null) {
                        Logging.ignorableException(Logger.getLogger("org.apache.sis.storage"), ConcatenatedGridCoverage.class, "render", disjointExtentException);
                    }
                    return renderedImage;
                }
                catch (DisjointExtentException disjointExtentException2) {
                    if (disjointExtentException == null) {
                        disjointExtentException = disjointExtentException2;
                        continue;
                    }
                    disjointExtentException.addSuppressed(disjointExtentException2);
                    if (gridGeometryArray != null) continue;
                }
                break;
            }
        }
        if (disjointExtentException == null) {
            disjointExtentException = new DisjointExtentException(this.gridGeometry.getExtent(), gridExtent, this.locator.searchDimension);
        }
        throw disjointExtentException;
    }

    private static final class Loader {
        final int[] deferred;
        private final GridGeometry domain;
        private final int[] ranges;
        private final Cache<Integer, GridCoverage> coverages;

        Loader(int[] nArray, GridGeometry gridGeometry, int[] nArray2) {
            this.deferred = nArray;
            this.domain = gridGeometry;
            this.ranges = nArray2;
            this.coverages = new Cache(15, 2L, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final GridCoverage getOrLoad(Integer n, GridCoverageResource gridCoverageResource) throws DataStoreException {
            GridCoverage gridCoverage = this.coverages.peek(n);
            if (gridCoverage == null) {
                Cache.Handler<GridCoverage> handler = this.coverages.lock(n);
                try {
                    gridCoverage = handler.peek();
                    if (gridCoverage == null) {
                        gridCoverage = gridCoverageResource.read(this.domain, this.ranges);
                    }
                }
                finally {
                    handler.putAndUnlock(gridCoverage);
                }
            }
            return gridCoverage;
        }
    }
}

