/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Collection;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.lineage.DefaultSource;
import org.apache.sis.metadata.iso.maintenance.DefaultScope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Resolution;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.Scope;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

final class ResourceLineage {
    private InternationalString description;
    private Citation sourceCitation;
    private DefaultScope scope;
    private ReferenceSystem referenceSystem;
    private Resolution resolution;

    final boolean isEmpty() {
        return this.description == null && this.sourceCitation == null && this.scope == null && this.referenceSystem == null && this.resolution == null;
    }

    ResourceLineage(Metadata metadata) {
        Object object22;
        this.referenceSystem = (ReferenceSystem)CollectionsExt.first(metadata.getReferenceSystemInfo());
        for (Object object22 : CollectionsExt.nonNull(metadata.getIdentificationInfo())) {
            Citation citation = object22.getCitation();
            if (citation != null) {
                if (this.sourceCitation == null) {
                    this.sourceCitation = citation;
                }
                if (this.description == null) {
                    this.description = citation.getTitle();
                }
            }
            if (this.resolution != null || !(object22 instanceof DataIdentification)) continue;
            for (Resolution resolution : CollectionsExt.nonNull(((DataIdentification)object22).getSpatialResolutions())) {
                if (resolution == null) continue;
                this.resolution = resolution;
            }
        }
        ScopeCode scopeCode = ResourceLineage.getScopeLevel(metadata);
        object22 = Extents.fromIdentificationInfo((Metadata)metadata);
        if (scopeCode != null || !object22.isEmpty()) {
            this.scope = new DefaultScope(scopeCode);
            this.scope.setExtents((Collection)object22);
        }
    }

    private static ScopeCode getScopeLevel(Metadata metadata) {
        ScopeCode scopeCode = null;
        for (ScopeCode scopeCode2 : CollectionsExt.nonNull(metadata.getHierarchyLevels())) {
            if (scopeCode2 == null) continue;
            if (scopeCode == null) {
                scopeCode = scopeCode2;
                continue;
            }
            if (scopeCode.equals((Object)scopeCode2)) continue;
            scopeCode = null;
            break;
        }
        return scopeCode;
    }

    final DefaultSource build() {
        DefaultSource defaultSource = new DefaultSource();
        defaultSource.setDescription(this.description);
        defaultSource.setSourceCitation(this.sourceCitation);
        defaultSource.setScope((Scope)this.scope);
        defaultSource.setSourceReferenceSystem(this.referenceSystem);
        defaultSource.setSourceSpatialResolution(this.resolution);
        return defaultSource;
    }
}

