/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.internal.simple;

import org.apache.sis.test.TestCase;
import org.junit.Test;

import static org.junit.Assert.*;


/**
 * Tests {@link SimpleIdentifier}.
 *
 * @author  Martin Desruisseaux (Geomatys)
 * @version 0.3
 * @since   0.3
 * @module
 */
public final strictfp class SimpleIdentifierTest extends TestCase {
    /**
     * Tests {@link SimpleIdentifier#toString()}.
     */
    @Test
    public void testToString() {
        final SimpleCitation authority = new SimpleCitation("EPSG");
        assertEquals("SimpleIdentifier[“EPSG:4326”]", new SimpleIdentifier(authority, "4326", false).toString());
        assertEquals("SimpleIdentifier[“EPSG”]",      new SimpleIdentifier(authority,  null,  false).toString());
        assertEquals("SimpleIdentifier[“4326”]",      new SimpleIdentifier(null,      "4326", false).toString());
        assertEquals("SimpleIdentifier[]",            new SimpleIdentifier(null,       null,  false).toString());
    }
}
