/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sis.internal.book;


/**
 * Localized resources, for internal usage only.
 *
 * @author  Martin Desruisseaux (Geomatys)
 * @version 0.7
 * @since   0.7
 */
public final class Resources_fr extends Resources {
    /**
     * Invoked by resource bundle reflection mechanism.
     */
    public Resources_fr() {
    }

    /**
     * Returns resources as pair of key-value.
     *
     * @return an array of key-value pairs.
     */
    @Override
    protected Object[][] getContents() {
        final Object[][] resources = super.getContents();
        resources[0][1] = "Chapitre précédent";
        resources[1][1] = "Chapitre suivant";
        resources[2][1] = "Dans ce chapitre:";
        return resources;
    }
}
